!    COLOR HELIX PALETTE GENERATOR
!    Copyright (C) 2011,2012 by Ingo Thies
!
!    Colorhelix is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 2 of the License, or
!    (at your option) any later version.
!
!    Colorhelix is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with Colorhelix. If not, see <http://www.gnu.org/licenses/>.
!
PROGRAM colorhelix_main
  USE colorhelix_module
  IMPLICIT NONE
  INTEGER :: i,ntot,ifull(0:1)
  DOUBLE PRECISION :: x,gray,xyztest(1:3),rgbtest(1:3),mdata(0:2)
  DOUBLE PRECISION :: savesat,savesat_noclip,savesat_monotonic,stderr
  verbose=0   !0:only essential info, 1:verbose, 2:even more verbose
  cf_verbose=0!verbose output of some color_functions routines
  CALL colorhelix_inpar(10)
  IF (.NOT.did_ini_ciecam02) CALL ini_ciecam02
! Set XYZ to RGB conversion matrix
  CALL getrgb(red_prim,grn_prim,blu_prim,XYZwhite,mat_xyz2rgb,mat_rgb2xyz)
! Test the white point
  WRITE(*,'(/3A/)') 'Using RGB space "',trim(name_rgb),'"'
  IF (verbose>=1) THEN
     WRITE(*,'("Red primary xyz =",3(2X,F14.8))') (red_prim(i),i=1,3)
     WRITE(*,'("Green prim. xyz =",3(2X,F14.8))') (grn_prim(i),i=1,3)
     WRITE(*,'("Blue prim.  xyz =",3(2X,F14.8))') (blu_prim(i),i=1,3)
     WRITE(*,'("White point xyz =",3(2X,F14.8))') (XYZwhite(i)/sum(XYZwhite),i=1,3)
     IF (verbose>=2) THEN
        WRITE(*,*)
        WRITE(*,'(A)') 'Matrix XYZ => RGB'
        WRITE(*,'(3(F12.6,2X,F12.6,2X,F12.6/))') mat_xyz2rgb
        WRITE(*,*)
        WRITE(*,'(A)') 'Matrix RGB => XYZ'
        WRITE(*,'(3(F12.6,2X,F12.6,2X,F12.6/))') mat_rgb2xyz
     ENDIF
     WRITE(*,*)
     IF (rgb_gamma<1.d-2) THEN
        WRITE(*,'("RGB gamma      ~= 2.2 (sRGB gamma)")')
     ELSE
        WRITE(*,'("RGB gamma       =",2X,F6.2)') rgb_gamma
     ENDIF
     WRITE(*,*)
     xyztest=XYZwhite
     CALL operate_matrix3x3(mat_xyz2rgb,xyztest,rgbtest)
     CALL colorhelix_rgb_gamma(rgbtest,rgbtest,1)
     WRITE(*,'("White point XYZ =",3(2X,F14.8))') (XYZwhite(i),i=1,3)
     WRITE(*,'("White point RGB =",3(2X,F14.8))') (rgbtest(i),i=1,3)
     WRITE(*,*)
     IF (verbose>=2) THEN
        xyztest=red_prim
        CALL operate_matrix3x3(mat_xyz2rgb,xyztest,rgbtest)
        CALL colorhelix_rgb_gamma(rgbtest,rgbtest,1)
        WRITE(*,'("Red primary XYZ =",3(2X,F14.8))') red_prim
        WRITE(*,'("Red primary RGB =",3(2X,F14.8))') rgbtest
        WRITE(*,*)
        xyztest=grn_prim
        CALL operate_matrix3x3(mat_xyz2rgb,xyztest,rgbtest)
        CALL colorhelix_rgb_gamma(rgbtest,rgbtest,1)
        WRITE(*,'("Green prim. XYZ =",3(2X,F14.8))') grn_prim
        WRITE(*,'("Green prim. RGB =",3(2X,F14.8))') rgbtest
        WRITE(*,*)
        xyztest=blu_prim
        CALL operate_matrix3x3(mat_xyz2rgb,xyztest,rgbtest)
        CALL colorhelix_rgb_gamma(rgbtest,rgbtest,1)
        WRITE(*,'("Blue prim.  XYZ =",3(2X,F14.8))') blu_prim
        WRITE(*,'("Blue prim.  RGB =",3(2X,F14.8))') rgbtest
        WRITE(*,*)
     ENDIF
  ENDIF
  IF (flgsatnoclip>=1.OR.flgsatmonotonic>=1) THEN
     verbose=0
     savesat=sathue
     savesat_noclip=maxxsat
     savesat_monotonic=maxxsat
     IF (flgsatnoclip>=1) THEN
        CALL colorhelix_maxsat
        savesat_noclip=maxsat
     ENDIF
     IF (flgsatmonotonic>=1) THEN
        CALL colorhelix_force_monotonic
        savesat_monotonic=maxsat
     ENDIF
     maxsat=min(savesat_noclip,savesat_monotonic)
     IF (flgsatnoclip==3) THEN
! Use input saturation as scaling for max. saturation
        sathue=savesat*maxsat
     ELSE IF (flgsatnoclip==2) THEN
! Use input saturation as ceiling for max. saturation.
        sathue=min(savesat,maxsat)
     ELSE
        sathue=maxsat
     ENDIF
     IF (sathue==savesat_noclip) THEN
        WRITE(*,'(/A,F8.4,A/)') 'Using saturation =',sathue,' (no clipping)'
     ELSE IF (sathue==savesat_monotonic) THEN
        WRITE(*,'(/A,F8.4,A/)') 'Using saturation =',sathue,' (monotonicity)'
     ELSE
        WRITE(*,'(/A,F8.4,A/)') 'Using saturation =',sathue
     ENDIF
  ENDIF
  verbose=1
  flg_inichroma=1
  CALL colorhelix_make(ifull)
  flg_inichroma=0
  ifull=(/0,nlevels/)
  CALL colorhelix_make(ifull)
  CALL colorhelix_gray_slopes
  IF (ismonotonic) THEN
     WRITE(*,'(/A)') 'Palette is monotonic'
  ELSE
     WRITE(*,'(/A/A)') '--------------------------------','Palette is not monotonic'
     WRITE(*,'(A,E12.4,A,I5)') 'min slope of',mingryslope,' at',imingryslope
     WRITE(*,'(A,E12.4,A,I5)') 'max slope of',maxgryslope,' at',imaxgryslope
     IF (verbose>=2) THEN
        WRITE(*,*)
        WRITE(*,'(A5,4(A12),2(A14))') 'i','Red','Green','Blue','Grey','Gslope','d2prev'
        DO i=0,nlevels
           WRITE(*,'(I5,4(F12.8),2(E14.4))') i,red(i),grn(i),blu(i),gry(i),slope_gry(i),d2prev_gry(i)
        ENDDO
     ENDIF
     WRITE(*,'(A)') '--------------------------------'
  ENDIF
  CALL colorhelix_gray_error
  CALL colorhelix_outdat
  IF (flg_rangemaxsat<=0.AND.(flgsatnoclip>=1.OR.flgsatmonotonic>=1)) STOP
  verbose=0
  WRITE(*,*)
  WRITE(*,'(A)') 'Info: Maximum saturation to avoid clipping:'
  lmin_maxsat=0; lmax_maxsat=nlevels!reset for maxsat info run
  CALL colorhelix_maxsat
  WRITE(*,*)
END PROGRAM colorhelix_main
