MODULE colorhelix_module
  USE color_functions_extended!external
  USE color_functions_ciecam02
!  USE diverse_mathconst!now included in color_functions
!  USE palette_core
!  USE palette_diagnostics
  USE palette_modules
  INTEGER :: flgmodel,flgrgblike,flgmaxsat,flgsatnoclip,flgsatmonotonic,flg_inichroma=0,itermode
  INTEGER :: qmode=0,flg_maxrgb
  INTEGER :: flg_rangemaxsat,lmin_maxsat,lmax_maxsat,nlo4info(0:3),nhi4info(0:3),nlosave(0:3),nhisave(0:3)
  DOUBLE PRECISION :: scal_jcheuc=1.2608d0, scal_jch=1.d0
  DOUBLE PRECISION :: xmin_maxsat,xmax_maxsat
  DOUBLE PRECISION :: start_color,rotations,start_rgb,start_lab,rot_rgb,rot_lab,rot_off=1.d0
  DOUBLE PRECISION :: sathue,maxsat,maxxsat=16.d0,x_ini=1.d-6,sw_scurve,pwr_scurve
  DOUBLE PRECISION,DIMENSION(3) :: urgb_ini,xyz_ini
  DOUBLE PRECISION :: gamma,gamma_rot,pwr_gamma,pwr_gamma_rot,power_amp
  DOUBLE PRECISION,DIMENSION(1:3) :: u,v,w
  DOUBLE PRECISION,DIMENSION(:),ALLOCATABLE :: afullsat
  DOUBLE PRECISION :: rgb_gamma
!  DOUBLE PRECISION,DIMENSION(3,0:3) :: rgb_primaries!xyz for white, red, green, blue
  DOUBLE PRECISION,DIMENSION(3) :: red_prim,grn_prim,blu_prim,wht_prim
  CHARACTER(LEN=20) :: name_rgb
  LOGICAL :: firstmake=.TRUE.,doalloc_fullsat=.TRUE.,usesattable=.FALSE.,did_ini_ciecam02=.FALSE.

  CONTAINS

  SUBROUTINE colorhelix_inpar(ufile)
    IMPLICIT NONE
    INTEGER :: ufile,pfile,qfile,ntot,i,j,ifav,preset_helix,idum
    DOUBLE PRECISION :: favpar(2)
    CHARACTER (LEN=1) :: firstchar
    LOGICAL :: foundfav=.FALSE.
    OPEN(ufile,FILE='colorhelix.inp')
!   Number of levels (<=0 for default=256), model
    READ(ufile,*) ntot,levelorder
    READ(ufile,*) flgmodel,flgrgblike
!   Start color ([1:3] = RGB, mod 3 used for outside)
    READ(ufile,*) start_color,preset_helix
!   Rotations
    READ(ufile,*) rotations,sw_scurve,pwr_scurve
!   Saturation and gamma correction
    READ(ufile,*) sathue,flgmaxsat,itermode
!   maxsat determination range min,max,flag
    READ(ufile,*) xmin_maxsat,xmax_maxsat,flg_rangemaxsat
!   RGB-to-gray weighs (<=0 for default), CCT fot whitepoint
    READ(ufile,*) gamma,gamma_rot,power_amp
    READ(ufile,*) wr,wg,wb
    READ(ufile,*) selrgb,selwluma,flg_maxrgb
    CLOSE(ufile)
    pfile=ufile+1
    qfile=ufile+2
    flgsatmonotonic=flgmaxsat/10
    flgsatnoclip=flgmaxsat-10*flgsatmonotonic
    IF (itermode>=1) THEN
       flgsatmonotonic=0
       flg_rangemaxsat=0
    ENDIF
    IF (flgmodel<0) THEN
       flgsatmonotonic=0
       flg_rangemaxsat=0
       flgsatnoclip=0
    ENDIF
    IF (flg_rangemaxsat<=0.OR.xmax_maxsat<=xmin_maxsat) THEN
       xmin_maxsat=0.d0
       xmax_maxsat=1.d0
    ENDIF
    WRITE(*,*) 'flgmaxsat,flgsatnoclip,flgsatmonotonic =',flgmaxsat,flgsatnoclip,flgsatmonotonic
    WRITE(*,*) 'flg_rangemaxsat =',flg_rangemaxsat
    pwr_gamma=1.d0/gamma
    pwr_gamma_rot=1.d0/gamma_rot
    WRITE(*,*)
    IF (selwluma<0) THEN
       wr=1.d0/3.d0
       wg=wr
       wb=wr
       WRITE(*,*) 'Equal luma weights'
    ELSE IF (selwluma>=1.AND.selwluma<=4) THEN
       wr=all_wluma(1,selwluma)
       wg=all_wluma(2,selwluma)
       wb=all_wluma(3,selwluma)
       WRITE(*,'(A,3(1X,F8.6))') 'Preset luma weights:',wr,wg,wb
    ELSE
       WRITE(*,'(A,3(1X,F8.6))') 'User-defined luma weights:',wr,wg,wb
    ENDIF
    WRITE(*,*)
    IF (preset_helix>=0) THEN
       OPEN(pfile,FILE='colorhelix-favorites.txt')
       DO i=1,1000
          READ(pfile,*) firstchar
          IF (firstchar=='>') EXIT
       ENDDO
       READ(pfile,*)
       DO i=0,1000!(a maximum of 1000 schemes should be vastly enough ;-)
          READ(pfile,*,end=19,err=19) ifav,favpar(1:2)
          foundfav=ifav==preset_helix
          IF (foundfav) EXIT
       ENDDO
  19   CLOSE(pfile)
       IF (foundfav) THEN
          WRITE(*,'(A,I3,A)') '*** Using favorite helix params preset',ifav,'***'
          flgrgblike=1
          start_color=favpar(1)
          rotations=favpar(2)
       ELSE
          WRITE(*,'(A,I3)') 'No favorite found, using default param file.'
       ENDIF
    ELSE
       WRITE(*,'(A,I3)') '*** Using default param file ***'
    ENDIF
!**** Calculate RGB/Lab-equivalents to start_color and rotations (for info only)
    rot_off=-0.75d0
    IF ((flgmodel>=1.AND.flgrgblike<=0).OR.(flgmodel<1.AND.flgrgblike<0)) THEN!input=L*a*b*
!phi_start=0.25d0-start_color/3.d0! mimic rgb in lab
!phi_start=(1.d0-start_color)/4.d0! mimic lab in rgb
       write(*,*) '******** Input conversion: Lab -> RGB'
       start_rgb=0.75d0*(start_color-rot_off)
       start_lab=start_color
!       rot_rgb=-rotations
       rot_rgb=rotations
       rot_lab=rotations
    ELSE!input=RGB
       write(*,*) '******** Input conversion: RGB -> Lab'
       start_rgb=start_color
       start_lab=4.d0/3.d0*start_color+rot_off
       rot_rgb=rotations
!       rot_lab=-rotations
       rot_lab=rotations
    ENDIF
    IF (start_rgb<0.d0) start_rgb=start_rgb+3.d0
    IF (start_lab<0.d0) start_lab=start_lab+4.d0
    IF (start_rgb>=3.d0) start_rgb=start_rgb-3.d0
    IF (start_lab>=4.d0) start_lab=start_lab-4.d0
    WRITE(*,'(A,2(1X,F8.4))') 'Start colour RGB, L*a*b* =',start_rgb,start_lab
    WRITE(*,'(A,2(1X,F8.4))') 'Rotations                =',rot_rgb,rot_lab
!(1.d0-start_color)
!  -- Sanity check
    IF (ntot<2.OR.ntot>nlevels_max+1) THEN
       IF (ntot<2)   WRITE(*,*) 'Minimum ntot=2 color levels required.'
       IF (ntot>nlevels_max+1) WRITE(*,*) 'Maximum ntot =',nlevels_max+1,', color levels allowed.'
       WRITE(*,*) 'Using default (256 levels).'
       ntot=256
    ENDIF
    nlevels=ntot-1
    lmin_maxsat=nint(xmin_maxsat*nlevels)
    lmax_maxsat=nint(xmax_maxsat*nlevels)
    write(*,*) 'lmin,lmax maxsat =',lmin_maxsat,lmax_maxsat
    CALL palette_initialize
!**** RGB primaries
    IF (selrgb<0.OR.selrgb>8) THEN
       red_prim=srgb_red
       grn_prim=srgb_grn
       blu_prim=srgb_blu
       wht_prim=srgb_wht
       XYZwhite=whitepoint_d65
       rgb_gamma=0.d0!force use of srgb_gamma
       name_rgb='sRGB (default)'
    ELSE
       OPEN(qfile,FILE='rgb-primaries.asc')
       DO i=-2,selrgb-1
          READ(qfile,*)
       ENDDO
       READ(qfile,*) idum,(red_prim(j),j=1,2),(grn_prim(j),j=1,2),(blu_prim(j),j=1,2), &
            (wht_prim(j),j=1,2),rgb_gamma,name_rgb
       red_prim(3)=1.d0-red_prim(1)-red_prim(2)
       grn_prim(3)=1.d0-grn_prim(1)-grn_prim(2)
       blu_prim(3)=1.d0-blu_prim(1)-blu_prim(2)
       wht_prim(3)=1.d0-wht_prim(1)-wht_prim(2)
       XYZwhite(:)=wht_prim(:)/wht_prim(2)!scale to Y=1
       CLOSE(qfile)
    ENDIF
    RETURN
  END SUBROUTINE colorhelix_inpar
  
  SUBROUTINE colorhelix_outdat
    IMPLICIT NONE
    INTEGER :: i,j
    DOUBLE PRECISION :: x,rgb(3),rgb01(3),drgb(3),xyz(3),xyY(3),sumxyz,phi
    OPEN(33,FILE='colorhelix-rgbdat.aux')
    OPEN(43,FILE='colorhelix-gp.aux')
    WRITE(33,'()')
    WRITE(33,'(3(2X,F14.8),10X,"Red primary xyz")') (red_prim(i),i=1,3)
    WRITE(33,'(3(2X,F14.8),10X,"Green prim. xyz")') (grn_prim(i),i=1,3)
    WRITE(33,'(3(2X,F14.8),10X,"Blue prim.  xyz")') (blu_prim(i),i=1,3)
    WRITE(33,'(3(2X,F14.8),10X,"White point xyz")') (XYZwhite(i)/sum(XYZwhite),i=1,3)
    WRITE(33,'(3(2X,F14.8),10X,"White point XYZ")') (XYZwhite(i),i=1,3)
    WRITE(33,'(2X,F14.8,42X,"Gamma")') rgb_gamma
    WRITE(33,'(3(2X,F14.8),10X,"Initial RGB")')     (urgb_ini(i),i=1,3)
    WRITE(33,'(3(2X,F14.8),10X,"Initial xyz")')     (xyz_ini(i),i=1,3)
    CLOSE(33)
    WRITE(43,'(A,I4)') 'nlevels=',nlevels
    WRITE(43,'(2(A,I2))') 'flgmodel=',flgmodel,'; flgrgblike=',flgrgblike
    WRITE(43,'(A,F9.4)') 'start=',start_color
    WRITE(43,'(3(A,F9.4))') 'rots=',rotations
    WRITE(43,'(3(A,F9.4))') 'sathue=',sathue
    WRITE(43,'(3(A,F9.4))') 'gamma_gry=',gamma,'; gamma_rot=',gamma_rot,'; power_amp=',power_amp
    WRITE(43,'(3(A,F9.6))') 'wr=',wr,'; wg=',wg,'; wb=',wb
    WRITE(43,'(2(A,I2))') 'selrgb=',selrgb,'; selwluma=',selwluma
    WRITE(43,*) '####'
    WRITE(43,'(A)') 'qexp=1./gamma_gry'
!    CALL colorhelix_header(43,1)
    CLOSE(43)
    OPEN(22,FILE='colorhelix.out')
    OPEN(32,FILE='colorhelix.rgb')
    IF (flgmodel>=1) THEN
       OPEN(34,FILE='colorhelix.xyz')
       OPEN(35,FILE='colorhelix.xyy')
       OPEN(36,FILE='colorhelix.lab')
       OPEN(38,FILE='colorhelix.lch')
    ENDIF
    WRITE(22,2201) '#Level','R','G','B','Gray','xGray','R01','G01','B01'
    CALL colorhelix_header(32,0)! RGB output header
    IF (flgmodel>=1) THEN
       CALL colorhelix_header(34,0)! XYZ output header
       CALL colorhelix_header(35,0)! xyY output header
       CALL colorhelix_header(36,0)! Lab output header
       CALL colorhelix_header(38,0)! Lab output header
    ENDIF
!   Check palette sanity and repair if necessary
    CALL palette_sanity
!   Output palette files
    DO i=0,nlevels
       IF (flags_palette(i)<0) THEN
          PRINT *,'Skipping invalid palette entry'
!          CYCLE
       ENDIF
       x=dble(i)/dble(nlevels)
       rgb=(/red(i),grn(i),blu(i)/)
       drgb(1)=red(i)-gry(i)
       drgb(2)=grn(i)-gry(i)
       drgb(3)=blu(i)-gry(i)
       CALL mapto01(drgb,rgb01,31,(/0.d0,1.d0/))!to get the rgb 'polar angle'
       WRITE(22,2200) i,red(i),grn(i),blu(i),gry(i),xgry(i),drgb
       WRITE(32,3200) x,red(i),grn(i),blu(i)
       IF (flgmodel>=1) THEN
          xyz(:)=CIEXYZ(:,i)
          sumxyz=sum(xyz)
          IF (sumxyz<=0.d0.OR.sum(xyz)/=sum(xyz)) THEN!zero and NaN handling
             xyY(1:2)=xyz_ini(1:2);xyY(3)=0.d0
!             WRITE(*,'(A,4(1X,F9.6))') 'sum<=0; xyY =',xyY
          ELSE
             xyY(1)=xyz(1)/sumxyz;xyY(2)=xyz(2)/sumxyz;xyY(3)=xyz(2)
!             WRITE(*,'(A,4(1X,F9.6))') 'sum>0;  xyY =',xyY
          ENDIF
!          WRITE(*,'(A,4(1X,F9.6))') '      ; xyz_ini =',xyz_ini
!          WRITE(*,*) 'xyz(2),xyz(2)==xyz(2) =',xyz(2),xyz(2)==xyz(2)
!          stop
          WRITE(34,3400) x,(1.d2*CIEXYZ(j,i),j=1,3)
          WRITE(35,3400) x,(xyY(j),j=1,2),1.d2*xyY(3)
          WRITE(36,3400) x,(CIELAB(j,i),j=1,3)
          WRITE(38,3400) x,(CIELCH(j,i),j=1,3)
       ENDIF
    ENDDO
    CLOSE(22)
    CLOSE(32)
    IF (flgmodel>=1) CLOSE(34)
    IF (flgmodel>=1) CLOSE(35)
    IF (flgmodel>=1) CLOSE(36)
    IF (flgmodel>=1) CLOSE(38)
  2200 FORMAT(I6,2X,5(2X,F12.6),2X,3(2X,F12.6))
  2201 FORMAT(A6,2X,5(2X,A12),  2X,3(2X,A12))
  3200 FORMAT(F9.6,2X,3(2X,F12.6))
  3400 FORMAT(F9.6,2X,3(2X,F12.4))
  3201 FORMAT(A9,2X,3(2X,A12))
    RETURN
  END SUBROUTINE colorhelix_outdat
  
  SUBROUTINE colorhelix_header(ufile,mode)
    IMPLICIT NONE
    INTEGER :: ufile,mode
    CHARACTER (LEN=1) :: xcomment='#'
    IF (mode==1) THEN
       xcomment=' '
    ELSE
       xcomment='#'
    ENDIF
    WRITE(ufile,'(A,A,I4,A,I2)')      xcomment,'nlevels=',nlevels,'; levelorder=',levelorder
    WRITE(ufile,'(A,2(A,I2))')   xcomment,'flgmodel=',flgmodel,'; flgrgblike=',flgrgblike
    WRITE(ufile,'(A,A,F9.4)')    xcomment,'start=',start_color
    WRITE(ufile,'(A,3(A,F9.4))') xcomment,'rots=',rotations,'; sw_s=',sw_scurve,'; pwr_s=',pwr_scurve
    WRITE(ufile,'(A,A,F9.4,2(A,I2))') xcomment,'sathue=',sathue,'; flgmaxsat =',flgmaxsat,'; itermode =',itermode
    WRITE(ufile,'(A,2(A,F9.4),A,I2)') xcomment,'xmin_xsat=',xmin_maxsat,'; xmax_xsat=', xmax_maxsat,'; flg_range=',flg_rangemaxsat
    WRITE(ufile,'(A,3(A,F9.4))') xcomment,'gamma_gry=',gamma,'; gamma_rot=',gamma_rot,'; power_amp=',power_amp
!    WRITE(ufile,'(A,(A,F9.4))')  xcomment,'gamma    =',gamma
!    WRITE(ufile,'(A,(A,F9.4))')  xcomment,'gamma_rot=',gamma_rot
!    WRITE(ufile,'(A,(A,F9.4))')  xcomment,'power_amp=',power_amp
    WRITE(ufile,'(A,3(A,F9.6))') xcomment,'wr=',wr,'; wg=',wg,'; wb=',wb
!    WRITE(ufile,'(A,A,F9.2)')    xcomment,'cct=',CCT
    WRITE(ufile,'(A,2(A,I2))') xcomment,'selrgb=',selrgb,'; selwluma=',selwluma
    RETURN
  END SUBROUTINE colorhelix_header
  
  SUBROUTINE rgbhelix_make(irange)
    IMPLICIT NONE
!    EXTERNAL fscurve
    DOUBLE PRECISION :: xscurve
    INTEGER :: i,irange(0:1),urange(0:1)
    DOUBLE PRECISION :: x,s,cdev,rdev,gray,phi,amp,cphi,sphi,omega
    DOUBLE PRECISION :: phi_start,sat2use
    DOUBLE PRECISION,DIMENSION(1:3) :: rgb0,rgb,rgblin,xyz
    irange(0)=max(min(irange(0),nlevels),0)
    irange(1)=max(min(irange(1),nlevels),0)
    IF (irange(1)<irange(0)) THEN
       irange=(/0,nlevels/)
       IF (firstmake) WRITE(*,'(A)') 'Using full level range'
    ELSE
       IF (firstmake) WRITE(*,'(2(A,I4.4))') 'Using levels from ',irange(0),' to ',irange(1)
    ENDIF
    firstmake=.FALSE.
    nlo(0:3)=0
    nhi(0:3)=0
    mindev(0:3)=0.d0
    maxdev(0:3)=0.d0
    IF (flgrgblike<0) THEN
!   Mimic Labhelix behaviour
!       phi_start=(1.d0-start_color)/4.d0
       phi_start=start_lab/4.d0
       omega=rotations
    ELSE
!       phi_start=start_color/3.d0
       phi_start=start_rgb/3.d0
       omega=rotations
    ENDIF
    phi_start=start_rgb/3.d0
    omega=rotations
!    WRITE(*,*) 'RGBHELIX: flgrgblike,phi_start,omega =',flgrgblike,phi_start,omega
    CALL rgbhelix_basevectors
    IF (flg_inichroma==1) THEN
       urange=(/0,0/)
    ELSE
       urange=irange
    ENDIF
    DO i=urange(0),urange(1)
       IF (usesattable) THEN
          sat2use=afullsat(i)
       ELSE
          sat2use=sathue
       ENDIF
       IF (flg_inichroma==1) THEN
          x=x_ini
       ELSE IF (levelorder<0) THEN
          x=dble(urange(1)-i)/nlevels
       ELSE
          x=dble(i)/nlevels
       ENDIF
!       gray=x**pwr_gamma
       CALL scurve(x,xscurve)
       gray=xscurve**pwr_gamma
       xgry(i)=gray!for diagnostics only
       s=x**pwr_gamma_rot
!       phi=tau*(start_color/3.d0+rotations*s)
       phi=tau*(phi_start+omega*s)
       cphi=cos(phi)
       sphi=sin(phi)
       w(1:3)=(u(1:3)*cphi+v(1:3)*sphi)
       IF (itermode>=1.OR.flgmodel<0) THEN
          cdev=1
       ELSE IF (power_amp>0.d0) THEN
          cdev=0.25d0*(4.d0*gray*(1.d0-gray))**power_amp
       ELSE IF (power_amp<0.d0) THEN
          IF (gray<0.5d0) THEN
             rdev=gray
          ELSE
             rdev=1.d0-gray
          ENDIF
          cdev=0.4*(2.5*rdev)**(-power_amp)
       ELSE
          cdev=1.d0
       ENDIF
       amp=sat2use*cdev
       red(i)=gray+amp*w(1)
       grn(i)=gray+amp*w(2)
       blu(i)=gray+amp*w(3)
!   some test output
       IF (verbose>=2) WRITE(44,'(I4,6(2X,F11.6))') i,phi*3.6d2/tau,w(1:3),amp
       rgb0(1)=red(i)
       rgb0(2)=grn(i)
       rgb0(3)=blu(i)
       IF (flgmodel<0) THEN!under construction!
          CALL mapto01(rgb0,rgb0,4,(/gray,sat2use/))
       ENDIF
       nlosave=nlo; nhisave=nhi
       CALL palette_checkvalues(rgb0,rgb)
       nlo4info=nlo; nhi4info=nhi
       IF (i<lmin_maxsat.OR.i>lmax_maxsat) THEN!skip the check values outside testing range
          nlo=nlosave
          nhi=nhisave
       ENDIF
       red(i)=rgb(1)
       grn(i)=rgb(2)
       blu(i)=rgb(3)
       gry(i)=wr*red(i)+wg*grn(i)+wb*blu(i)!may differ from gray slightly
       IF (flg_inichroma==1) THEN
! direct mapping to 0:1
!          CALL mapto01(rgb,urgb_ini,31,(/0.d0,1.d0/))
!          CALL colorhelix_rgb_gamma(urgb_ini,rgblin,-1)
! map in linear RGB
          CALL colorhelix_rgb_gamma(rgb,rgb0,-1)
          CALL mapto01(rgb0,rgblin,31,(/0.d0,1.d0/))
          CALL colorhelix_rgb_gamma(rgblin,urgb_ini,1)
! Get XYZ
          CALL operate_matrix3x3(mat_rgb2xyz,rgblin,xyz)
          xyz_ini(:)=xyz(:)/sum(xyz)
       ENDIF
    ENDDO
    IF (verbose>=1) THEN
       WRITE(*,'(A,I4)') 'nlev =',nlevels
       WRITE(*,'(A,4(1X,I4))') 'nlo tot,r,g,b =',nlo
       WRITE(*,'(A,4(1X,I4))') 'nhi tot,r,g,b =',nhi
!       WRITE(*,'(A,4(1X,F9.6))') 'min dev r,g,b,tot =',mindev(0:3)
!       WRITE(*,'(A,4(1X,F9.6))') 'max dev r,g,b,tot =',maxdev(0:3)
       WRITE(*,'(A,4(1X,F9.4,''%''))') 'min dev gray,r,g,b =',1.d2*mindev(0:3)
       WRITE(*,'(A,4(1X,F9.4,''%''))') 'max dev gray,r,g,b =',1.d2*maxdev(0:3)
    ENDIF
    RETURN
  END SUBROUTINE rgbhelix_make
  
  SUBROUTINE labhelix_make(irange)
    IMPLICIT NONE
!    EXTERNAL fscurve
    DOUBLE PRECISION :: xscurve
    INTEGER :: i,j,irange(0:1),urange(0:1)
    DOUBLE PRECISION,DIMENSION(1:3) :: Lab,LCh,JCh,JChe,dum3,xyz,rgblin,rgb0,rgb
    DOUBLE PRECISION :: x,s,cdev,rdev,gray,phi,amp,cphi,sphi,omega
    DOUBLE PRECISION :: phi_start,scalsat=100.d0,sat2use!,scalxyz=100.d0
    irange(0)=max(min(irange(0),nlevels),0)
    irange(1)=max(min(irange(1),nlevels),0)
    IF (irange(1)<irange(0)) THEN
       irange=(/0,nlevels/)
       IF (firstmake) WRITE(*,'(A)') 'Using full level range'
    ELSE
       IF (firstmake) WRITE(*,'(2(A,I4.4))') 'Using levels from ',irange(0),' to ',irange(1)
    ENDIF
    firstmake=.FALSE.
    nlo(0:3)=0
    nhi(0:3)=0
    mindev(0:3)=0.d0
    maxdev(0:3)=0.d0
    IF (flgrgblike>0) THEN
!   Mimic RGBhelix behaviour
!       phi_start=0.25d0-start_color/3.d0
       phi_start=start_rgb/3.d0
       omega=rotations
    ELSE
!       phi_start=start_color/4.d0
       phi_start=start_lab/4.d0
       omega=rotations
    ENDIF
    phi_start=start_lab/4.d0
    omega=rotations
    IF (flg_inichroma==1) THEN
       urange=(/0,0/)
    ELSE
       urange=irange
    ENDIF
!    WRITE(*,*) 'LABHELIX: flgrgblike,phi_start,omega =',flgrgblike,phi_start,omega
    DO i=urange(0),urange(1)
       IF (usesattable) THEN
          sat2use=afullsat(i)
       ELSE
          sat2use=sathue
       ENDIF
       IF (flg_inichroma==1) THEN
          x=x_ini
       ELSE IF (levelorder<0) THEN
          x=dble(urange(1)-i)/nlevels
       ELSE
          x=dble(i)/nlevels
       ENDIF
!       gray=x**pwr_gamma
       CALL scurve(x,xscurve)
       gray=xscurve**pwr_gamma
       xgry(i)=gray!for diagnostics only
       s=x**pwr_gamma_rot
       phi=tau*(phi_start+omega*s)
       cphi=cos(phi)
       sphi=sin(phi)
       w(1:3)=(u(1:3)*cphi+v(1:3)*sphi)
!       cdev=0.25d0*(4.d0*gray*(1.d0-gray))**power_amp
       IF (itermode>=1) THEN
          cdev=1
       ELSE IF (power_amp>0.d0) THEN
          cdev=0.25d0*(4.d0*gray*(1.d0-gray))**power_amp
       ELSE IF (power_amp<0.d0) THEN
          IF (gray<0.5d0) THEN
             rdev=gray
          ELSE
             rdev=1.d0-gray
          ENDIF
          cdev=0.4*(2.5*rdev)**(-power_amp)
       ELSE
          cdev=1.d0
       ENDIF
       amp=scalsat*sat2use*cdev
!---- Store to Lab/LCh
       LCh(1)=100.d0*gray
       LCh(2)=amp
       IF (flgmodel==2) THEN
          LCh(3)=phi-0.18d0!DIN99d corrected for average angle shift (approx. to variable)
       ELSEIF (flgmodel==3) THEN
          LCh(3)=phi+0.000947d0!DIN99o corrected for average angle shift (constant)
       ELSEIF (flgmodel==4) THEN!NEW IPT color space
          LCh(3)=phi-0.106d0
       ELSEIF (flgmodel==5) THEN!NEW IPTEUC color space
          LCh(3)=phi-0.314d0
       ELSEIF (flgmodel>=6.AND.flgmodel<=8) THEN!CIECAM02 color space
          IF (flgmodel<=7) THEN
!             LCh(3)=phi-0.086d0!for JCh
             LCh(3)=phi-0.352d0!for JCHquad
!             LCh(3)=phi-0.d0!for JCh
          ELSE
             LCh(3)=phi-0.d0!for JCHquad
          ENDIF
       ELSE
          LCh(3)=phi
       ENDIF
       IF (LCh(3)<0.d0) THEN
          LCh(3)=LCh(3)+tau
       ELSE IF (LCh(3)>tau) THEN
          LCh(3)=LCh(3)-tau
       ENDIF
       CALL lab2lch(Lab,LCh,-1,0)
!       WRITE(*,'(A,I6,3(1X,F12.6))') 'i,Lgray,amp,phi =',i,1.d2*gray,amp,phi*57.29577951d0
!       WRITE(*,'(A,I6,3(1X,F12.6))') 'i,amp,sat2use =',i,amp,sat2use
       IF (flgmodel==1) THEN
          CALL lab2xyz(Lab,xyz,XYZwhite)
       ELSE IF (flgmodel==2) THEN
          CALL LCh99d2XYZ(LCh,XYZwhite,xyz,0)
       ELSE IF (flgmodel==3) THEN
          CALL LCh99o2Lab(LCh,Lab,0)
          CALL lab2xyz(Lab,xyz,XYZwhite)
       ELSE IF (flgmodel==4) THEN!NEW IPT color space
          CALL ipt2ich(Lab,LCh,11,-1)!here: LCh=ICh100 & Lab=IPT100,reverse direction
          CALL ipt2xyz(Lab,xyz,XYZwhite,1,1)!here:Lab=IPT100,whitecorr enabled (like always in Lab*)
       ELSE IF (flgmodel==5) THEN!NEW IPT color space
          CALL ipt2ich(Lab,LCh,11,-1)!here: LCh=ICh100 & Lab=IPT100,reverse direction
          CALL ipteuc2xyz(Lab,xyz,XYZwhite,1)!here:Lab=IPTE,whitecorr enabled (like always in Lab*)
       ELSE IF (flgmodel>=6.AND.flgmodel<=9) THEN!NEW IPT color space
          IF (flgmodel==7.OR.flgmodel==9) THEN
             JChe=(/scal_jcheuc*LCh(1),LCh(2),LCh(3)/)
             CALL euc2ciecam(LCh,JChe,-1)
          ELSE
             dum3=(/scal_jch*LCh(1),LCh(2),LCh(3)/)
             LCh=dum3
          ENDIF
          IF (flgmodel<=7) THEN
             JCh=(/LCh(1),LCh(2),LCh(3)/); qmode=0
          ELSE
             JCh=(/LCh(1),LCh(2),r2g*LCh(3)/); qmode=1
          ENDIF
!          WRITE(*,*) '*********************************** C* =',LCh(2),'; C02 =',JCh(2)
!          WRITE(*,*) '*********************************** LCh =',LCh,'; JCh =',JCh
!          if (abs(x-0.419608d0)<0.00001d0) cf_verbose=2
!          cf_verbose=2
          CALL wrap_ciecam02(XYZ,JCh,dum3,qmode,10,-1)
!          cf_verbose=0
!          if (cf_verbose>=1) stop
       ENDIF
!          WRITE(*,*) '*********************************** C* =',LCh(2),'; amp =',amp
!       WRITE(*,*) '*********************************** LCh =',LCh,'; XYZ =',xyz
!       if (abs(x-1.d0)<0.0001d0) WRITE(*,*) '************XYZ =',xyz
!       if (abs(x-1.d0)<0.0001d0) WRITE(*,*) '************LCh =',LCh
       IF (i==0) THEN
          IF (sum(xyz)/=sum(xyz)) xyz(:)=0.d0!NaN handling
!          IF (xyz(1)/=xyz(1)) xyz(1)=0.d0!NaN handling
!          IF (xyz(2)/=xyz(2)) xyz(2)=0.d0!NaN handling
!          IF (xyz(3)/=xyz(3)) xyz(3)=0.d0!NaN handling
       ENDIF
       IF (flg_inichroma/=1) THEN
          CIELAB(:,i)=Lab(:)
          CIELCH(1,i)=Lch(1);CIELCH(2,i)=Lch(2);CIELCH(3,i)=Lch(3)*r2d!store as degrees
          CIEXYZ(:,i)=xyz
!          WRITE(*,'(A,4(1X,F9.6))') 'ciexyz =',xyz
       ENDIF
!       WRITE(*,*) 'i,amp,CIELAB(2,i),CIELAB(3,i) =',i,amp,CIELAB(2,i),CIELAB(3,i)
       CALL operate_matrix3x3(mat_xyz2rgb,xyz,rgb0)
       nlosave=nlo; nhisave=nhi
       IF (i<nlevels) THEN!Clipping due to XYZ whitepoint conversion unavoidable
          CALL palette_checkvalues(rgb0,rgblin)
          nlo4info=nlo; nhi4info=nhi
          IF (i<lmin_maxsat.OR.i>lmax_maxsat) THEN!skip the check values outside testing range
             nlo=nlosave
             nhi=nhisave
          ENDIF
       ELSE
          rgblin(:)=max(min(rgb0(:),1.d0),0.d0)
       ENDIF
       CALL colorhelix_rgb_gamma(rgblin,rgb,1)
       red(i)=rgb(1)
       grn(i)=rgb(2)
       blu(i)=rgb(3)
       gry(i)=wr*red(i)+wg*grn(i)+wb*blu(i)!may differ from gray slightly
       IF (i==0) THEN
          IF (red(i)/=red(i)) red(i)=0.d0!NaN handling
          IF (grn(i)/=grn(i)) grn(i)=0.d0
          IF (blu(i)/=blu(i)) blu(i)=0.d0
          IF (gry(i)/=gry(i)) gry(i)=0.d0
       ENDIF
       flags_palette(i)=0!default for 'nothing special'
       IF (red(i)/=red(i).OR.grn(i)/=grn(i).OR.blu(i)/=blu(i).OR.gry(i)/=gry(i)) THEN
          flags_palette(i)=-1!NaN
       ENDIF
       IF (flg_inichroma==1) THEN
          xyz_ini(:)=xyz(:)/sum(xyz)
          CALL mapto01(rgb,urgb_ini,31,(/0.d0,1.d0/))
!          WRITE(*,'(A,4(1X,F9.6))') 'xyz_ini =',xyz_ini
!          WRITE(*,'(A,4(1X,F9.6))') 'urgb_ini=',urgb_ini
!          stop
       ENDIF
       IF (verbose>=2.or.cf_verbose>=1) THEN
          write(*,2300) dble(i)/nlevels,red(i),grn(i),blu(i)
          write(45,2300) (Lab(j),j=1,3),(xyz(j),j=1,3),(rgb(j),j=1,3),(rgblin(j),j=1,3)
!          write(45,2400) gray,(xyz(j)/sum(xyz),j=1,3),(rgb(j),j=1,3),(rgblin(j),j=1,3)
       ENDIF
    ENDDO
    IF (verbose>=1) THEN
       WRITE(*,'(A,I4)') 'nlev =',nlevels
       WRITE(*,'(A,4(1X,I4))') 'nlo tot,r,g,b =',nlo
       WRITE(*,'(A,4(1X,I4))') 'nhi tot,r,g,b =',nhi
!       WRITE(*,'(A,4(1X,F9.6))') 'min dev r,g,b,tot =',mindev(0:3)
!       WRITE(*,'(A,4(1X,F9.6))') 'max dev r,g,b,tot =',maxdev(0:3)
       WRITE(*,'(A,4(1X,F9.4,''%''))') 'min dev gray,r,g,b =',1.d2*mindev(0:3)
       WRITE(*,'(A,4(1X,F9.4,''%''))') 'max dev gray,r,g,b =',1.d2*maxdev(0:3)
    ENDIF
  2200 FORMAT(3(F12.6,1X),9(1X,F12.6))
  2300 FORMAT(3(1PE12.4,1X),9(1X,1PE12.4))
  2400 FORMAT(F12.6,1X,9(1X,F12.6))
  2500 FORMAT(1PE12.4,1X,9(1X,1PE12.4))
    RETURN
  END SUBROUTINE labhelix_make
  
  SUBROUTINE colorhelix_maxsat
!   Maximize saturation
    IMPLICIT NONE
    INTEGER :: iter,maxiter,maxii,ii,i,nbad,irange(0:1)
    INTEGER :: ilevel,lrange(0:1)
    DOUBLE PRECISION :: s0,s1,ds,dsacc=1.d-15
    IF (flgmodel<0) THEN
       WRITE(*,*) 'COLORHELIX_MAXSAT: Not applicable'
       RETURN
    ENDIF
    maxiter=1000; maxii=1000
    usesattable=.FALSE.
    IF (doalloc_fullsat) THEN
       ALLOCATE (afullsat(0:nlevels))
       doalloc_fullsat=.FALSE.
    ENDIF
    IF (itermode>=1) THEN
       lrange=(/0,nlevels/)
    ELSE
       lrange=(/0,0/)
       irange=(/0,nlevels/)
    ENDIF
    WRITE(*,*) 'maxsat: lrange =',lrange
    DO ilevel=lrange(0),lrange(1)
     IF (itermode>=1) THEN
        IF (ilevel==0.OR.ilevel==nlevels) THEN
           maxsat=0.d0
           GOTO 10
        ENDIF
        irange=(/ilevel,ilevel/)
!        WRITE(*,*) 'maxsat: ilevel =',ilevel
     ENDIF
     s0=0.d0
     s1=maxxsat
     ds=1.d0
     iter=0
     DO iter=0,maxiter
       ii=-1
       nbad=0
       DO WHILE (nbad==0.AND.ii<=maxii)
          ii=ii+1
          sathue=s0+ii*ds
          CALL colorhelix_make(irange)
          nbad=nlo(0)+nhi(0)
!          write(*,*) ' inner: sat,nlo,nhi =',sathue,nlo,nhi,usesattable
!          write(*,*) ' inner: ii,sat,nbad =',ii,sathue,nbad
       ENDDO
       s1=sathue
       s0=s1-ds
!       write(*,*) 'iter,ii,s0,s1,ds =',iter,ii,s0,s1,ds
!       write(*,*) 'ilevel,s0,s1 =',ilevel,s0,s1
!       IF (itermode>=1) WRITE(*,*) 'maxsat: ilevel,iter =',ilevel,iter
       IF (ds<dsacc) EXIT
       ds=ds/2.d0
     ENDDO
!     maxsat=(s0+s1)/2.d0
     maxsat=s0!safer than half-interval
  10 IF (itermode>=1) afullsat(ilevel)=maxsat
!     IF (itermode>=1) WRITE(*,*) 'ilevel,fullsat =',ilevel,afullsat(ilevel)
    ENDDO
    WRITE(*,'(A,F12.8)') 'Maximum no-clipping saturation =',maxsat
    IF (itermode>=1) usesattable=.TRUE.
!    stop
     maxsat=max(maxsat,0.d0)
    RETURN
  END SUBROUTINE colorhelix_maxsat

  SUBROUTINE colorhelix_force_monotonic
!   Maximize saturation while monotonic
    IMPLICIT NONE
    INTEGER :: iter,maxiter,ii,i,nbad,irange(0:1)
    INTEGER :: ilevel,lrange(0:1)
    DOUBLE PRECISION :: s0,s1,ds,dsacc=1.d-15
    maxiter=1000
    usesattable=.FALSE.
    irange=(/0,nlevels/)!clear modified ranges from colorhelix_maxsat
    write(*,*) 'irange =',irange
    s0=0.d0
    s1=maxxsat
    ds=1.d0
    iter=0
    DO iter=0,maxiter
       ii=-1
       ismonotonic=.TRUE.
       DO WHILE (ismonotonic)
          ii=ii+1
          sathue=s0+ii*ds
          CALL colorhelix_make(irange)
          CALL colorhelix_gray_slopes
!          write(*,*) ' inner: ii,sat,ismonotonic =',ii,sathue,ismonotonic
       ENDDO
       s1=sathue
       s0=s1-ds
       IF (ds<dsacc) EXIT
       ds=ds/2.d0
     ENDDO
     maxsat=s0
     maxsat=max(maxsat,0.d0)
     RETURN
  END SUBROUTINE colorhelix_force_monotonic
  
  SUBROUTINE colorhelix_make(irange)
    IMPLICIT NONE
    INTEGER :: irange(0:1)
!    WRITE(*,*) 'COLHELIX: flgmodel =',flgmodel
    IF (flgmodel>=1) THEN
!       WRITE(*,*) 'LABHELIX: flgmodel =',flgmodel
       CALL labhelix_make(irange)
    ELSE
!       WRITE(*,*) 'RGBHELIX: flgmodel =',flgmodel
       CALL rgbhelix_make(irange)
    ENDIF
!    stop!debug
    RETURN
  END SUBROUTINE colorhelix_make
  
  SUBROUTINE rgbhelix_basevectors
    IMPLICIT NONE
    DOUBLE PRECISION u_norm,eps0,eps,rho_rg,wsum
    IF (wr<=0..OR.wg<=0..OR.wb<=0) THEN
!    IF (wr<=0..OR.wg<=0..OR.wb<=0.OR.wr**2+wg**2<=wb**2) THEN
       WRITE(*,*) 'Bad or incomplete weights input -- using defaults.'
!  .... Use defaults
       wr=0.30d0
       wg=0.59d0
       wb=0.11d0
    ENDIF
!  ---- First calculate V
    rho_rg=sqrt(wr**2+wg**2)
    v(1)=wg/rho_rg
    v(2)=-wr/rho_rg
    v(3)=0.D0
!  ---- Calculate U
    eps0=wb*wr/(wr**2+wg**2)
    u_norm=sqrt(1.d0+eps0**2+(wg/wr*eps0)**2)
    eps=eps0/u_norm
    u(1)=-eps
    u(2)=-eps*wg/wr
    u(3)=1.d0/u_norm
    IF (verbose>=1) THEN
       WRITE(*,'(A,3(1X,F9.6))') '|U0|=',u_norm
       WRITE(*,'(A,3(1X,F9.6))') 'U   =',u
       WRITE(*,'(A,3(1X,F9.6))') 'V   =',v
       WRITE(*,'(A,3(1X,F9.6))') 'W   =',wr,wg,wb
    ENDIF
    RETURN
  END SUBROUTINE rgbhelix_basevectors

! Proposed best-weights fit routine (for post-processing only)

  SUBROUTINE colorhelix_gray_error
    IMPLICIT NONE
    INTEGER :: i
    DOUBLE PRECISION :: diff,sqdiff,sqsum,sqerr,stderr
    sqsum=0.d0
    DO i=0,nlevels
       diff=gry(i)-xgry(i)
       IF (diff/=diff) diff=0.d0!NaN handling
       sqdiff=diff*diff
       sqsum=sqsum+sqdiff
!       WRITE(*,'(A,I8,4X,3(F16.8))') 'i,diff,sqdiff,sqsum =',i,diff,sqdiff,sqsum
    ENDDO
!    WRITE(*,'(A,3(F16.8))') 'diff,sqdiff,sqsum =',diff,sqdiff,sqsum
!---Calculate standard error
!   Use N=nlevels+1 instead of N-1 since reference is given by gamma function,
!   not by sample average
    sqerr=sqsum/(nlevels+1)
    stderr=sqrt(sqerr)
    WRITE(*,'(/A,F12.8/)') 'Gray standard error:',stderr
  END SUBROUTINE colorhelix_gray_error

  SUBROUTINE colorhelix_gray_slopes
!    USE palette_core!, ONLY : xgry,gry,slope_gry,mingryslope,maxgryslope, wr,wg,wb, nlevels
    IMPLICIT NONE
    INTEGER :: i
    DOUBLE PRECISION :: x,dx,dgdx,d2prev,d2next,minslope,maxslope
    dx=1.d0/nlevels
    ismonotonic=.TRUE.
    mingryslope=1.d30;maxgryslope=-1.d30
!    DO i=0,nlevels
    DO i=lmin_maxsat,lmax_maxsat
       x=dble(i)/nlevels
       IF (i>0)       d2prev=gry(i)-gry(i-1)
       IF (i<nlevels) d2next=gry(i+1)-gry(i)
       IF (i==0) THEN
          d2prev=1.d-15!tiny positive
          dgdx=d2next/dx
       ELSE IF (i==nlevels) THEN
          d2next=1.d-15!tiny positive
          dgdx=d2prev/dx
       ELSE
          dgdx=0.5d0*(d2prev+d2next)/dx
       ENDIF
       minslope=min(d2prev,d2next,dgdx)
       maxslope=max(d2prev,d2next,dgdx)
       ismonotonic = ismonotonic .AND. d2prev>0.d0
!       if (verbose>=1.AND.d2prev<=0.d0) write(*,*) 'i,d2prev,minslope,gry =',i,d2prev,minslope,gry(i)
       IF (maxslope>maxgryslope) THEN
          maxgryslope=maxslope
          imaxgryslope=i
       ENDIF
       IF (minslope<mingryslope) THEN
          mingryslope=minslope
          imingryslope=i
       ENDIF
       slope_gry(i)=dgdx
       d2prev_gry(i)=d2prev
       d2next_gry(i)=d2next
    ENDDO
  END SUBROUTINE colorhelix_gray_slopes

  SUBROUTINE colorhelix_rgb_gamma(RGBin,RGBout,direction)
    IMPLICIT NONE
    INTEGER :: direction
    DOUBLE PRECISION,DIMENSION(3) :: RGBin,RGBout
    IF (rgb_gamma<1.d-2) THEN!Assume sRGB
!       WRITE(*,*) 'COLGAMMA: Using sRGB-gamma; input-g =',gamma
       CALL srgb_gamma(RGBin,RGBout,direction)
    ELSE
!       WRITE(*,*) 'COLGAMMA: Using power-law; input-g =',gamma
       CALL corr_gamma(RGBin,RGBout,rgb_gamma,direction)
    ENDIF
    RETURN
  END SUBROUTINE colorhelix_rgb_gamma

  SUBROUTINE scurve(x,xscurve)
    IMPLICIT NONE
    DOUBLE PRECISION :: xscurve,x
    DOUBLE PRECISION :: x05,xs,xw
    x05=2.d0*(x-0.5d0)
    xs=sign(abs(x05)**pwr_scurve,x05)
    xw=sw_scurve*xs+(1.d0-sw_scurve)*x05
    xscurve=(xw+1.d0)/2.d0
    RETURN
  END SUBROUTINE scurve

  SUBROUTINE ini_ciecam02
    IMPLICIT NONE
    INTEGER :: i
    DOUBLE PRECISION :: yscal_bg,xyz_corr,dum1
    DOUBLE PRECISION,DIMENSION(3) :: XYZtest,dum3
    DOUBLE PRECISION,DIMENSION(3) :: JChtest=(/100.d0,0.d0,0.d0/),JCheuctest
    IF (did_ini_ciecam02) RETURN
    flg_catmod=2
    cdm2_illum=500.d0!*pi
    surround_condition_select=1
!    IXYZ_background=XYZWHITE*20.d0
    IXYZ_illuminant=XYZWHITE*100.d0
!    IXYZ_reference =XYZWHITE*100.d0
    IXYZ_reference =(/100.d0,100.d0,100.d0/)!Equal energy as reference
    OPEN(70,FILE='colorhelix-ciecam02.par',STATUS='OLD')
    READ(70,*) surround_condition_select
    READ(70,*) cdm2_illum
    READ(70,*) yscal_bg
    READ(70,*) flg_catmod
    CLOSE(70)
    IXYZ_background=max(min(yscal_bg,100.d0),0.d0)*XYZWHITE
! Output for testrgbtable
    OPEN(71,FILE='colorhelix-ciecam02.aux')
    WRITE(71,7100) flg_catmod,surround_condition_select,cdm2_illum,&
         IXYZ_background,IXYZ_illuminant,IXYZ_reference
    CLOSE(71)
    XYZtest=IXYZ_illuminant
    CALL wrap_ciecam02(XYZtest,JChtest,dum3,qmode,1,-1)
    IF (flg_maxrgb==1) THEN
       xyz_corr=(minval(XYZtest(:)/IXYZ_illuminant(:)))**1.11d0
       XYZtest=IXYZ_illuminant/xyz_corr
       CALL wrap_ciecam02(XYZtest,JChtest,dum3,qmode,1,1)
    ENDIF
    CALL euc2ciecam(JChtest,JCheuctest,1)
    scal_jch=JChtest(1)/100.d0
    scal_jcheuc=JCheuctest(1)/100.d0
    did_ini_ciecam02=.TRUE.
    IF (verbose>=1) THEN
       WRITE(*,'(A,3(2X,F14.8))') 'XYZtest    =',XYZtest
       WRITE(*,'(A,3(2X,F14.8))') 'Jtest_ini  =',dum1
       WRITE(*,'(A,3(2X,F14.8))') 'JChtest    =',JChtest
       WRITE(*,'(A,3(2X,F14.8))') 'JCheuctest =',JCheuctest
       WRITE(*,'(A,3(2X,F14.8))') 'xyz_corr   =',xyz_corr
       WRITE(*,'(A,3(2X,F14.8))') 'scal_jch   =',scal_jch
       WRITE(*,'(A,3(2X,F14.8))') 'scal_jcheuc=',scal_jcheuc
    ENDIF
7100 FORMAT(2(5X,I2)/F16.8,&
          3(/3(2X,F14.8)))
    RETURN
  END SUBROUTINE ini_ciecam02

END MODULE colorhelix_module
