MODULE palette_core
  INTEGER,PARAMETER :: nlevels_max=65535
  INTEGER :: nlevels,levelorder,selrgb,selwluma,surround_condition=1!dim
  DOUBLE PRECISION :: CCT
  DOUBLE PRECISION,DIMENSION(1:3,1:3) :: mat_xyz2rgb,mat_rgb2xyz
  DOUBLE PRECISION,DIMENSION(1:3) :: XYZwhite=(/0.95047d0,1.00000d0,1.08883d0/)!use D65 as default
!  DOUBLE PRECISION,DIMENSION(1:3) :: XYZwhite=(/0.95046998d0,1.d0,1.08883000d0/)!better match to Lindbloom matrix
  DOUBLE PRECISION,DIMENSION(1:3) :: XYZwref=(/0.95047d0,1.00000d0,1.08883d0/)
  DOUBLE PRECISION,DIMENSION(1:3) :: XYZbg=(/0.95047d0,1.00000d0,1.08883d0/)*0.2d0!dim grey as CIECAM02 default (Note: D65 here instead of E)
!  DOUBLE PRECISION :: Ew=1570.796327d0!500pi lux for LA=100 as default
  DOUBLE PRECISION :: Ew=1785.398163d0!250pi lux for LA=50 as default
  DOUBLE PRECISION,DIMENSION(:),ALLOCATABLE :: xgry,gry,red,grn,blu,Lstar,astar,bstar
  DOUBLE PRECISION,DIMENSION(:),ALLOCATABLE :: slope_gry,d2prev_gry,d2next_gry
  DOUBLE PRECISION,DIMENSION(:,:),ALLOCATABLE :: CIELAB,CIEXYZ,CIELCH,auxtable
  DOUBLE PRECISION :: wr,wg,wb
  DOUBLE PRECISION,DIMENSION(1:3,1:4) :: all_wluma=RESHAPE((/0.30d0,   0.59d0,    0.11d0,&
                                                            0.299d0,   0.587d0,   0.114d0,&
                                                            0.2126d0,  0.7152d0,  0.0722d0,&
                                                            0.212673d0,0.715152d0,0.072175d0/),(/3,4/))
  INTEGER,DIMENSION(:),ALLOCATABLE :: flags_palette
  INTEGER,DIMENSION(:,:),ALLOCATABLE :: palette_hole_borders
  LOGICAL :: doalloc_palette=.TRUE.

CONTAINS
  
  SUBROUTINE palette_initialize
    IF (doalloc_palette) THEN
       ALLOCATE(xgry(0:nlevels))
       ALLOCATE(gry(0:nlevels))
       ALLOCATE(slope_gry(0:nlevels))
       ALLOCATE(d2prev_gry(0:nlevels))
       ALLOCATE(d2next_gry(0:nlevels))
       ALLOCATE(red(0:nlevels))
       ALLOCATE(grn(0:nlevels))
       ALLOCATE(blu(0:nlevels))
       ALLOCATE(Lstar(0:nlevels))
       ALLOCATE(astar(0:nlevels))
       ALLOCATE(bstar(0:nlevels))
       ALLOCATE(CIELAB(1:3,0:nlevels))
       ALLOCATE(CIELCH(1:3,0:nlevels))
       ALLOCATE(CIEXYZ(1:3,0:nlevels))
       ALLOCATE(auxtable(1:10,0:nlevels))
       ALLOCATE(flags_palette(0:nlevels))
       ALLOCATE(palette_hole_borders(0:1,1:nlevels))!intentionally 1:nlevels here (simple counter)
       doalloc_palette=.FALSE.
    ENDIF
  END SUBROUTINE palette_initialize
END MODULE palette_core

MODULE palette_diagnostics
  INTEGER :: verbose=0,nlo(0:3),nhi(0:3),imingryslope,imaxgryslope,n_nan
  DOUBLE PRECISION :: mindev(0:3),maxdev(0:3),mingryslope,maxgryslope
  LOGICAL :: ismonotonic
  CONTAINS

  SUBROUTINE palette_checkvalues(rgb0,rgb)
    USE palette_core, ONLY : wr,wg,wb
    IMPLICIT NONE
!    USE palette_diagnostics
!    USE diverse_mathconst
    INTEGER :: j
    DOUBLE PRECISION :: rgb0(1:3),rgb(1:3),dv(0:3)
    rgb(1:3)=rgb0(1:3)!first assume correct values
    DO j=1,3
       IF (rgb0(j)<0.d0) THEN
          rgb(j)=0.d0
          nlo(j)=nlo(j)+1
          nlo(0)=nlo(0)+1
!          WRITE(*,'(A,I4,2(F11.6))') 'LO: j,rgb0,rgb =',j,rgb0(j),rgb(j)
       ELSE IF (rgb0(j)>1.d0) THEN
          rgb(j)=1.d0
          nhi(j)=nhi(j)+1
          nhi(0)=nhi(0)+1
!          WRITE(*,'(A,I4,2(F11.6))') 'HI: j,rgb0,rgb =',j,rgb0(j),rgb(j)
       ENDIF
       dv(j)=rgb0(j)-rgb(j)
       IF (dv(j)<mindev(j)) mindev(j)=dv(j)
       IF (dv(j)>maxdev(j)) maxdev(j)=dv(j)
    ENDDO
!    WRITE(*,'(A,I4,2(2X,3(2X,F11.6)))') 'rgb0,rgb =',j,rgb0,rgb
    dv(0)=wr*dv(1)+wg*dv(2)+wb*dv(3)
!    dv(0)=wr*rgb0(1)+wg*rgb0(2)+wb*rgb0(3)-(wr*rgb(1)+wg*rgb(2)+wb*rgb(3))
!    dv(0)=wr*rgb0(1)-wr*rgb(1)+wg*rgb0(2)-wg*rgb(2)+wb*rgb0(3)-wb*rgb(3)
!    dv(0)=wr*(rgb0(1)-rgb(1))+wg*(rgb0(2)-rgb(2))+wb*(rgb0(3)-rgb(3))
    IF (dv(0)<mindev(0)) mindev(0)=dv(0)
    IF (dv(0)>maxdev(0)) maxdev(0)=dv(0)
    RETURN
  END SUBROUTINE palette_checkvalues

  SUBROUTINE palette_sanity
    USE palette_core
    IMPLICIT NONE
    INTEGER :: i,i_nan,flg_hole,iopen,iclose
    DOUBLE PRECISION :: x,x0,x1,delx,t
    DOUBLE PRECISION,DIMENSION(1:3) :: rgb,rgb0,rgb1
    LOGICAL :: is_nan
    n_nan=0
    flg_hole=0
    DO i=0,nlevels
       is_nan = red(i)/=red(i).OR.grn(i)/=grn(i).OR.blu(i)/=blu(i)
       IF (is_nan.AND.flg_hole==0) THEN
          flg_hole=1!hole is now open
          n_nan=n_nan+1
          iopen=i-1
          palette_hole_borders(0,n_nan)=iopen!last valid entry; to be checked: what if i==0 here?
       ELSE IF (.not.is_nan.AND.flg_hole==1) THEN
          flg_hole=0!hole is closed again
          iclose=i
          palette_hole_borders(1,n_nan)=iclose!next valid entry
          WRITE(*,'(A,I5,A,I5","I5)') 'Detected palette defect No.',n_nan,' with borders:',iopen,iclose
       ENDIF
    ENDDO
    IF (n_nan>0) THEN!Fill holes by interpolated values
       DO i_nan=1,n_nan
          WRITE(*,'(A,I5)') 'Fixing palette defect No.',n_nan
          iopen =palette_hole_borders(0,i_nan)
          iclose=palette_hole_borders(1,i_nan)
          rgb0=(/red(iopen),grn(iopen),blu(iopen)/)
          rgb1=(/red(iclose),grn(iclose),blu(iclose)/)
          x0=dble(iopen)/nlevels
          x1=dble(iclose)/nlevels
          delx=x1-x0
          DO i=iopen+1,iclose-1
             x=dble(i)/nlevels
             t=(x-x0)/delx
             rgb=t*rgb1+(1.d0-t)*rgb0
             red(i)=rgb(1); grn(i)=rgb(2); blu(i)=rgb(3)
          ENDDO
       ENDDO
       flags_palette=0!Boldly assume successful repair
    ELSE
       PRINT *,'Nothing to fix...'
    ENDIF
    RETURN
  END SUBROUTINE palette_sanity

END MODULE palette_diagnostics

MODULE palette_modules
  USE palette_core
  USE palette_diagnostics
END MODULE palette_modules
