!    Test RGB Table
!    Copyright (C) 2012 by Ingo Thies 
!
!    TestRGBtable is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 2 of the License, or
!    (at your option) any later version.
!
!    TestRGBtable is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with TestRGBtable. If not, see <http://www.gnu.org/licenses/>.
!
  PROGRAM testrgbtable
    USE color_functions_extended
    USE color_functions_ciecam02
    USE palette_modules
    IMPLICIT NONE
    INTEGER :: i,nt,degmode=1,inpmode=11
    REAL(KIND=CF_DOUBLE) :: t,rgb_gamma
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: red_prim,grn_prim,blu_prim,wht_prim
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: urgb_ini,xyz_ini
    REAL(KIND=CF_DOUBLE),DIMENSION(0:3,0:nlevels_max) :: rgbtable
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: srgb,rgblin,Ixyz,xyz
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: Lab,Lab99o,Lab99d,LCh,LCh99o,LCh99d,IPT100,ICh100,IPTEUC,IChEUC
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: JCh,QMH,JChnew,Jab,JabEUC,Jabhq,JabEUChq,coeffs
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: oLab,oLab99o,oLab99d,oIPT100,oIPTEUC,oJCh,oQMH
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: iLab,iLab99o,iLab99d,iIPT100,iIPTEUC,iJCh,iQMH
    REAL(KIND=CF_DOUBLE),DIMENSION(3) :: sLab,sLab99o,sLab99d,sIPT100,sIPTEUC,sJCh,sQMH
    REAL(KIND=CF_DOUBLE) :: DE_Lab76,DE_Lab99d,DE_Lab99o,DE_IPT100,DE_IPTEUC,DE2000,DE02
    REAL(KIND=CF_DOUBLE) :: DN_Lab76,DN_Lab99d,DN_Lab99o,DN_IPT100,DN_IPTEUC,DN2000,DN02
    REAL(KIND=CF_DOUBLE) :: SE_Lab76,SE_Lab99d,SE_Lab99o,SE_IPT100,SE_IPTEUC,SE2000,SE02
    REAL(KIND=CF_DOUBLE),DIMENSION(0:1,0:nlevels_max) :: all_DE_Lab76,all_DE_Lab99d,all_DE_Lab99o,&
         all_DE_IPT100,all_DE_IPTEUC,all_DE2000,all_DE02
    CHARACTER(LEN=30) :: infile,xyzfile,labfile,l99ofile,l99dfile,iptfile,iptefile,allfile,gpauxfile, &
         jabfile,jabefile,qmhfile
    LOGICAL :: iscolorhelix=.FALSE.
    WRITE(*,*) 'Enter name of GP-RGB color table:'
    READ(*,*) infile
    WRITE(*,*) 'infile = "',trim(infile),'"'
    iscolorhelix=trim(infile)=='colorhelix.rgb'
    IF (iscolorhelix) THEN
       WRITE(*,*) 'Reading auxiliary data from Colorhelix'
       OPEN(10,FILE='colorhelix-rgbdat.aux')
       READ(10,*) red_prim
       READ(10,*) grn_prim
       READ(10,*) blu_prim
       READ(10,*) wht_prim
       READ(10,*) XYZwhite
       READ(10,*) rgb_gamma
       READ(10,*) urgb_ini
       READ(10,*) xyz_ini
       CLOSE(10)
    ELSE
       WRITE(*,*) 'Using default (=sRGB) auxiliary data'
       red_prim=srgb_red
       grn_prim=srgb_grn
       blu_prim=srgb_blu
       wht_prim=srgb_wht
       XYZwhite=whitepoint_d65
       rgb_gamma=0.d0!force wrap_rgb_gamma to switch to sRGB
       xyz_ini=srgb_wht
       urgb_ini=(/1.d0,1.d0,1.d0/)
    ENDIF
    CALL getrgb(red_prim,grn_prim,blu_prim,XYZwhite,mat_xyz2rgb,mat_rgb2xyz)
    OPEN(11,FILE=trim(infile))
    CALL skipline(11)
    DO i=0,nlevels_max
       READ(11,*,END=11) rgbtable(0:3,i)
       nt=i
    ENDDO
11  CLOSE(11)
    WRITE(*,'(/A,I6/)') 'Number of colors found:',nt
    OPEN(12,FILE='colorhelix-ciecam02.aux')
    READ(12,*) flg_catmod,surround_condition_select
    READ(12,*) cdm2_illum
    READ(12,*) IXYZ_background
    READ(12,*) IXYZ_illuminant
    READ(12,*) IXYZ_reference
    CLOSE(12)
    gpauxfile='xrgbtable-gp.aux'
    xyzfile='xrgbtable.xyz'
    labfile='xrgbtable.lab'
    l99ofile='xrgbtable.l99o'
    l99dfile='xrgbtable.l99d'
    iptfile='xrgbtable.ipt'
    iptefile='xrgbtable.ipte'
    jabfile='xrgbtable.jab'
    jabefile='xrgbtable.jabe'
    qmhfile='xrgbtable.qmh'
    allfile='xrgbtable-all-cart.dat'
    OPEN(16,file=gpauxfile)
    OPEN(20,file=xyzfile)
    OPEN(21,file=labfile)
    OPEN(22,file=l99dfile)
    OPEN(23,file=l99ofile)
    OPEN(24,file=iptfile)
    OPEN(25,file=iptefile)
    OPEN(26,file=jabfile)
    OPEN(27,file=jabefile)
    OPEN(28,file=qmhfile)
    OPEN(30,file=allfile)
    WRITE(16,'("XWP   =",F9.6,"; YWP   =",F9.6,"; ZWP   =",F9.6)') XYZwhite
    WRITE(16,'("xwhite=",F9.6,"; ywhite=",F9.6,"; zwhite=",F9.6)') wht_prim
    WRITE(16,'("xred  =",F9.6,"; yred  =",F9.6,"; zred  =",F9.6)') red_prim
    WRITE(16,'("xgreen=",F9.6,"; ygreen=",F9.6,"; zgreen=",F9.6)') grn_prim
    WRITE(16,'("xblue =",F9.6,"; yblue =",F9.6,"; zblue =",F9.6)') blu_prim
    IF (iscolorhelix) THEN
       WRITE(16,'(A)') '##########################'
       WRITE(16,'(A)') 'load ''colorhelix-gp.aux'''
       WRITE(16,'(A)') '##########################'
    ENDIF
    CLOSE(16)
    WRITE(20,1001) '#i','Level','R','G','B','X','Y','Z','x','y','z'
    WRITE(21,1001) '#i','Level','R','G','B','L*','a*','b*','C*','h*'
    WRITE(22,1001) '#i','Level','R','G','B','L99d','a99d','b99d','C99d','h99d'
    WRITE(23,1001) '#i','Level','R','G','B','L99o','a99o','b99o','C99o','h99o'
    WRITE(24,1001) '#i','Level','R','G','B','I100','P100','T100','C100','hdeg'
    WRITE(25,1001) '#i','Level','R','G','B','IEUC','PEUC','TEUC','CEUC','hdeg'
    WRITE(30,1001) '#1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17',&
         '18','19','20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36'
    WRITE(30,1001) '#i','Level','R','G','B','X','Y','Z','x','y', &
         'L*','a*','b*','L99d','a99d','b99d','L99o','a99o','b99o','I100','P100','T100','IEUC','PEUC','TEUC',&
         'J02-UCS','a02-UCS','b02-UCS','J02-EUC','a02-EUC','b02-EUC',&
         'J02','a02-Hq','b02-Hq','a02-EUC-Hq','b02-EUC-Hq'
    DO i=0,nt
       t=rgbtable(0,i)
       srgb(1)=rgbtable(1,i)
       srgb(2)=rgbtable(2,i)
       srgb(3)=rgbtable(3,i)
!       write(*,*) 'rgb_gamma =',rgb_gamma
       CALL wrap_rgb_gamma(srgb,rgblin,rgb_gamma,-1)
       CALL operate_matrix3x3(mat_rgb2xyz,rgblin,Ixyz)
       IF (sum(Ixyz)==0.d0) THEN
          xyz=xyz_ini
       ELSE
          xyz=Ixyz/sum(Ixyz)
       ENDIF
       CALL xyz2lab(Ixyz,XYZwhite,Lab)
       CALL Lab2L99o(Lab,Lab99o,LCh99o,degmode)
       CALL lab2lch(Lab,LCh,1,degmode)
       CALL lab2lch(Lab99o,LCh99o,1,degmode)
       CALL XYZ2DIN99d(Ixyz,XYZwhite,Lab99d,LCh99d,degmode)
       CALL xyz2ipt100(IXYZ,XYZwhite,1,IPT100)
       CALL xyz2ipteuc(IXYZ,XYZwhite,1,IPTEUC)
       CALL ipt2ich(IPT100,ICh100,2,1)!here: LCh=ICh100 & IPT=IPT100,reverse direction
       CALL wrap_ciecam02(IXYZ,JCh,QMH,0,inpmode,1)
       CALL ciecam02_JMh2Jab(JCh,QMH,Jab,coeffs,0,degmode)
       CALL ciecam02_JMh2Jab(JCh,QMH,JabEUC,coeffs,-1,degmode)
       CALL ciecam02_JMh2Jab(JCh,QMH,Jabhq,coeffs,-2,degmode)
       CALL ciecam02_JMh2Jab(JCh,QMH,JabEUChq,coeffs,-3,degmode)
!       CALL euc2ciecam(JCh,JChnew,1)
       IF (i==0) THEN
! initialize color diff data
          iLab=Lab;iLab99d=Lab99d;iLab99o=Lab99o;iIPT100=IPT100;iIPTEUC=IPTEUC;iJCh=JCh;iQMH=QMH
          DE_Lab76=0.d0;DE_Lab99d=0.d0;DE_Lab99o=0.d0;DE_IPT100=0.d0;DE_IPTEUC=0.d0;DE2000=0.d0;DE02=0.d0
          SE_Lab76=0.d0;SE_Lab99d=0.d0;SE_Lab99o=0.d0;SE_IPT100=0.d0;SE_IPTEUC=0.d0;SE2000=0.d0;SE02=0.d0
       ELSE
! calculate stepwise colordiffs
          DE_Lab76 =sqrt((Lab(1)-oLab(1))**2+(Lab(2)-oLab(2))**2+(Lab(3)-oLab(3))**2)
          DE_Lab99d=sqrt((Lab99d(1)-oLab99d(1))**2+(Lab99d(2)-oLab99d(2))**2+(Lab99d(3)-oLab99d(3))**2)
          DE_Lab99o=sqrt((Lab99o(1)-oLab99o(1))**2+(Lab99o(2)-oLab99o(2))**2+(Lab99o(3)-oLab99o(3))**2)
          DE_IPT100=sqrt((IPT100(1)-oIPT100(1))**2+(IPT100(2)-oIPT100(2))**2+(IPT100(3)-oIPT100(3))**2)
          DE_IPTEUC=sqrt((IPTEUC(1)-oIPTEUC(1))**2+(IPTEUC(2)-oIPTEUC(2))**2+(IPTEUC(3)-oIPTEUC(3))**2)
          CALL CIEDE2000(Lab,oLab,DE2000)
          CALL ciecam02_diff(JCh,QMH,oJCh,oQMH,DE02,0,degmode)
! advance path integrals
          SE_Lab76 =SE_Lab76 +DE_Lab76
          SE_Lab99d=SE_Lab99d+DE_Lab99d
          SE_Lab99o=SE_Lab99o+DE_Lab99o
          SE_IPT100=SE_IPT100+DE_IPT100
          SE_IPTEUC=SE_IPTEUC+DE_IPTEUC
          SE2000   =SE2000+DE2000
          SE02     =SE02+DE02  
       ENDIF
       all_DE_Lab76(0,i) =DE_Lab76 ; all_DE_Lab76(1,i) =SE_Lab76
       all_DE_Lab99d(0,i)  =DE_Lab99d  ; all_DE_Lab99d(1,i)  =SE_Lab99d
       all_DE_Lab99o(0,i)  =DE_Lab99o  ; all_DE_Lab99o(1,i)  =SE_Lab99o
       all_DE_IPT100(0,i)=DE_IPT100; all_DE_IPT100(1,i)=SE_IPT100
       all_DE_IPTEUC(0,i)=DE_IPTEUC; all_DE_IPTEUC(1,i)=SE_IPTEUC
       all_DE2000(0,i)   =DE2000   ; all_DE2000(1,i)   =SE2000
       all_DE02  (0,i)   =DE02     ; all_DE02(1,i)     =SE02  
       oLab=Lab;oLab99d=Lab99d;oLab99o=Lab99o;oIPT100=IPT100;oIPTEUC=IPTEUC;oJCh=JCh;oQMH=QMH
       WRITE(20,1000) i,t,srgb,Ixyz,xyz
       WRITE(21,1000) i,t,srgb,lab,lch(2:3)
       WRITE(22,1000) i,t,srgb,lab99d,lch99d(2:3)
       WRITE(23,1000) i,t,srgb,lab99o,lch99o(2:3)
       WRITE(24,1000) i,t,srgb,IPT100,Ich100(2:3)
       WRITE(25,1000) i,t,srgb,IPTEUC,IchEUC(2:3)
       WRITE(30,1000) i,t,srgb,Ixyz,xyz(1:2),lab,lab99d,lab99o,ipt100,ipteuc,Jab,JabEUC,Jabhq,JabEUChq(2:3)!,JabEUChq(1)-JabEUC(1)
    ENDDO
! calculate start-to-finish difference (NOT equal to integrated differences)
    DN_Lab76= sqrt((Lab(1)-iLab(1))**2+(Lab(2)-iLab(2))**2+(Lab(3)-iLab(3))**2)
    DN_Lab99d=sqrt((Lab99d(1)-iLab99d(1))**2+(Lab99d(2)-iLab99d(2))**2+(Lab99d(3)-iLab99d(3))**2)
    DN_Lab99o=sqrt((Lab99o(1)-iLab99o(1))**2+(Lab99o(2)-iLab99o(2))**2+(Lab99o(3)-iLab99o(3))**2)
    DN_IPT100=sqrt((IPT100(1)-iIPT100(1))**2+(IPT100(2)-iIPT100(2))**2+(IPT100(3)-iIPT100(3))**2)
    DN_IPTEUC=sqrt((IPTEUC(1)-iIPTEUC(1))**2+(IPTEUC(2)-iIPTEUC(2))**2+(IPTEUC(3)-iIPTEUC(3))**2)
!    CALL CIEDE2000(Lab,iLab,DN2000)
    DN2000=75.15318666d0!empirically measured along straight line (RGBhelix) with unity gamma
    CALL ciecam02_diff(JCh,QMH,iJCh,iQMH,DN02,0,degmode)
! debugging
!    DN_Lab76=1.d0;DN_Lab99d=1.d0;DN_Lab99o=1.d0;DN_IPT100=1.d0;DN_IPTEUC=1.d0;DN2000=1.d0;DN02=1.d0
    CLOSE(20)
    CLOSE(21)
    CLOSE(22)
    CLOSE(23)
    CLOSE(24)
    CLOSE(25)
    CLOSE(30)
    WRITE(*,2000) -1,0.,DN_Lab76,DN_Lab99d,DN_Lab99o,DN_IPT100,DN_IPTEUC,DN2000,DN02
    OPEN(42,FILE='xrgbtable-colordiffs.dat')
    OPEN(43,FILE='xrgbtable-colorpaths.dat')
    WRITE(42,2001) '#i','Level','DE_Lab76','DE_DIN99d','DE_DIN99o','DE_IPT100','DE_IPTEUC','DE_CIEDE2000','DE_CIECAM02'
    WRITE(43,2001) '#i','Level','SE_Lab76','SE_DIN99d','SE_DIN99o','SE_IPT100','SE_IPTEUC','SE_CIEDE2000','SE_CIECAM02'
    DO i=0,nt
       t=rgbtable(0,i)
! re-use SE* as (now scaled) path meter
       DE_Lab76 =all_DE_Lab76(0,i)
       DE_Lab99d=all_DE_Lab99d(0,i)
       DE_Lab99o=all_DE_Lab99o(0,i)
       DE_IPT100=all_DE_IPT100(0,i)
       DE_IPTEUC=all_DE_IPTEUC(0,i)
       DE2000   =all_DE2000(0,i)
       DE02     =all_DE02(0,i)
       SE_Lab76 =all_DE_Lab76(1,i) /DN_Lab76
       SE_Lab99d=all_DE_Lab99d(1,i)/DN_Lab99d
       SE_Lab99o=all_DE_Lab99o(1,i)/DN_Lab99o
       SE_IPT100=all_DE_IPT100(1,i)/DN_IPT100
       SE_IPTEUC=all_DE_IPTEUC(1,i)/DN_IPTEUC
       SE2000   =all_DE2000(1,i)   /DN2000
       SE02     =all_DE02(1,i)     /DN02
       WRITE(42,2000) i,t,DE_Lab76,DE_Lab99d,DE_Lab99o,DE_IPT100,DE_IPTEUC,DE2000,DE02
       WRITE(43,2000) i,t,SE_Lab76,SE_Lab99d,SE_Lab99o,SE_IPT100,SE_IPTEUC,SE2000,SE02
    ENDDO
    CLOSE(42)
    CLOSE(43)
1000 FORMAT(I4,1X,F14.8,2X,12(2X,3(2X,F16.8)))
1100 FORMAT(I4,1X,F14.8,2X,12(2X,3(2X,E16.8)))
1001 FORMAT(A4,1X,A14,  2X,12(2X,3(2X,A16)))
2000 FORMAT(I4,1X,F14.8,2X,12(2X,F16.8))
2001 FORMAT(A4,1X,A14,  2X,12(2X,A16))
  END PROGRAM testrgbtable

  SUBROUTINE skipline(iufile)
    CHARACTER(LEN=100) :: line
    CHARACTER(LEN=1) :: first
    INTEGER :: iufile,ufile,nskip,i
    LOGICAL :: verbose=.FALSE.,goodline
!    verbose=.TRUE.
    ufile=abs(iufile)
    nskip=0
10  READ(ufile,'(a)',ERR=50,END=60) line
    DO i=1,100
       first=line(i:i)
       IF (first.ne. ' '.AND. first.ne.char(0)) EXIT
    ENDDO
    goodline=first.NE.'#' .AND. first.NE.'C' .AND. first.NE.'c' .AND.  &
             first.NE.';' .AND. first.NE.'%' .AND. first.NE.'!' .AND. line.NE.' '
    IF (goodline) THEN
       BACKSPACE ufile
       IF (verbose) THEN
          WRITE(*,*)
          WRITE(*,*) 'SKIPLINE: Skipped',nskip,' lines'
          WRITE(*,*)
       ENDIF
       RETURN
    ELSE
       nskip=nskip+1
       GOTO 10
    ENDIF

50  CONTINUE
    WRITE(*,*) ' nextline: error in reading line from unit ',ufile
    STOP
60  CONTINUE
    PRINT*,' nextline: end of file (may be regular)'
    RETURN
  END SUBROUTINE skipline
