#### Testing RGB tables in Gnuplot ####
#### (runs best with Gnuplot 4.5+) ####
reset
#### GP version (best is 4.6 ot later)
gpversion=4.6 # if gpversion >=4.5, then palette-coloured lines are used
labmode=5    #1:CIELAB, 2:DIN99d, 3:DIN99o, 4: IPT, 5:IPT-EUC, EXPERIMENTAL: 6:CIECAM02-UCS, 7:''-EUC, 8: ''-Hquad
splotzoom=1.2
### automatic run (comment out to enable)
#!colorhelix
#!testrgbtable < testrgbtable.inp
## File selection ########
strgpath='./'
tablename='xrgbtable-all-cart.dat'
tablefile=strgpath.tablename
cdiffname='xrgbtable-colordiffs.dat'
cdifffile=strgpath.cdiffname
cpathname='xrgbtable-colorpaths.dat'
cpathfile=strgpath.cpathname
ciebordername='CIE1931border_400-700-1nm.dat'
cieticsname='CIE1931tics_400-700-1nm.gp'
cieborderfile=strgpath.ciebordername
cieticsfile=strgpath.cieticsname
planckname='planckcurve-fullrange.dat'
antiplanckname='planckcurve-negative.dat'
planckfile=strgpath.planckname
antiplanckfile=strgpath.antiplanckname
planckticsname='planckxytics-kelvin-1000-10000.gp'
planckticsfile=strgpath.planckticsname
maxlevel=1.
#### test params (will be overrun if colorhelix-gp.aux is loaded)
qexp=1.#default
#qexp=1./1.5#reference gamma
wr=0.30;  wg=0.59;  wb=0.11  # NTSC/Postscript
#wr=0.299; wg=0.587; wb=0.114 # PAL
#wr=0.2126;wg=0.7152;wb=0.0722# HDTV
#wr=.212673;wg=.715152;wb=.072175 # sRGB to XYZ, preset=4
load 'xrgbtable-gp.aux'
print 'testpalette: wr,wg,wb,q =',wr,wg,wb,qexp
lws=2.
strgbackground='#d0d0d0'
set style line  1 lt 1 lw 1.00*lws lc rgb '#ff0000'
set style line  2 lt 1 lw 1.00*lws lc rgb '#00aa00'
set style line  3 lt 1 lw 1.00*lws lc rgb '#0000ff'
set style line  4 lt 1 lw 1.00*lws lc rgb '#000000'
set style line  5 lt 1 lw 1.00*lws lc rgb '#7f7f7f'
set style line  6 lt 1 lw 1.00*lws lc rgb variable
set style line 10 lt 1 lw 0.50*lws lc rgb '#000000'
set style line 11 lt 1 lw 0.50*lws lc rgb '#888888'
set style line 12 lt 1 lw 0.50*lws lc rgb '#bbbbbb'
set style line 13 lt 1 lw 0.50*lws lc rgb '#0000ff'
set style line 14 lt 1 lw 0.50*lws lc rgb '#7f7f7f'
set style line 21 lt 1 lw 1.00*lws lc rgb '#ff0000'
set style line 22 lt 1 lw 1.00*lws lc rgb '#00a000'
set style line 23 lt 1 lw 1.00*lws lc rgb '#007f00'
set style line 24 lt 1 lw 1.00*lws lc rgb '#0000ff'
set style line 25 lt 1 lw 1.00*lws lc rgb '#007fff'
set style line 26 lt 1 lw 1.00*lws lc rgb '#ff7f00'
set style line 27 lt 1 lw 1.00*lws lc rgb '#a000a0'
set border ls 10
if (gpversion>=4.5)  set term x11 1 background strgbackground #dummy term to get background colour
set term x11 1 close
set term x11 2 close
set term x11 3 close
set term x11 4 close
set term x11 5 close
set term x11 6 close
set term x11 7 close
####
fw(r,g,b)=wr*r/maxlevel+wg*g/maxlevel+wb*b/maxlevel
frgb(r,g,b)=int(255./maxlevel*r)*65536 + int(255./maxlevel*g)*256 + int(255./maxlevel*b)
fggg(r,g,b)=int(255.*fw(r,g,b))*65536 + int(255.*fw(r,g,b))*256 + int(255.*fw(r,g,b))
##################################
#### RGB profile #################
##################################
set term x11 1 size 640,480 title 'RGB profile'
set xrange [0:1]
set yrange [0.:1.]
set xtics 0.1; set mxtics 5; set ytics 0.1; set mytics 5
#unset xlabel; unset ylabel
set key left
set multiplot
set grid xtics ytics mxtics mytics ls 11, ls 12
set lmargin screen 0.05; set rmargin screen 0.99
set bmargin screen 0.20; set tmargin screen 0.99
plot tablefile using 2:3 t 'red'   w l ls 1,\
     tablefile using 2:4 t 'green' w l ls 2,\
     tablefile using 2:5 t 'blue'  w l ls 3,\
     tablefile using 2:(fw($3,$4,$5)) t 'gray' w l ls 4,\
     x**qexp w l ls 5
unset grid
set tics front
set format x ""
set bmargin screen 0.08; set tmargin screen 0.15
set palette file tablefile u 2:3:4:5
set xrange [0:1];set cbrange [0:1]; unset ytics
set samples 1000;set isosamples 200,2
if (gpversion>4.3) plot '++' using 1:2:1 with image
set bmargin screen 0.00; set tmargin screen 0.07
set palette file tablefile u 2:(fw($3,$4,$5)):(fw($3,$4,$5)):(fw($3,$4,$5))
set xrange [0:1];set cbrange [0:1]; unset ytics
set samples 1000;set isosamples 200,2
if (gpversion>4.3) plot '++' using 1:2:1 with image
unset multiplot
set format x "%g"
set tics back
#set lmargin screen 0; set rmargin screen 1
#set bmargin screen 0; set tmargin screen 1
set lmargin; set rmargin; set bmargin; set tmargin
pause mouse key "Press any key to proceed cumulative colordiff graph\n"
##################################
#### Colorpaths plot #############
##################################
unset arrow; unset label
if (gpversion<4.5)  set term x11 2 size 640,480 title 'Cumulative color differences'
if (gpversion>=4.5) set term x11 2 size 640,480 title 'Cumulative color differences' background '#cccccc'
set xrange [0:1]; set xtics 0.1; set mxtics 5
set yrange [0:2]; set ytics 0.2; set mxtics 4
set grid xtics ytics mxtics mytics ls 11, ls 12
set autoscale y
set key left
#plot cpathfile u 2:3 t 'Lab76' w l ls 21,\
     cpathfile u 2:4 t 'Lab99d' w l ls 22,\
     cpathfile u 2:5 t 'Lab99o' w l ls 23,\
     cpathfile u 2:6 t 'IPT100' w l ls 24,\
     cpathfile u 2:7 t 'IPTEUC' w l ls 25,\
     cpathfile u 2:8 t 'DE2000' w l ls 26
#reduced sample
plot cpathfile u 2:4 t 'Lab99d' w l ls 22,\
     cpathfile u 2:7 t 'IPTEUC' w l ls 25,\
     cpathfile u 2:8 t 'DE2000' w l ls 26,\
     cpathfile u 2:9 t 'DE02' w l ls 27
pause mouse key "Press any key to proceed colordiff graph\n"
##################################
#### Colordiffs plot #############
##################################
unset arrow; unset label
if (gpversion<4.5)  set term x11 3 size 640,480 title 'Scaled color differences'
if (gpversion>=4.5) set term x11 3 size 640,480 title 'Scaled color differences' background '#cccccc'
set xrange [0:1]; set xtics 0.1; set mxtics 5
set yrange [0:2]; set ytics 0.2; set mxtics 4
set grid xtics ytics mxtics mytics ls 11, ls 12
#set autoscale y
set key left
#plot cdifffile u 2:3 t 'Lab76' w l ls 21,\
     cdifffile u 2:4 t 'Lab99d' w l ls 22,\
     cdifffile u 2:5 t 'Lab99o' w l ls 23,\
     cdifffile u 2:6 t 'IPT100' w l ls 24,\
     cdifffile u 2:7 t 'IPTEUC' w l ls 25,\
     cdifffile u 2:8 t 'DE2000' w l ls 26
plot cdifffile u 2:4 t 'Lab99d' w l ls 22,\
     cdifffile u 2:7 t 'IPTEUC' w l ls 25,\
     cdifffile u 2:8 t 'DE2000' w l ls 26,\
     cdifffile u 2:9 t 'DE02' w l ls 27
pause mouse key "Press any key to proceed to 3D plots\n"
##################################
#### RGB plot ####################
##################################
#set term postscript # dummy
set size noratio
if (gpversion<4.5)  set term x11 4 size 720,720 title 'RGB cube'
if (gpversion>=4.5) set term x11 4 size 720,720 title 'RGB cube' background '#eeeeee'
set border ls 4
set xyplane 0
set view equal xyz
#set view 0,0,splotzoom
set view 54.73561032,135,splotzoom
dx=0.0;dy=0.0;dz=0.0
set xlabel 'red'; set ylabel 'green'; set zlabel 'blue'
set xrange [-dx:1.+dx];set yrange [-dy:1.+dy];set zrange [-dz:1.+dz]
set xtics 0.1 in; set ytics 0.1; set ztics 0.1
set mxtics 5; set mytics 5; set mztics 5
#unset mxtics; unset mytics; unset mztics
set grid xtics ytics mxtics mytics ls 11, ls 12
unset key
if (gpversion<4.5) \
splot tablefile using 2:2:2 w l ls 5,\
      tablefile using 3:4:5 w l ls 4
if (gpversion>=4.5) \
splot tablefile using (fw($3,$4,$5)):(fw($3,$4,$5)):(fw($3,$4,$5)):(fggg($3,$4,$5)) w l ls 6,\
      tablefile using ($3/maxlevel):($4/maxlevel):($5/maxlevel):(frgb($3,$4,$5)) w l ls 6
#pause -1
pause mouse key "Press any key to proceed to next graph\n"
##################################
#### XYZ plot ####################
##################################
set size noratio
if (gpversion<4.5)  set term x11 5 size 720,720 title 'XYZ cube'
if (gpversion>=4.5) set term x11 5 size 720,720 title 'XYZ cube' background strgbackground
#xyymode=1
#if (xyymode>=1) fx(x,y,z)=x/(x+y+z); fy(x,y,z)=y/(x+y+z); fz(x,y,z)=y
set border ls 4
set xyplane 0
set view equal xyz
set view 0,0,splotzoom
dx=0.0;dy=0.0;dz=0.0
set xlabel 'X'; set ylabel 'Y'; set zlabel 'Z'
set xrange [-dx:1.+dx];set yrange [-dy:1.+dy];set zrange [-dz:1.+dz]
set xtics 0.1 in; set ytics 0.1; set ztics 0.1
#unset mxtics; unset mytics; unset mztics
set autoscale
unset key
if (gpversion<4.5) \
splot tablefile using ($7*XWP):7:($7*ZWP) w l ls 5,\
      tablefile using 6:7:8 w l ls 4
if (gpversion>=4.5) \
splot tablefile using ($7*XWP):7:($7*ZWP):(fggg($3,$4,$5)) w l ls 6,\
      tablefile using 6:7:8:(frgb($3,$4,$5)) w l ls 6
#pause -1
pause mouse key "Press any key to proceed to next graph\n"
##################################
#### xyY plot ####################
##################################
#set term postscript # dummy
set size noratio
if (gpversion<4.5)  set term x11 6 size 720,720 title 'xyY pot'
if (gpversion>=4.5) set term x11 6 size 720,720 title 'xyY pot' background '#cccccc'
set border ls 4
set xyplane 0
set view equal xyz
set view 0,0,splotzoom
dx=0.0;dy=0.0;dz=0.0
set xlabel 'x'; set ylabel 'y'; set zlabel 'Y'
set xrange [0.:0.74];set yrange [0.:0.84];set zrange [0.:*]
set xtics 0.1 in; set ytics 0.1; set ztics 0.1
#unset mxtics; unset mytics; unset mztics
#set autoscale z
set arrow 1 from xred,yred     to xgreen,ygreen nohead front ls 10
set arrow 2 from xgreen,ygreen to xblue,yblue   nohead front ls 10
set arrow 3 from xblue,yblue   to xred,yred     nohead front ls 10
Narr=3; Nlbl=3; ltarr=10
load planckticsfile
load cieticsfile
#### Approximate positions of standard illuminants D* and E
Nlbl=Nlbl+1; set label Nlbl 'D50' at 0.337,0.369
Nlbl=Nlbl+1; set label Nlbl 'o' at 0.34567,0.35850 offset character -0.3,0.
Nlbl=Nlbl+1; set label Nlbl 'D55' at 0.325,0.359
Nlbl=Nlbl+1; set label Nlbl 'o' at 0.33242,0.34743 offset character -0.3,0.
Nlbl=Nlbl+1; set label Nlbl 'D65' at 0.305,0.342
Nlbl=Nlbl+1; set label Nlbl 'o' at 0.31271,0.32902 offset character -0.3,0.
Nlbl=Nlbl+1; set label Nlbl 'D75' at 0.289,0.328
Nlbl=Nlbl+1; set label Nlbl 'o' at 0.29902,0.31485 offset character -0.3,0.
Nlbl=Nlbl+1; set label Nlbl 'E' at 0.335,0.322
Nlbl=Nlbl+1; set label Nlbl 'o' at 0.3333,0.3333 offset character -0.3,0.
unset key
xscal(x,y,z)=x+y+z<=0.?xwhite:x/(x+y+z)
yscal(x,y,z)=x+y+z<=0.?ywhite:y/(x+y+z)
caxy=9; cbxy=10
if (gpversion<4.5) \
splot ciebordername u 1:2:(0.) w l ls 4,\
      planckfile u 3:4:(0.) w l ls 10,\
      antiplanckfile u 3:4:(0.) w l ls 14,\
      tablefile using (xwhite):(ywhite):7 w l ls 5,\
      tablefile using (column(caxy)):(column(cbxy)):7 w l ls 4
if (gpversion>=4.5) \
splot ciebordername u 1:2:(0.) w l ls 4,\
      planckfile u 3:4:(0.) w l ls 10,\
      antiplanckfile u 3:4:(0.) w l ls 14,\
      tablefile using (xwhite):(ywhite):7:(fggg($3,$4,$5)) w l ls 6,\
      tablefile using (column(caxy)):(column(cbxy)):7:(frgb($3,$4,$5)) w l ls 6

#(xwhite):(ywhite)
#pause -1
pause mouse key "Press any key to proceed to next graph\n"
##################################
#### Lab plot ####################
##################################
unset arrow; unset label
if (gpversion<4.5)  set term x11 7 size 720,720 title 'Lab pot'
if (gpversion>=4.5) set term x11 7 size 720,720 title 'Lab pot' background '#cccccc'
if (labmode<=1) cl=11; ca=12; cb=13; set title 'CIELAB'
if (labmode==2) cl=14; ca=15; cb=16; set title 'DIN99d'
if (labmode==3) cl=17; ca=18; cb=19; set title 'DIN99o'
if (labmode==4) cl=20; ca=21; cb=22; set title 'IPT scale 100'
if (labmode==5) cl=23; ca=24; cb=25; set title 'IPT-EUC'
if (labmode==6) cl=26; ca=27; cb=28; set title 'CIECAM02 Jab'
if (labmode==7) cl=29; ca=30; cb=31; set title 'EUCCAM02 Jab'
if (labmode==8) cl=32; ca=33; cb=34; set title 'CIECAM02 Jab_Hq'
if (labmode==9) cl=29; ca=35; cb=36; set title 'EUCCAM02 Jab_Hq'#re-using J-EUC
set view equal xy
set view 0,0,splotzoom
set xlabel 'a'; set ylabel 'b'; set zlabel 'L'
dx=0.0;dy=0.0;dz=0.0
set xrange [-100.-dx:100.+dx];set yrange [-100.-dy:100.+dy];set zrange [-dz:100.+dz]
if (labmode==7||labmode==9) set zrange[-dz:130.]
set xtics 20.; set ytics 20.; set ztics 10.
set mxtics 4; set mytics 4; set mztics 2
#unset mxtics; unset mytics; unset mztics
set autoscale x; set autoscale y
unset key

if (gpversion<4.5) \
splot tablefile using (0.):(0.):(column(cl)) w l ls 5,\
      tablefile using (column(ca)):(column(cb)):(column(cl)) w l ls 4
if (gpversion>=4.5) \
splot tablefile using (0.):(0.):(column(cl)):(fggg($3,$4,$5)) w l ls 6,\
      tablefile using (column(ca)):(column(cb)):(column(cl)):(frgb($3,$4,$5)) w l ls 6

#print 'strgfile = "',strgfile,'"'
