#### Helper functions for proper multiplotting
#### Define before call:
## Plotting canvas (i.e. without tics, labels, titles etc.)
# Examples
# xpcanv= 12. #plotting canvas size x
# ypcanv= 12. #plotting canvas size y
# ncols =1   # number of columns
# nrows =3   # number of rows
# qratio=0.5 # desired aspect ratio y/x
## Overall margins (example):
#lmgadd=0.07; rmgadd=0.03
#tmgadd=0.01; bmgadd=0.09
#
## Usage:
#  1. Define above variables (either in or before calling this script)
#  2. Call this script
#  3. set terminal ...
#  4. set multiplot
#  5. do the plots; call mplayout_frame.gp before each plot!
## Setting the margins via "set *margin screen *mg", * = l,r,t,b
# lmg=flmg(c); rmg=frmg(c); bmg=fbmg(r); rmt=ftmg(r)
####
# Easy way to autoscale for font labels
# ptx=0.03514598#TeX point in cm
# fsize=20 # Font size in points
# xfsize=1.43*ptx*fsize; yfsize=1.52*ptx*fsize # Numbers may have to be optimized manually
# lmgadd=xfsize/xpcanv; rmgadd=0.001; tmgadd=0.004; bmgadd=yfsize/((xpcanv/ncols)*qratio*nrows)#autoscale
########################################################################
## Check canvas dimensions from xpcanv and qratio
if (xpcanv<=0. && ypcanv<=0.) \
   print 'WARNING: Bad canvas dimensions - using defauls';\
   qratio=1.;xpcanv=ncols*5.;ypcanv=nrows*5.;\
   print 'xpcanv, ypcanv = ',xpcanv, ypcanv
qdummy=(1.*ypcanv/nrows)/(1.*xpcanv/ncols)# multiply with 1. to convert integers to floats
qlayout=real(nrows)/ncols
print 'nrows,ncols,qlayout = ',nrows,ncols,qlayout
if (qratio<=0.) \
   qratio = qdummy;\
   print 'Calculating qratio from canvas and partition';\
else if (xpcanv<=0.) \
   xpcanv=ypcanv/qlayout/qratio;\
   print 'Scaling xpcanv to fit';\
else if (ypcanv<=0.) \
   ypcanv=xpcanv*qlayout*qratio;\
   print 'Scaling ypcanv to fit';\
else if (qratio>qdummy) \
   xpcanv=xpcanv*qdummy/qratio;\
   print 'Rescaling xpcanv to fit';\
else if (qratio<qdummy) \
   ypcanv=ypcanv*qratio/qdummy;\
   print 'Rescaling ypcanv to fit'
## Overall borders from margins
xcunmod=1.+lmgadd+rmgadd
ycunmod=1.+tmgadd+bmgadd
lmgtot=lmgadd/xcunmod; rmgtot=rmgadd/xcunmod
bmgtot=bmgadd/ycunmod; tmgtot=tmgadd/ycunmod
print 'xcunmod,ycunmod = ',xcunmod,ycunmod
print 'lmgtot,rmgtot   = ',lmgtot,rmgtot
print 'bmgtot,tmgtot   = ',bmgtot,tmgtot
lborder=lmgtot;    rborder=1.-rmgtot
tborder=1.-tmgtot; bborder=bmgtot
## Calculate frame dimensions and recommended canvas dimensions
# graph dims in canvas units:
wgraph=rborder-lborder; hgraph=tborder-bborder
# graph pseudo aspect ratio (i.e. in canvas units):
qgraph=hgraph/wgraph
# scaled plot frame width and height in canvas units
wframe=wgraph/ncols; hframe=hgraph/nrows
# scaled plot aspect ratio for frame for square unit canvas
# qframe = hgraph/nrows/wgraph*ncols = hgraph/wgraph * ncols/nrows
# = qgraph/qnumber
qframe=hframe/wframe
# plotting canvas aspect ratio; not yet used
qgreal=(qratio*nrows)/ncols
# Canvas aspect ratio qcreal = qratio/qframe
# = qratio/qgraph*nrows/ncols = qgreal/qgraph
qcreal=qratio/qframe
## Full canvas dimensions from plotting canvas dimensions
xcanvas=xpcanv/wgraph
ycanvas=ypcanv/hgraph
print 'qratio = ',qratio
print 'wgraph = ',wgraph
print 'hgraph = ',hgraph
print 'wframe = ',wframe
print 'hframe = ',hframe
print 'qgraph = ',qgraph
print 'qframe = ',qframe
print 'qgreal = ',qgreal
print 'Recommended canvas aspect ratio:'
print 'qcreal = ',qcreal
print 'Recommended canvas dimensions:'
print 'canvas= ',xcanvas,' x ',ycanvas
#### Subframe border functions
## count cols from left
#flmg(c)=lmgtot+(c-1)*wframe
#frmg(c)=lmgtot+c*wframe
flmg(c)=lmgtot+((c-1)+lmgsub)*wframe
frmg(c)=lmgtot+(c-rmgsub)*wframe
## count rows from top
#fbmg(r)=bmgtot+(nrows-r)*hframe
#ftmg(r)=bmgtot+(nrows-r+1)*hframe
fbmg(r)=bmgtot+((nrows-r)+bmgsub)*hframe
ftmg(r)=bmgtot+((nrows-r+1)-tmgsub)*hframe
## Label placement (adjust for x2loff and y1loff scaling cfor best results)
x1loff=0.5*(ncols-1); y2loff=0.5*(nrows-1)# xlabel and ylabel along border
# Apply a slight right-shift to the ylabel to decrease the huge
# gap that gnuplot sets per default. Set y1loff=0 for gnuplot default.
# Note: ylabel offset was formerly defined in character units;
# but better scale to graph units since splot cannot deal with
# mixed coord units.
#x2loff=0.00; y1loff=0.00# xlabel and ylabel offset towards graph
if (!exists("x2loff")) x2loff=0.
if (!exists("y1loff")) y1loff=0.
#### Order of subframe columns and rows
## columns fastest (i.e. reading order), rows from top
f1row(i)=1+int((i-1)/ncols); f1col(i)=i-ncols*(f1row(i)-1)
## rows fastest and from top
f2col(i)=1+int((i-1)/nrows); f2row(i)=i-nrows*(f2col(i)-1)
## Source arrays for alphabetical labels
abclower="abcdefghijklmnopqrstuvwxyz"
abcupper="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
if (flgparenth==1) lparenth="("; rparenth=")";\
   else if (flgparenth==2) lparenth="["; rparenth="]";\
   else if (flgparenth==3) lparenth="<"; rparenth=">";\
   else if (flgparenth<0)  lparenth=""; rparenth=""
## reset auto order flag and frame index
flgrcorder=0
iframe=0
