#### Helper script for mplayout_base.gp
#### To be placed before each plot
##
## Define before each call:
## x1loff, x2loff - x label offsets (global)
## y1loff, y2loff - y label offsets (global)
##    		    Example:
##    		    x1loff=0.5*(ncols-1); x2loff=0.
##    		    y1loff=1.0; y2loff=0.5*(nrows-1)
##    		    (this is the default definition in mplayout_base.gp)
## c,r            - current column, row number (before each plot)
##                  c=1...ncols (left to right)
##                  r=1...nrows (top to bottom)
## Define before multiplot:
## flgxlabel      - >0: use xlabel
## flgylabel      - >0: use ylabel
## xlabeltext     - text string for xlabel
## ylabeltext     - text string for ylabel
################################################################################
## Automatic rows/colums order
iframe=iframe+1
if (flgrcorder==1) r=f1row(iframe);c=f1col(iframe)
if (flgrcorder==2) r=f2row(iframe);c=f2col(iframe)
## Define margins
lmg=flmg(c); rmg=frmg(c); bmg=fbmg(r); tmg=ftmg(r)
## Print margins
print 'lmg, rmg, tmg, bmg = ',lmg, rmg, tmg, bmg
## set margins in gnuplot using the absolute marginssyntax
set lmargin screen lmg
set rmargin screen rmg
set bmargin screen bmg
set tmargin screen tmg
## set/unset xylabels
unset xlabel; unset ylabel; set format x ''; set format y ''
if (r==nrows&&c==1&&flgxlabel>0) set xlabel xlabeltext offset graph x1loff,0.5#, x2loff
if (r==nrows&&c==1&&flgylabel>0) set ylabel ylabeltext offset graph y1loff, y2loff
if (r==nrows&&flgxticlabels) set format x '%g'
if (c==1&&flgyticlabels) set format y '%g'
if (r==nrows) print 'using xtics labels at r,c =',r,c
if (flgabc>0) load 'mplayout_labels.gp'
