reset
set term push

#### Generate test data file testframes*.tmp
set isosamples 100,100 #
w=2.; dw=0.5; ndw=5
set xrange [-w:w]; set yrange [-w:w]
set xtics dw; set mxtics ndw; set ytics dw; set mytics ndw
set cbrange [0:0.4]
set cbtics 0.05; set mcbtics 5
f(x,y)=1./sqrt(2.*pi)*exp(-0.5*(x*x+y*y))
set table 'testframes1.tmp'
splot f(x,y)
set table 'testframes2.tmp'
splot f(x**2,y**2)
set table 'testframes3.tmp'
splot f(sqrt(abs(x)),sqrt(abs(y)))
set table 'testframes4.tmp'
splot f(abs(x)**0.25,abs(y)**0.25)
set table 'testframes5.tmp'
splot f(x,sqrt(abs(y)))
set table 'testframes6.tmp'
splot f(x,1./sqrt(y*y+0.01))
unset table

######## MPLAYOUT PARAMS ###############################################
#### Basic layout settings (used by mplayout_base.gp)
##  Graph shape
xpcanv= 12. #plotting canvas size x (set to 0 to scale from y and q)
ypcanv= 0. #plotting canvas size y (set to 0 to scale from x and q)
## Graph partition
ncols =2   # number of columns
nrows =3   # number of rows
## Frame shape
qratio=1. # desired aspect ratio y/x
## Overall margins
lmgadd=0.15; rmgadd=0.25; tmgadd=0.01; bmgadd=0.10
## Subframe margins
lmgsub=0.; rmgsub=0.; tmgsub=0.; bmgsub=0.# No submargins as default
#lmgsub=0.05; rmgsub=0.05; tmgsub=0.05; bmgsub=0.05#under construction
## title label params
flgabc=2     # 1: numbers, 2: lower-case, 3: upper-case, 0: off
flgparenth=0 # 0: user-def, 1: (*), 2: [*], 3: <*>, else: off
lparenth="";rparenth=")"
rgbabc="#ffff00" # label color
xnlbl=0.05; ynlbl=0.95 # label position in subframe

#### Apply to mplayout now
load 'mplayout_base.gp'

#### Subframe settings (used by mplayout_frame.gp)
flgrcorder=1
#xlabeltext="x"; ylabeltext="y"
xlabeltext="{/Symbol f}"; ylabeltext="{/Symbol q}"
flgxlabel=1; flgxticlabels=1
flgylabel=1; flgyticlabels=1
########################################################################

#### Terminal definitions
set term postscript eps enhanced color size xcanvas cm, ycanvas cm font "Helvetica,24"
#set term postscript eps enhanced color size xcanvas cm, ycanvas cm font "Hershey/Simplex Script,24"
#### Labels and formats
set format x ""; set format y ""
unset xlabel; unset ylabel; unset cblabel
#set size ratio -1
set border front lc rgb '#000000'; set tics in front
unset colorbox
#### Optional use of the Color Manager or Cube Helix
#load 'color.inp.gp'
#load 'cubehelix.gp'
#### Set output file
set output 'testframes.eps'
######## PLOTTING ########
#### Restore range settings (in case of being disrupted by test scripts above)
set xrange [-w:w]; set yrange [-w:w]
set xtics dw; set mxtics ndw; set ytics dw; set mytics ndw
set multiplot
## Plot 1
load 'mplayout_frame.gp'
plot 'testframes1.tmp' using 1:2:3 notitle with image#;unset object 1
## Plot 2
load 'mplayout_frame.gp'
plot 'testframes2.tmp' using 1:2:3 notitle with image
## Plot 3
load 'mplayout_frame.gp'
plot 'testframes3.tmp' using 1:2:3 notitle with image
## Plot 4
load 'mplayout_frame.gp'
plot 'testframes4.tmp' using 1:2:3 notitle with image
## Plot 5
load 'mplayout_frame.gp'
plot 'testframes5.tmp' using 1:2:3 notitle with image
## Plot 6
#c=2;r=3
load 'mplayout_frame.gp'
#set cbtics in
set cblabel "Colorlabel" offset 0.0,0.0# font "Helvetica,18"# tc rgb '#000000'
#set colorbox horiz user origin lmgtot,bmgtot+1.08*hgraph size wgraph,0.04*hgraph front
#set colorbox horiz user origin lmgtot,(1.-1.08*hgraph) size wgraph,0.04*hgraph front
#set colorbox horiz user origin lmgtot,bmgtot-0.08 size wgraph,0.04*hgraph front
set colorbox vert user origin 1.-rmgtot+0.02,bmgtot size 0.04,hgraph front
#set format x ""; unset xlabel
#set format y ""; unset ylabel
#show xlabel; show ylabel
plot 'testframes6.tmp' using 1:2:3 notitle with image
#show cblabel
unset multiplot
set term pop
