## Altitude-Azimuth Plot
#pause mouse key "Press any key to proceed to other plot(s) (will terminate zooming)\n"
print 'Azimuthal sky plot'
set term strgterm 2  title "Solar System 2D Azimuth-Altitude Chart" size xpix2,ypix2
set size 1,1
#set size ratio -1
set origin 0,0
unset for [i=1:10] label i
unset arrow
pscal=3.; ppwr=0.2
load 'psizes.gp'
r2a=r2d
set angles degrees# ; r2a=1.
load 'anglefuncs_deg.gp'
gcth(x,y,z)=fcth(fxgeo(x),fygeo(y),fzgeo(z))
gcph(x,y,z)=fcph(fxgeo(x),fygeo(y),fzgeo(z))
set label 5 sprintf("Local = %04d-%02d-%02d %02d:%02d:%02d\n  UTC = %04d-%02d-%02d %02d:%02d:%02d\n Lat. =%3d%c %02d%c %02d%c\n Lon. =%3d%c %02d%c %02d%c",\
    loc_yr,loc_mo,loc_dd,loc_hh,loc_mm,loc_ss,utc_yr,utc_mo,utc_dd,utc_hh,utc_mm,utc_ss,latdeg,176,latmin,39,latsec,34,londeg,176,lonmin,39,lonsec,34)\
    at screen 0.02, screen 0.95 tc rgb rgbtclb
## Sun direction
thnpole=fcth(e3x,e3y,e3z)
phnpole=fcph(e3x,e3y,e3z)
set print 'npole.dat'
print phnpole,thnpole
set print
#load 'window4sol3d.gp'
##
set xlabel "azimuth / deg" tc rgb rgbtclb; set ylabel "altitude / deg" tc rgb rgbtclb
set xrange [0:360];set yrange [-90:90]
set border ls 17
set xtics 30;set ytics 30;set mxtics 3; set mytics 3
set grid xtics ytics mxtics mytics ls 10, ls 12
set xzeroaxis lt -1
plot pointfile using (gcph(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))):(gcth(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))) t 'Mercury'    w p pt 7 ps psmerc  lc rgb rgbmerc ,\
     pointfile using (gcph(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))):(gcth(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))) t 'Venus'      w p pt 7 ps psvenus lc rgb rgbvenus,\
     pointfile using (gcph(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))):(gcth(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))) t 'Earth'      w p pt 7 ps psearth lc rgb rgbearth,\
     pointfile using (gcph(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))):(gcth(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))) t 'Moon'       w p pt 6 ps psmoon2 lc rgb rgbmoon2,\
     pointfile using (gcph(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))):(gcth(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))) t 'Eros'       w p pt 7 ps pseros  lc rgb rgberos ,\
     pointfile using (gcph(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))):(gcth(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))) t 'Mars'       w p pt 7 ps psmars  lc rgb rgbmars ,\
     pointfile using (gcph(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))):(gcth(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))) t 'Vesta'      w p pt 7 ps psvesta lc rgb rgbvesta,\
     pointfile using (gcph(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))):(gcth(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))) t 'Juno'       w p pt 7 ps psjuno  lc rgb rgbjuno ,\
     pointfile using (gcph(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))):(gcth(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))) t 'Ceres'      w p pt 7 ps psceres lc rgb rgbceres,\
     pointfile using (gcph(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))):(gcth(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))) t 'Pallas'     w p pt 7 ps pspall  lc rgb rgbpall ,\
     pointfile using (gcph(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))):(gcth(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))) t 'Interamnia' w p pt 7 ps psinta  lc rgb rgbinta ,\
     pointfile using (gcph(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))):(gcth(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))) t 'Hygiea'     w p pt 7 ps pshyg   lc rgb rgbhyg  ,\
     pointfile using (gcph(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))):(gcth(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))) t 'Jupiter'    w p pt 7 ps psjup   lc rgb rgbjup  ,\
     pointfile using (gcph(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))):(gcth(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))) t 'Saturn'     w p pt 7 ps pssat   lc rgb rgbsat  ,\
     pointfile using (gcph(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))):(gcth(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))) t 'Chiron'     w p pt 7 ps pschir  lc rgb rgbchir ,\
     pointfile using (gcph(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))):(gcth(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))) t 'Uranus'     w p pt 7 ps psur    lc rgb rgbur   ,\
     pointfile using (gcph(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))):(gcth(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))) t 'Neptune'    w p pt 7 ps psnep   lc rgb rgbnep  ,\
     pointfile using (gcph(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))):(gcth(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))) t 'Orcus'      w p pt 7 ps psorcus lc rgb rgborcus,\
     pointfile using (gcph(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))):(gcth(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))) t 'Pluto'      w p pt 7 ps pspluto lc rgb rgbpluto,\
     pointfile using (gcph(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))):(gcth(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))) t 'Haumea'     w p pt 7 ps pshaume lc rgb rgbhaume,\
     pointfile using (gcph(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))):(gcth(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))) t 'Quaoar'     w p pt 7 ps psqua   lc rgb rgbqua,\
     pointfile using (gcph(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))):(gcth(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))) t 'Makemake'   w p pt 7 ps psmakem lc rgb rgbmakem,\
     pointfile using (gcph(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))):(gcth(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))) t 'Eris'       w p pt 7 ps pseris  lc rgb rgberis ,\
     pointfile using (gcph(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))):(gcth(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))) t 'Sedna'      w p pt 7 ps pssedna lc rgb rgbsedna,\
     pointfile using (gcph(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))):(gcth(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))) t 'Sun'        w p pt 3 ps pssun   lc rgb rgbsun  ,\
     'npole.dat' using 1:2 t 'Sky-N' w p pt 2 ps 1.0*pscal lc rgb rgbpole,\
     'winborders.dat' using (fph($1,$2,$3)):(fth($1,$2,$3)) notitle w d ls 15
if(flgstars>=2) replot starfile using (gcph(pc2au*$4,pc2au*$5,pc2au*$6)):(gcth(pc2au*$4,pc2au*$5,pc2au*$6)):(psize($9)):7 notitle w p pt 1 ps variable palette

#### Polar plot
#pause mouse key "Press any key to proceed to other plot(s) (will terminate zooming)"
print 'Polar sky plot'
set term strgterm 3 title "Solar System 2D Sky Chart" size xpix3,ypix3
pscal=5.; ppwr=0.2
load 'psizes.gp'
unset grid
unset xlabel;unset ylabel
set xtics 30;set ytics 30;set mxtics 3; set mytics 3
set angles degrees
set polar
set label 5 sprintf("LT = %04d-%02d-%02d %02d:%02d:%02d\nUTC= %04d-%02d-%02d %02d:%02d:%02d\nLat=%3d%c %02d%c %02d%c\nLon=%3d%c %02d%c %02d%c",\
    loc_yr,loc_mo,loc_dd,loc_hh,loc_mm,loc_ss,utc_yr,utc_mo,utc_dd,utc_hh,utc_mm,utc_ss,latdeg,176,latmin,39,latsec,34,londeg,176,lonmin,39,lonsec,34)\
    at screen 0.01, screen 0.96 tc rgb rgbtclb
set grid xtics mxtics polar 90. ls 10,ls 12
r=91.
fx(x)=r*cos(180./N*x);fy(x)=r*sin(180./N*x)
Narr=1
N=18# 10 degrees
#N=36# 5 degrees
#N=8 # 22.5 degrees
if(flgsurf>=2) set for [i=1:N] arrow i+Narr from -fx(i),-fy(i),0 to fx(i),fy(i),0 ls lspolar2 nohead back
if(flgsurf>=2) Narr=Narr+N
Narr1=Narr
#N=9 # 20 degrees
N=6 # 30 degrees
#N=4 # 45 degrees
if(flgsurf>=1) set for [i=1:N] arrow i+Narr from -fx(i),-fy(i),0 to fx(i),fy(i),0 ls lspolar1 nohead back;Narr=Narr+N
if(flgsurf>=1) Narr=Narr+N
Narr2=Narr
set xrange [-r:r];set yrange [-r:r]
lr=88
set label 7  'N' at 0,lr  tc rgb rgbtclb
set label 8  'E' at -lr,0 tc rgb rgbtclb
set label 9  'S' at 0,-lr  tc rgb rgbtclb
set label 10 'W' at lr,0  tc rgb rgbtclb

plot pointfile using (90.+gcph(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))):(90.-gcth(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))) t 'Mercury'    w p pt 7 ps psmerc  lc rgb rgbmerc ,\
     pointfile using (90.+gcph(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))):(90.-gcth(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))) t 'Venus'      w p pt 7 ps psvenus lc rgb rgbvenus,\
     pointfile using (90.+gcph(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))):(90.-gcth(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))) t 'Earth'      w p pt 7 ps psearth lc rgb rgbearth,\
     pointfile using (90.+gcph(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))):(90.-gcth(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))) t 'Moon'       w p pt 6 ps psmoon2 lc rgb rgbmoon2,\
     pointfile using (90.+gcph(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))):(90.-gcth(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))) t 'Eros'       w p pt 7 ps pseros  lc rgb rgberos ,\
     pointfile using (90.+gcph(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))):(90.-gcth(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))) t 'Mars'       w p pt 7 ps psmars  lc rgb rgbmars ,\
     pointfile using (90.+gcph(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))):(90.-gcth(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))) t 'Vesta'      w p pt 7 ps psvesta lc rgb rgbvesta,\
     pointfile using (90.+gcph(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))):(90.-gcth(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))) t 'Juno'       w p pt 7 ps psjuno  lc rgb rgbjuno ,\
     pointfile using (90.+gcph(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))):(90.-gcth(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))) t 'Ceres'      w p pt 7 ps psceres lc rgb rgbceres,\
     pointfile using (90.+gcph(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))):(90.-gcth(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))) t 'Pallas'     w p pt 7 ps pspall  lc rgb rgbpall ,\
     pointfile using (90.+gcph(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))):(90.-gcth(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))) t 'Interamnia' w p pt 7 ps psinta  lc rgb rgbinta ,\
     pointfile using (90.+gcph(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))):(90.-gcth(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))) t 'Hygiea'     w p pt 7 ps pshyg   lc rgb rgbhyg  ,\
     pointfile using (90.+gcph(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))):(90.-gcth(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))) t 'Jupiter'    w p pt 7 ps psjup   lc rgb rgbjup  ,\
     pointfile using (90.+gcph(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))):(90.-gcth(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))) t 'Saturn'     w p pt 7 ps pssat   lc rgb rgbsat  ,\
     pointfile using (90.+gcph(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))):(90.-gcth(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))) t 'Chiron'     w p pt 7 ps pschir  lc rgb rgbchir ,\
     pointfile using (90.+gcph(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))):(90.-gcth(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))) t 'Uranus'     w p pt 7 ps psur    lc rgb rgbur   ,\
     pointfile using (90.+gcph(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))):(90.-gcth(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))) t 'Neptune'    w p pt 7 ps psnep   lc rgb rgbnep  ,\
     pointfile using (90.+gcph(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))):(90.-gcth(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))) t 'Orcus'      w p pt 7 ps psorcus lc rgb rgborcus,\
     pointfile using (90.+gcph(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))):(90.-gcth(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))) t 'Pluto'      w p pt 7 ps pspluto lc rgb rgbpluto,\
     pointfile using (90.+gcph(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))):(90.-gcth(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))) t 'Haumea'     w p pt 7 ps pshaume lc rgb rgbhaume,\
     pointfile using (90.+gcph(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))):(90.-gcth(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))) t 'Quaoar'     w p pt 7 ps psqua   lc rgb rgbqua,\
     pointfile using (90.+gcph(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))):(90.-gcth(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))) t 'Makemake'   w p pt 7 ps psmakem lc rgb rgbmakem,\
     pointfile using (90.+gcph(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))):(90.-gcth(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))) t 'Eris'       w p pt 7 ps pseris  lc rgb rgberis ,\
     pointfile using (90.+gcph(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))):(90.-gcth(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))) t 'Sedna'      w p pt 7 ps pssedna lc rgb rgbsedna,\
     pointfile using (90.+gcph(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))):(90.-gcth(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))) t 'Sun'        w p pt 3 ps pssun   lc rgb rgbsun  ,\
     'npole.dat' using (90.+$1):(90.-$2) t 'Sky-N' w p pt 2 ps 1.0*pscal lc rgb rgbpole,\
     'winborders.dat' using (90.+fph($1,$2,$3)):(90.-fth($1,$2,$3)) notitle w l ls 15
if(flgstars>=2) replot starfile using (90.+gcph(pc2au*$4,pc2au*$5,pc2au*$6)):(90.-gcth(pc2au*$4,pc2au*$5,pc2au*$6)):(psize($9)):7 notitle w p pt 1 ps variable palette
