      SUBROUTINE deltat(y,dt)
! Calculate dt in seconds
! delta-T or ΔT (ΔT = TDT - UT)
! Formulae taken from http://eclipse.gsfc.nasa.gov/SEcat5/deltatpoly.html
! Info about delta T: http://eclipse.gsfc.nasa.gov/SEhelp/deltaT.html
! Measured discontinuities:
! -500: -0.023661s
!  500: -0.087119s
! 1600: -0.251115s
! 1700: -0.162128s
! 1800: -0.036124s
! 1860: +0.050180s
! 1900: -0.088400s
! 1920: +0.012380s
! 1941: +0.000882s
! 1961: +0.029619s
! 1986: +0.009883s
! 2005: -0.050071s
! 2050: -0.001000s
! 2150:  0.000000s
      IMPLICIT NONE
      DOUBLE PRECISION y,dt
      DOUBLE PRECISION t,u,v,dt1,dt1650,dt1750,c
      IF (y<-500.d0) THEN
! Before -500
         u = (y-1820.d0)/1.d2
         dt= -20.d0 + 32.d0*u**2
      ELSE IF (y<500.d0) THEN
! -500--500
         u = y/1.d2
!         dt= 10583.6d0 - 1014.41d0*u + 33.78311d0*u**2 - 5.952053d0*u**3
!     &      -0.1798452d0*u**4 + 0.022174192d0*u**5 + 0.0090316521d0*u**6
         dt= 10583.6d0 +u*(-1014.41d0 + u*(33.78311d0+u*(-5.952053d0     &
     &      +u*(-0.1798452d0 + u*(0.022174192d0 + 0.0090316521d0*u)))))
      ELSE IF (y<1600.d0) THEN
!  500--1600
         u = (y-1000.d0)/1.d2
!         dt= 1574.2d0 - 556.01d0*u + 71.23472d0*u**2 + 0.319781d0*u**3
!     &        - 0.8503463d0*u**4-0.005050998d0*u**5+0.0083572073d0*u**6
         dt= 1574.2d0 +u*(-556.01d0 + u*(71.23472d0 + u*(0.319781d0      &
     &      +u*(-0.8503463d0+u*(-0.005050998d0+0.0083572073d0*u)))))
      ELSE IF (y<1700.d0) THEN
! 1600--1700
         t = y-1600.d0
!         dt= 120.d0 - 0.9808d0*t - 0.01532d0*t**2 + t**3 / 7129.d0
         dt= 120.d0 + t*(-0.9808d0 + t*(-0.01532d0 + t/7129.d0))
      ELSE IF (y<1800.d0) THEN
! 1700--1800
         t = y-1700.d0
!         dt= 8.83d0 + 0.1603d0*t - 0.0059285d0*t**2 + 0.00013336d0*t**3
!     &        - t**4 / 1174.d3
         dt= 8.83d0+                                                     &
     &      t*(0.1603d0+t*(-0.0059285d0+t*(0.00013336d0-t/1174.d3)))
      ELSE IF (y<1860.d0) THEN
! 1800--1860
         t = y-1800.d0
!         dt=13.72d0 - 0.332447d0*t + 0.0068612d0*t**2 + 0.0041116d0*t**3
!     &    -0.00037436d0*t**4 + 0.0000121272d0*t**5 - 0.0000001699d0*t**6
!     &   + 0.000000000875d0*t**7
         dt=13.72d0 +t*(-0.332447d0+t*(0.0068612d0 + t*(0.0041116d0      &
     &   + t*(-0.00037436d0 + t*(0.0000121272d0 +t*(-0.0000001699d0      &
     &   + 0.000000000875d0*t))))))
      ELSE IF (y<1900.d0) THEN
! 1860--1900
         t = y-1860.d0
!         dt= 7.62d0 + 0.5737d0*t - 0.251754d0*t**2 + 0.01680668d0*t**3
!     &        -0.0004473624d0*t**4 + t**5 / 233174.d0
         dt= 7.62d0 + t*(0.5737d0 + t*(-0.251754d0 + t*(0.01680668d0     &
     &     +t*(-0.0004473624d0 + t/233174.d0))))
      ELSE IF (y<1920.d0) THEN
! 1900--1920
         t = y-1900.d0
!         dt= -2.79d0 + 1.494119d0*t - 0.0598939d0*t**2 +
!     &        0.0061966d0*t**3 - 0.000197*t**4
         dt= -2.79d0 + t*(1.494119d0 +t*(-0.0598939d0                    &
     &       +t*(0.0061966d0-0.000197*t)))
      ELSE IF (y<1941.d0) THEN
! 1920--1941
         t = y-1920.d0
         dt= 21.20d0 + 0.84493d0*t - 0.076100d0*t**2                     &
     &        + 0.0020936d0*t**3
      ELSE IF (y<1961.d0) THEN
! 1941--1961
         t = y-1950.d0
!         dt= 29.07d0 + 0.407d0*t - t**2/233.d0 + t**3 / 2547.d0
         dt= 29.07d0 + t*(0.407d0 +t*(-1.d0/233.d0 + t/2547.d0))
      ELSE IF (y<1986.d0) THEN
! 1961--1986
         t = y-1975.d0
!         dt= 45.45d0 + 1.067d0*t - t**2/260.d0 - t**3 / 718.d0
         dt= 45.45d0 + t*(1.067d0 - t*(1.d0/260.d0 +t/718.d0))
      ELSE IF (y<2005.d0) THEN
! 1986--2005
         t = y-2000.d0
         dt= 63.86d0 + 0.3345d0*t - 0.060374d0*t**2 +                    &
     &      0.0017275d0*t**3 + 0.000651814d0*t**4 + 0.00002373599d0*t**5
      ELSE IF (y<2050.d0) THEN
! 2005--2050
         t = y-2000.d0
!         dt= 62.92d0 + 0.32217d0*t + 0.005589d0*t**2
         dt= 62.92d0 + t*(0.32217d0 + 0.005589d0*t)
      ELSE IF (y<2150.d0) THEN
! 2050--2150
         dt= -20.d0 + 32.d0*((y-1820d0)/1.d2)**2 - 0.5628d0*(2150.d0-y)
      ELSE
! after 2150
         u = (y-1820.d0)/1.d2
         dt= -20.d0 + 32.d0*u**2
      ENDIF
! Own fit to match historical data 1657-1986
! http://maia.usno.navy.mil/ser7/historic_deltat.data
      IF (y>1650.d0.AND.y<1750.d0) THEN
         u = (y-1650)/1.d2
         v = 0.45d0
         dt1650 = 50.194016d0
         dt1750 = 13.370070d0
         dt1= dt1750*u + dt1650*(1.d0-u)
         dt = dt1*v + dt*(1.d0-v)
      ENDIF
! correction for use in the Espenak-Meeus eclipse canon
      c = -0.000012932d0 * (y-1955.d0)**2
      RETURN
      END

      SUBROUTINE yeardec(JD,y)
      IMPLICIT NONE
      DOUBLE PRECISION JD,y
      y=2000.d0+(JD-2451545.D0-15.2184d0)/365.2425d0!term 15.2 days to mimic half-month offset
      RETURN
      END
