      SUBROUTINE n2char(n,dmini,digs,nchar)
!---- INPUT:
!     n     : integer
!     dmini : minimum number of digits (leading zeroes/spaces if digs<dmin)
!             >0 - write leading zeroes
!             <0 - write spaces instead of leading zeroes
!              0 - not allowed
!---- OUTPUT:
!     digs  : number of digits
!     nchar : the output string
      IMPLICIT NONE
      INTEGER i,n,dmin,dmini,digs,nleft,nd,nc,nsum,nnw
      CHARACTER*10 nchar
      LOGICAL write0,lead0
      dmin = abs(dmini)
      IF (dmin.gt.10) THEN
         WRITE(*,*) 'N2CHAR warning: Not more than 10 digits!'
         dmin=10
      ELSE IF (dmin .le. 0) THEN
         WRITE(*,*) 'N2CHAR warning: |dmin| must be positive!'
         dmin=1
      ENDIF
      write0 = dmini .gt. 0
      digs = int(log10(dble(max(n,1))))+1
      nleft = max(digs,dmin)-1
      nsum = 0
      lead0 = .true.
      nchar = char(0)//char(0)//char(0)//char(0)//char(0)//char(0)       &
     &//char(0)//char(0)//char(0)//char(0)
      DO 12 i=nleft,0,-1
         nd = (n-nsum)/10**i
         nsum = nsum + 10**i*nd
         nnw = nleft-i+1
         IF (lead0 .AND. nd.NE.0) lead0 = .false.
         IF (lead0 .AND. .NOT.write0 .AND. nd.EQ.0 .AND. i.gt.0) THEN
            nc = 32
         ELSE
            nc = nd+48
         ENDIF
         nchar(nnw:nnw) = char(nc)
 12   ENDDO
!      WRITE(*,*) 'n = ',n,'; digs = ',digs,'; nleft = ',nleft
!      WRITE(*,*) (nd(nleft-j),j=0,nleft),' nchar = ',nchar,'.'
!      WRITE(*,*) nchar(1:9)
!      stop
      RETURN
      END
