      SUBROUTINE polint(n,xa,ya,ca)
!---- Gives Newton polynomial interpolation coefficients
!     To get the interpolated value for given x do the following:
!
!         y=0.d0
!         DO 100 i=n,1,-1
!            y=y*(x-xa(i))+ca(i)
!         ENDDO
!-----------------------------------------------------------------------
      IMPLICIT NONE
      INTEGER i,j,n
      INTEGER nmax
      PARAMETER (nmax=10)
      DOUBLE PRECISION xa(0:nmax),ya(0:nmax),ca(0:nmax)
      DO 1 i=0,n
         ca(i)=ya(i)
 1    CONTINUE
      DO 3 i=0,n
         DO 2 j=n,i+1,-1
            ca(j)=(ca(j)-ca(j-1))/(xa(j)-xa(j-i-1))
 2       CONTINUE
 3    CONTINUE
      RETURN
      END
      
      DOUBLE PRECISION FUNCTION fpolint(n,xa,ca,x)
      IMPLICIT NONE
      INTEGER n,i
      INTEGER nmax
      PARAMETER (nmax=10)
      DOUBLE PRECISION xa(0:nmax),ca(0:nmax),x,y
      y=0.d0
      DO 100 i=n,0,-1
         y=y*(x-xa(i))+ca(i)
 100  ENDDO
      fpolint=y
      RETURN
      END
