      PROGRAM sidate
      IMPLICIT NONE
      INTEGER npmax
      PARAMETER (npmax=20)
c     diagnostics
      INTEGER ii,nxi,np2,jtest
      DOUBLE PRECISION dxi,yt,ffpol,fpolint,jdtest(0:npmax)
      DOUBLE PRECISION cat(0:npmax)
c     /diagnostics
      INTEGER flgtsys,flgintp,flgdt,values(8),flgseason
      INTEGER np,ip0,ipn,ipt,npt
      DOUBLE PRECISION pi,d2r,ytr,x,y,z,r,theta,phi
      PARAMETER (pi=3.1415926535897932385D0,
     &          d2r=1.7453292519943295769D-2)
      DOUBLE PRECISION xa(0:npmax),ya(0:npmax),ca(0:npmax),ftau
      INTEGER i,j,ip,ni,nt,ntx,ntmax,nb,ibo,ibt,ibr,nbmax,nlines
      PARAMETER (ntmax=1000000,nbmax=100)
      INTEGER yr,mo,dd,hh,mm,ss,yrloc,moloc,ddloc,hhloc,mmloc,ssloc
      INTEGER yrtdt,motdt,ddtdt,hhtdt,mmtdt,sstdt
      INTEGER yrutc,moutc,ddutc,hhutc,mmutc,ssutc
      INTEGER hhoff,mmoff,ssoff,dow
      CHARACTER*3 cdow
      INTEGER digsi,digmin,dswi,digsobj,digsomi
      DOUBLE PRECISION utc,tdt,thoff,loctime
      DOUBLE PRECISION pn(3,nbmax),vn(3,nbmax)
      DOUBLE PRECISION pna(0:npmax,3,nbmax),vna(0:npmax,3,nbmax)
      DOUBLE PRECISION JD0,JD1!for season calculation
      DOUBLE PRECISION JDref,JDloc,JDutc,JDtdt,JD,JDt,oJD,JE,ymmdd,ydum
      DOUBLE PRECISION dref,dmin,odref,dummy,JTR,season,phis,tau,dJD!,s2phi
      DOUBLE PRECISION sna(0:npmax),JEa(0:npmax),JDa(0:npmax)
      DOUBLE PRECISION enplanet(3),refplane(3),sdelay,omx0,axtilt
      DOUBLE PRECISION phi_prec,tprecess,Jepoch0,JDini,JDfin,JDstep
      DOUBLE PRECISION delt,ydec
!      s2phi=0.523598775598298873D-1
      CHARACTER*24 outxyz,tabrv,ch24
      CHARACTER*10 nchar
      CHARACTER*2 ch2
      CHARACTER*6 ch6,chobj(3,nbmax)
!      CHARACTER*8 ch8
      LOGICAL useintp
      digsi=8
      digmin=4
      dswi=1
      digsobj=2
      digsomi=2
      refplane=(/0.d0,0.d0,0.d0/)
      enplanet=(/0.d0,23.44d0,180.d0/)
      OPEN(10,FILE='sidate.inp')
      READ(10,*) yrloc,moloc,ddloc,flgtsys
      READ(10,*) hhloc,mmloc,ssloc,flgdt
      READ(10,*) hhoff,mmoff,ssoff
c      READ(10,*) axtilt,tyrprec,Jepoch0
c      READ(10,*) refplane(1),refplane(2),refplane(3)
      READ(10,*) flgseason
      READ(10,*) flgintp
      CLOSE(10)
      useintp=flgintp.ge.1
      np=max(min(flgintp,npmax),1)
      np2=np/2
      IF (flgtsys.ge.1) THEN
c     Automatic date and time
c     This is Fortran 95 standard. If you are using a pure F77 compiler,
c     comment this section out.
         CALL Date_and_Time(values=values) !This is Fortran 95 standard
         WRITE(*,*) 'Using system date and local-UTC offset.'
         yrloc=values(1)
         moloc=values(2)
         ddloc=values(3)
         IF (flgtsys.ge.2) THEN
            WRITE(*,*) 'Using also system time.'
            hhloc=values(5)
            mmloc=values(6)
            ssloc=values(7)
         ELSE
            WRITE(*,*) 'Using user-defined time with system date.'
         ENDIF
         IF (flgtsys.ge.3) THEN
            WRITE(*,*) 'Using also system time zone.'
            hhoff=values(4)/60
            mmoff=values(4)-60*hhoff
            ssoff=0
         ELSE
            WRITE(*,*) 'Using user-defined time zone.'
         ENDIF
      ELSE
         WRITE(*,*) 'Using date, time, and time offset from sidate.inp.'
         IF (hhoff<0) THEN
c     correct for timezone offset: sign of hhoff for all time components
            mmoff=-mmoff
            ssoff=-ssoff
         ENDIF
      ENDIF
      WRITE(*,*)
      thoff=dble(hhoff)+dble(mmoff)/6.d1+dble(ssoff)/3.6d3
c      hh=hhloc-hhoff
c      mm=mmloc-mmoff
c      ss=ssloc-ssoff
      CALL DAT2JD(yrloc,moloc,ddloc,hhloc,mmloc,ssloc,0,JDloc)
      CALL JD2DAT(JDloc,yrloc,moloc,ddloc,hhloc,mmloc,ssloc,0)!
      loctime=dble(hhloc)+dble(mmloc)/6.d1+dble(ssloc)/3.6d3
c      CALL DAT2JD(yr,mo,dd,hh,mm,ss,0,JDref)
c      write(*,*) ''
      JDref=JDloc-thoff/24.d0
      CALL JD2DAT(JDref,yr,mo,dd,hh,mm,ss,0)! clean date+time from time overlaps etc.
      CALL JD2DOW(JDref,dow,cdow,0,0)
      IF (flgdt.NE.0) THEN
!     Delta T = TDT - UT or TDT = UT + Delta T
         CALL yeardec(JDref,ydec)
         CALL deltat(ydec,delt)
         IF (flgdt>0) THEN
            WRITE(*,*) 'Using input = UTC'
!     input/system time = UTC \approx UT, convert into TDT
            JDutc=JDref         !old JDref
            JDref=JDref+delt/8.64d4
            JDtdt=JDref         !new JDref
            yrutc=yr; moutc=mo; ddutc=dd; hhutc=hh; mmutc=mm; ssutc=ss
            CALL JD2DAT(JDref,yrtdt,motdt,ddtdt,hhtdt,mmtdt,sstdt,0)
         ELSE IF (flgdt<0) THEN
            WRITE(*,*) 'Using input = TDT'
!     input/system time = TDT, convert into UT(C)
            JDtdt=JDref         !old JDref
            JDref=JDref-delt/8.64d4
            JDutc=JDref         !new JDref
            JDloc=JDloc-delt/8.64d4
            yrtdt=yr; motdt=mo; ddtdt=dd; hhtdt=hh; mmtdt=mm; sstdt=ss
            CALL JD2DAT(JDref,yrutc,moutc,ddutc,hhutc,mmutc,ssutc,0)
            CALL JD2DAT(JDloc,yrloc,moloc,ddloc,hhloc,mmloc,ssloc,0)
         ENDIF
      ELSE
!     Use TDT, do not convert anything
         WRITE(*,*) 'Using TDT = UTC (neglect delta T)'
         delt=0.d0
         JDtdt=JDref
         JDutc=JDref
         yrtdt=yr; motdt=mo; ddtdt=dd; hhtdt=hh; mmtdt=mm; sstdt=ss
         yrutc=yr; moutc=mo; ddutc=dd; hhutc=hh; mmutc=mm; ssutc=ss
      ENDIF
      write(*,*) 'ydec,delt =',ydec,delt
c      utc=dble(hh)+dble(mm)/6.d1+dble(ss)/3.6d3
c      utc=24.d0*(JDref+0.5d0-int(JDref+0.5d0))
      utc=24.d0*(JDutc+0.5d0-int(JDutc+0.5d0))
      tdt=24.d0*(JDtdt+0.5d0-int(JDtdt+0.5d0))
      ymmdd=dble(yr)+1.d-2*mo+1.d-4*dd
c      WRITE(*,*) 'ymmdd =',ymmdd
      OPEN(14,FILE='sid.par')
      READ(14,*) ch6,nb
      READ(14,*) ch6,ibo
      READ(14,*) ch6,ibt
      READ(14,*) ch6,ibr
      READ(14,*) ch6,omx0     
      READ(14,*) ch6,sdelay!here: start of winter solstice vs. Jan 1
      READ(14,*) ch6,axtilt     
      READ(14,*) ch6,tprecess   
      READ(14,*) ch6,Jepoch0    
      READ(14,*) ch6,ytr   
      READ(14,*) ch6,refplane(1)
      READ(14,*) ch6,refplane(2)
      READ(14,*) ch6,refplane(3)
      READ(14,*) ch6,JDini
      READ(14,*) ch6,JDfin
      READ(14,*) ch6,JDstep
      READ(14,*) ch6,nt
      CLOSE(14)
      ntx=-1
      dmin=1.d30
      odref=2.d30
      DO i=0,nt
         ni=i
         JD=JDini+i*JDstep
         dref=JD-JDref
         IF (abs(dref).lt.abs(dmin)) THEN
            ntx=i
            JDt=JD!save best JD
            dmin=dref
            dJD=dref-odref
         ENDIF
!        WRITE(*,*) 'i,JD,JDref,dref =',i,JD,JDref,dref,JDt
!         IF (dref.ge.0.d0) EXIT
!         WRITE(*,*) 'ni,nt,np,nt+np/2=',ni,nt,np,nt+np/2
         IF (ni.ge.ntx+np2) EXIT
         odref=dref
      ENDDO
      GOTO 10
 9    WRITE(*,*) 'End of file reached. This *may* be OK.'
 10   WRITE(*,*) 'Found: ntx,JD = ',ntx,JD!,'; diff =',dmin
      tau=(JDref-JDt)/dJD
      ip0=ni-np
      ipn=ni
      ipt=ntx
      npt=ipt-ip0
c     Diagnostics output
      WRITE(*,*) 'JD ini,timestep =',JDini,JDstep,dJD
c      WRITE(*,*) 'ni,nt =',ni,nt
c      WRITE(*,*) 'npt   =',npt
c      WRITE(*,*) 'ip0,ntx,ipn =',ip0,ntx,ipn
c      WRITE(*,*) 'ip0-ntx,ipn-nt =',ip0-ntx,ipn-ntx
c      WRITE(*,*) 'tau =',tau
!      stop
      OPEN(15,FILE='si_xyz.out')
      OPEN(17,FILE='si_date.out')!diagnostics
      write(*,*)
      write(*,*) 'nb =',nb
      DO i=0,ip0
!         write(*,*) 'i =',i,ip0
         READ(15,*)
         READ(17,*)!diagnostics
      ENDDO
c     diagnostics
c      READ(15,'(A24)') ch24
c      write(*,*) 'ch24 =',ch24
c      stop
c     (diagnostics
      DO ip=0,np
!         write(*,*) 'ip =',ip,np
         READ(15,*) JEa(ip),(pna(ip,1,j),pna(ip,2,j),pna(ip,3,j),j=1,nb)
         JDa(ip)=JDini+(ip0+ip)*JDstep
         READ(17,*) dummy,dummy,jdtest(ip)!diagnostics
      ENDDO
      DO ip=0,np
         xa(ip)=np*((JDa(ip)-JDt)/(JDa(np)-JDa(0)))!get unit abscissae
c         write(*,*) 'ip,JE,JD,xa(ip) =',ip,JEa(ip),JDa(ip),xa(ip)
      ENDDO
c      JE=2000.d0+(JDt-2451545.d0)/365.25d0
      jtest=2
c     diagnostics
      nxi=10
      dxi=1.d0/dble(nxi)
      write(*,*) 'tau,JD =',tau,JDa(np2)+tau*JDstep,JDref,xa(np2)
c     /diagnostics
      IF (useintp) THEN
            DO j=1,nb!body 1 to nb
               DO i=1,3!x,y,z
                  DO ip=0,np
                     ya(ip)=pna(ip,i,j)
                  ENDDO
                  CALL dopolint(np,xa,ya,tau,ftau)
                  pn(i,j)=ftau
cc     diagnostics
c                  IF (j==3) WRITE(*,*) 'i,tau, ftau =',i,tau,ftau
c                  IF (j==jtest.and.i==1) THEN
c                     do ip=0,np
c                       write(44,'(2(1PE16.8,2X),0P,2(1X,F9.1))') 
c     &                       xa(ip),ya(ip),JDa(ip),JDtest(ip)
c                     enddo
c                     do ii=0,nxi*np
c                        x=xa(0)+ii*dxi*(xa(1)-xa(0))
c                        y=ffpol(np,xa,x)
c                        write(55,'(2(1PE16.8,2X),0P,2(1X,F9.1))') 
c     &    x,y,JDa(0)+ii*JDstep*dxi,JDtest(0)+ii*JDstep*dxi
c                     enddo
c                  ENDIF
cc     /diagnostics
                  DO ip=0,np
                     ya(ip)=vna(ip,i,j)
                  ENDDO
                  CALL dopolint(np,xa,ya,tau,ftau)
                  vn(i,j)=ftau
c                  write(*,*) 'i,j,ftau =',i,j,ftau
               ENDDO
c               stop
            ENDDO
            JE=2000.d0+(JDref-2451545.d0)/365.25d0
            JTR=Jepoch0+(JDref-2451544.5d0)/ytr
            season=12.d0*(JTR-int(JTR))+1.d0
            write(*,*) 'season =',season,JTR
            write(*,*) 'Jepoch0 =',Jepoch0
c         WRITE(*,*) 'JDref =',JDref,2000.d0+(JDref-2451545.d0)/365.25d0
      ENDIF
      CLOSE(15)
      CLOSE(17)!diagnostics
         IF (abs(tprecess)<1.d-4) THEN
            phi_prec=omx0
         ELSE
            phi_prec=(Jepoch0-JE)/tprecess*360.d0+omx0
         ENDIF
      enplanet=(/0.d0,axtilt,omx0-180.d0/)
      enplanet=(/0.d0,axtilt,phi_prec-180.d0/)
      CALL getpoles(enplanet,refplane)
      x=pn(1,ibo);y=pn(2,ibo);z=pn(3,ibo)
      CALL ct2sph(x,y,z,r,theta,phi)
      IF (flgseason==1) THEN
         write(*,*) 'tropical year'
         phis=(season-1.d0)*0.523598775598298873D0!+phi_prec*d2r
      ELSE IF (flgseason==2) THEN
         write(*,*) 'state vector'
         phis=phi+1.5d0*pi+sdelay*d2r
      ELSE
         write(*,*) 'calendar year'
         CALL DAT2JD(yr,1,1,0,0,0,0,JD0)
         CALL DAT2JD(yr+1,1,1,0,0,0,0,JD1)
         phis=(JDref-JD0)/(JD1-JD0)*2.d0*pi!+phi_prec*d2r
      ENDIF
      write(*,*) 'phis    =',phis/d2r
      write(*,*) 'phi_prec=',phi_prec
      write(*,*) 'sdelay  =',sdelay
      write(*,*) 
      write(*,*) 'DOW     =   ',cdow
      write(*,*) 
      OPEN(20,FILE='sidate.aux')
      WRITE(20,'(A,I4,2(A,I2))') 'tdt_yr=',yrtdt,'; tdt_mo=',motdt,
     &                           '; tdt_dd=',ddtdt
      WRITE(20,'(A,I4,2(A,I2))') 'tdt_hh=',hhtdt,'; tdt_mm=',mmtdt,
     &                           '; tdt_ss=',sstdt
      WRITE(20,'(A,I4,2(A,I2))') 'utc_yr=',yrutc,'; utc_mo=',moutc,
     &                           '; utc_dd=',ddutc
      WRITE(20,'(A,I4,2(A,I2))') 'utc_hh=',hhutc,'; utc_mm=',mmutc,
     &                           '; utc_ss=',ssutc
      WRITE(20,'(A,I4,2(A,I2))') 'loc_yr=',yrloc,'; loc_mo=',moloc,
     &                           '; loc_dd=',ddloc
      WRITE(20,'(A,I4,2(A,I2))') 'loc_hh=',hhloc,'; loc_mm=',mmloc,
     &                           '; loc_ss=',ssloc
      WRITE(20,'(A,F16.6)') 'JDref=',JDref
      WRITE(20,'(A,F12.8)') 'tdt=',tdt
      WRITE(20,'(A,F12.8)') 'utc=',utc
      WRITE(20,'(A,F12.8)') 'loctime=',loctime
      WRITE(20,'(A,F12.8)') 'toffset=',thoff
      WRITE(20,'(A,F12.8)')  'season=',season
      WRITE(20,'(A,F12.8)') 'phis=',phis
      WRITE(20,'(1P,3(A,E15.8))') 'xref=',pn(1,ibo),'; yref=',pn(2,ibo),
     &                            '; zref=',pn(3,ibo)
      CLOSE(20)
      outxyz='sidate.xyz'
      tabrv='sidate.tab'
      OPEN(25,FILE=outxyz)
      WRITE(25,1001) '#JEpoch',(j, j=1,nb)
      WRITE(25,1000) JE,(pn(1,j),pn(2,j),pn(3,j),j=1,nb)
      CLOSE(25)
      OPEN(30,FILE=tabrv)
      DO j=1,nb
         CALL n2char(j,digsomi,digsobj,nchar)
         ch2=nchar
         chobj(1,j)='obj'//ch2//'x'
         chobj(2,j)='obj'//ch2//'y'
         chobj(3,j)='obj'//ch2//'z'
c         write(*,*) 'j,chobjxyz =',j,(' ',chobj(i,j),i=1,3)
         WRITE(30,1100) (chobj(i,j),pn(i,j),i=1,3)
      ENDDO
      CLOSE(30)
      WRITE(*,*)
 1000 FORMAT(F17.6,1X,60600(1X,1Pe16.8))
 1001 FORMAT(A17,4X,100(I5.5,' X',10X,'Y',16X,'Z',16X))
 1100 FORMAT(1P,2(A,'=',E15.8,'; '),A6,'=',E15.8)
      END

      SUBROUTINE dopolint(np,xa,ya,tau,ftau)
      IMPLICIT NONE
      INTEGER np,npmax
      PARAMETER (npmax=20)
      DOUBLE PRECISION tau,ftau
      DOUBLE PRECISION xa(0:npmax),ya(0:npmax),ca(0:npmax),fpolint
      COMMON /c4int/ ca
      CALL polint(np,xa,ya,ca)
      ftau=fpolint(np,xa,ca,tau)
      RETURN
      END

      DOUBLE PRECISION FUNCTION ffpol(np,xa,tau)
      IMPLICIT NONE
      INTEGER np,npmax
      PARAMETER (npmax=20)
      DOUBLE PRECISION tau,xa(0:npmax),ca(0:npmax),fpolint
      COMMON /c4int/ ca
      ffpol=fpolint(np,xa,ca,tau)
      RETURN
      END

      SUBROUTINE getpoles(enplanet,refplane)
      IMPLICIT NONE
      DOUBLE PRECISION d2r
      PARAMETER (d2r=1.7453292519943295769D-2)
      DOUBLE PRECISION enplanet(3),refplane(3)
      DOUBLE PRECISION e1(3),e2(3),e3(3),ep1(3),ep2(3),ep3(3)
      DOUBLE PRECISION vdum1(3)
      ep1(1)=1.d0;ep1(2)=0.d0;ep1(3)=0.d0
      ep2(1)=0.d0;ep2(2)=1.d0;ep2(3)=0.d0
      ep3(1)=0.d0;ep3(2)=0.d0;ep3(3)=1.d0
      e1(1)=0.d0; e1(2)=-1.d0;e1(3)=0.d0
      e2(1)=1.d0; e2(2)=0.d0; e2(3)=0.d0
      e3(1)=0.d0; e3(2)=0.d0; e3(3)=1.d0
!      write(*,*) 'enplanet =',enplanet
!      write(*,*) 'refplane =',refplane
!     Reference plane
!     ep1 = x
      CALL rotzxz(ep1,ep1,refplane(1)*d2r,
     &     refplane(2)*d2r,refplane(3)*d2r)
!      ep1(:)=vdum1(:)
!     ep2 = y
      CALL rotzxz(ep2,ep2,refplane(1)*d2r,
     &     refplane(2)*d2r,refplane(3)*d2r)
!      ep2(:)=vdum1(:)
!     ep3 = z
      CALL rotzxz(ep3,ep3,refplane(1)*d2r,
     &     refplane(2)*d2r,refplane(3)*d2r)
!      ep3(:)=vdum1(:)
!     e1 = 0 Lat, 0 Lon
!      WRITE(*,*) 'e1       =',e1
      CALL rotzxz(e1,vdum1,enplanet(1)*d2r,enplanet(2)*d2r,
     &     enplanet(3)*d2r)
!      WRITE(*,*) 'vdum1    =',vdum1
      CALL rotzxz(vdum1,e1,refplane(1)*d2r,
     &     refplane(2)*d2r,refplane(3)*d2r)
!     e2 = 0 Lat, 90 Lon
!      WRITE(*,*) 'e2       =',e2
      CALL rotzxz(e2,vdum1,enplanet(1)*d2r,enplanet(2)*d2r,
     &     enplanet(3)*d2r)
!      WRITE(*,*) 'vdum1    =',vdum1
      CALL rotzxz(vdum1,e2,refplane(1)*d2r,
     &     refplane(2)*d2r,refplane(3)*d2r)
!     e3 = northpole vector
!      WRITE(*,*) 'e3       =',e3
      CALL rotzxz(e3,vdum1,enplanet(1)*d2r,enplanet(2)*d2r,
     &     enplanet(3)*d2r)
!      WRITE(*,*) 'vdum1    =',vdum1
      CALL rotzxz(vdum1,e3,refplane(1)*d2r,
     &     refplane(2)*d2r,refplane(3)*d2r)
!
      OPEN(47,FILE='uvecs.aux')
c      WRITE(47,'(A,F9.4)') 'thpol=',enplanet(2)
c      WRITE(47,'(A,F9.4)') 'phpol=',enplanet(3)
      WRITE(47,'(A,F9.6)') 'e1x  =',e1(1)
      WRITE(47,'(A,F9.6)') 'e1y  =',e1(2)
      WRITE(47,'(A,F9.6)') 'e1z  =',e1(3)
      WRITE(47,'(A,F9.6)') 'e2x  =',e2(1)
      WRITE(47,'(A,F9.6)') 'e2y  =',e2(2)
      WRITE(47,'(A,F9.6)') 'e2z  =',e2(3)
      WRITE(47,'(A,F9.6)') 'e3x  =',e3(1)
      WRITE(47,'(A,F9.6)') 'e3y  =',e3(2)
      WRITE(47,'(A,F9.6)') 'e3z  =',e3(3)
      WRITE(47,'(A,F9.6)') 'ep1x =',ep1(1)
      WRITE(47,'(A,F9.6)') 'ep1y =',ep1(2)
      WRITE(47,'(A,F9.6)') 'ep1z =',ep1(3)
      WRITE(47,'(A,F9.6)') 'ep2x =',ep2(1)
      WRITE(47,'(A,F9.6)') 'ep2y =',ep2(2)
      WRITE(47,'(A,F9.6)') 'ep2z =',ep2(3)
      WRITE(47,'(A,F9.6)') 'ep3x =',ep3(1)
      WRITE(47,'(A,F9.6)') 'ep3y =',ep3(2)
      WRITE(47,'(A,F9.6)') 'ep3z =',ep3(3)
      CLOSE(47)
      RETURN
      END
