#### Celestial globe plot
#pause mouse key "Press any key to proceed to sky globe plots\n"
pscal=5.; ppwr=0.2
load 'psizes.gp'
## Surface grid for sky globe (only the activation conditions differ)
N=36# 5 degrees
if(flgsurf>=2) set for [i=1:N] arrow i+Narr from fx0(i),fy0(i),fz0(i) to fx1(i),fy1(i),fz1(i) ls lspolar2 nohead back
if(flgsurf>=2) Narr=Narr+N
N=4 # 45 degrees
if(flgsurf>=1) set for [i=1:N] arrow i+Narr from fx0(i),fy0(i),fz0(i) to fx1(i),fy1(i),fz1(i) ls lspolar1 nohead back
if(flgsurf>=1) Narr=Narr+N
########
set xlabel "x"; set ylabel "y"; set zlabel "z"
set term strgterm 1 title "Solar System 3D Normalized Radii"
#fcx(x,y,z)=0.99999999*r*x/fmax(fr(x,y,z),1.e-30)
#fcy(x,y,z)=0.99999999*r*y/fmax(fr(x,y,z),1.e-30)
#fcz(x,y,z)=0.99999999*r*z/fmax(fr(x,y,z),1.e-30)
fcx(x,y,z)=0.99999999*r*fxgeo(x)/fmax(fr(fxgeo(x),fygeo(y),fzgeo(z)),1.e-30)
fcy(x,y,z)=0.99999999*r*fygeo(y)/fmax(fr(fxgeo(x),fygeo(y),fzgeo(z)),1.e-30)
fcz(x,y,z)=0.99999999*r*fzgeo(z)/fmax(fr(fxgeo(x),fygeo(y),fzgeo(z)),1.e-30)
#splot pointfile using (fcx(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))):(fcy(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))):(fcz(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))) t 'Mercury'  w p pt 7 ps psmerc  lc rgb rgbmerc ,\
      pointfile using (fcx(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))):(fcy(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))):(fcz(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))) t 'Venus'      w p pt 7 ps psvenus lc rgb rgbvenus,\
      pointfile using (fcx(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))):(fcy(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))):(fcz(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))) t 'Earth'      w p pt 7 ps psearth lc rgb rgbearth,\
      pointfile using (fcx(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))):(fcy(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))):(fcz(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))) t 'Moon'       w p pt 6 ps psmoon2 lc rgb rgbmoon2,\
      pointfile using (fcx(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))):(fcy(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))):(fcz(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))) t 'Eros'       w p pt 7 ps pseros  lc rgb rgberos ,\
      pointfile using (fcx(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))):(fcy(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))):(fcz(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))) t 'Mars'       w p pt 7 ps psmars  lc rgb rgbmars ,\
      pointfile using (fcx(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))):(fcy(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))):(fcz(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))) t 'Vesta'      w p pt 7 ps psvesta lc rgb rgbvesta,\
      pointfile using (fcx(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))):(fcy(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))):(fcz(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))) t 'Juno'       w p pt 7 ps psjuno  lc rgb rgbjuno ,\
      pointfile using (fcx(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))):(fcy(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))):(fcz(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))) t 'Ceres'      w p pt 7 ps psceres lc rgb rgbceres,\
      pointfile using (fcx(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))):(fcy(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))):(fcz(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))) t 'Pallas'     w p pt 7 ps pspall  lc rgb rgbpall ,\
      pointfile using (fcx(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))):(fcy(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))):(fcz(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))) t 'Interamnia' w p pt 7 ps psinta  lc rgb rgbinta ,\
      pointfile using (fcx(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))):(fcy(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))):(fcz(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))) t 'Hygiea'     w p pt 7 ps pshyg   lc rgb rgbhyg  ,\
      pointfile using (fcx(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))):(fcy(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))):(fcz(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))) t 'Jupiter'    w p pt 7 ps psjup   lc rgb rgbjup  ,\
      pointfile using (fcx(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))):(fcy(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))):(fcz(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))) t 'Saturn'     w p pt 7 ps pssat   lc rgb rgbsat  ,\
      pointfile using (fcx(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))):(fcy(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))):(fcz(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))) t 'Chiron'     w p pt 7 ps pschir  lc rgb rgbchir ,\
      pointfile using (fcx(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))):(fcy(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))):(fcz(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))) t 'Uranus'     w p pt 7 ps psur    lc rgb rgbur   ,\
      pointfile using (fcx(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))):(fcy(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))):(fcz(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))) t 'Neptune'    w p pt 7 ps psnep   lc rgb rgbnep  ,\
      pointfile using (fcx(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))):(fcy(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))):(fcz(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))) t 'Orcus'      w p pt 7 ps psorcus lc rgb rgborcus,\
      pointfile using (fcx(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))):(fcy(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))):(fcz(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))) t 'Pluto'      w p pt 7 ps pspluto lc rgb rgbpluto,\
      pointfile using (fcx(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))):(fcy(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))):(fcz(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))) t 'Haumea'     w p pt 7 ps pshaume lc rgb rgbhaume,\
      pointfile using (fcx(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))):(fcy(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))):(fcz(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))) t 'Quaoar'     w p pt 7 ps psqua   lc rgb rgbqua,\
      pointfile using (fcx(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))):(fcy(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))):(fcz(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))) t 'Makemake'   w p pt 7 ps psmakem lc rgb rgbmakem,\
      pointfile using (fcx(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))):(fcy(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))):(fcz(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))) t 'Eris'       w p pt 7 ps pseris  lc rgb rgberis ,\
      pointfile using (fcx(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))):(fcy(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))):(fcz(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))) t 'Sedna'      w p pt 7 ps pssedna lc rgb rgbsedna,\
      pointfile using (fcx(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))):(fcy(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))):(fcz(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))) t 'Sun'        w p pt 3 ps pssun   lc rgb rgbsun  ,\
if(flgstars>=2) replot starfile using (fcx(pc2au*$4,pc2au*$5,pc2au*$6)):(fcy(pc2au*$4,pc2au*$5,pc2au*$6)):(fcz(pc2au*$4,pc2au*$5,pc2au*$6)):(psize($9)):7 notitle w p pt 1 ps variable palette

#### Well aligned globe
#pause mouse key "Press any key to proceed to sky globe plots\n"
set term strgterm 1 title "Solar System 3D Sky Globe"
set view 80,345,kzoom
#set view 80,195,kzoom
set format x '%g'; set format y '%g'; set format z '%g'
r=1; s=0.5
dr=1.*s
set border ls 17
set xtics dr; set ytics dr; set ztics dr
set mxtics nmtics; set mytics nmtics; set mztics nmtics
if (flgborder<0) unset border; unset xtics; unset ytics; unset ztics
set xrange [-r:r];set yrange [-r:r];set zrange [-r:r]
unset arrow
Narr=1
# inverse rotation via v_i = <v,b> b_i
# (see above)
#fcx(x,y,z)=0.99999999*r*frotx(x,y,z)/fmax(fr(x,y,z),1.e-30)# sqrt(x**2+y**2+z**2)
#fcy(x,y,z)=0.99999999*r*froty(x,y,z)/fmax(fr(x,y,z),1.e-30)# sqrt(x**2+y**2+z**2)
#fcz(x,y,z)=0.99999999*r*frotz(x,y,z)/fmax(fr(x,y,z),1.e-30)# sqrt(x**2+y**2+z**2)
fcx(x,y,z)=0.99999999*r*frotx(fxgeo(x),fygeo(y),fzgeo(z))/fmax(fr(fxgeo(x),fygeo(y),fzgeo(z)),1.e-30)# sqrt(x**2+y**2+z**2)
fcy(x,y,z)=0.99999999*r*froty(fxgeo(x),fygeo(y),fzgeo(z))/fmax(fr(fxgeo(x),fygeo(y),fzgeo(z)),1.e-30)# sqrt(x**2+y**2+z**2)
fcz(x,y,z)=0.99999999*r*frotz(fxgeo(x),fygeo(y),fzgeo(z))/fmax(fr(fxgeo(x),fygeo(y),fzgeo(z)),1.e-30)# sqrt(x**2+y**2+z**2)
#### Globe grid
## Definitions
f0rotx(x,y,z)=x*xpe0+y*ype0+z*zpe0
f0roty(x,y,z)=x*xpn0+y*ypn0+z*zpn0
f0rotz(x,y,z)=x*xpu0+y*ypu0+z*zpu0
f0cx(x,y,z)=r*f0rotx(x,y,z)/sqrt(x**2+y**2+z**2)
f0cy(x,y,z)=r*f0roty(x,y,z)/sqrt(x**2+y**2+z**2)
f0cz(x,y,z)=r*f0rotz(x,y,z)/sqrt(x**2+y**2+z**2)
fgx(x,y,z)=flgglobe>0 ? r*f0rotx(x,y,z)/sqrt(x**2+y**2+z**2) : x
fgy(x,y,z)=flgglobe>0 ? r*f0roty(x,y,z)/sqrt(x**2+y**2+z**2) : y
fgz(x,y,z)=flgglobe>0 ? r*f0rotz(x,y,z)/sqrt(x**2+y**2+z**2) : z
fnlat(x,N)=pi/N*x-pi/2.
fnlon(x,N)=pi/N*x
fx0lat(u,lat)=cos(u)*cos(lat); fy0lat(u,lat)=sin(u)*cos(lat); fz0lat(u,lat)=sin(lat)
fx0lon(u,lon)=cos(u)*sin(lon); fy0lon(u,lon)=cos(u)*cos(lon); fz0lon(u,lon)=sin(u)
## Temporary output
globe1name='globe1.dat'
globe2name='globe2.dat'
globesmplat=int(360./globeddeglat+1.000001)
globesmplon=int(360./globeddeglon+1.000001)
set parametric #need parametric mode here
set urange [0:2*pi]
## Coarse globe grid
globefname=globe1name
degglobelat2=degglobelat1/mglobelat
degglobelon2=degglobelon1/mglobelon
Nth=int(180./degglobelat1+0.000001)
Nph=int(180./degglobelon1+0.000001)
if(abs(flgglobe)>=1) load 'globegrid.gp'
## Fine globe grid
globefname=globe2name
Nth=int(180./degglobelat2+0.000001)
Nph=int(180./degglobelon2+0.000001)
if(abs(flgglobe)>=2) load 'globegrid.gp'
unset parametric #back to normal mode
## Dummy output if no globe grid is chosen
if(abs(flgglobe)<=0) set print globe1name; print 'NaN NaN NaN'; set print
if(abs(flgglobe)<=1) set print globe2name; print 'NaN NaN NaN'; set print
set samples 100 # back to default
#### Planetary Spin Axis
kr=r;lr=1.05
xspin=kr*(e3x*xpe+e3y*ype+e3z*zpe)
yspin=kr*(e3x*xpn+e3y*ypn+e3z*zpn)
zspin=kr*(e3x*xpu+e3y*ypu+e3z*zpu)
if(abs(flgpobs)>=1) set arrow Narr from -xspin,-yspin,-zspin to xspin,yspin,zspin ls 5;Narr=Narr+1
if(abs(flgpobs)>=1) set label 1 'P' at lr*xspin,lr*yspin,lr*zspin tc rgb rgbpole
#### Surface compass rose
kr=0.5*r;lr=0.55*r
if(abs(flgrose)>=1) set arrow Narr from 0,0,0  to kr,0,0 ls 6;Narr=Narr+1
if(abs(flgrose)>=1) set arrow Narr from 0,0,0  to 0,kr,0 ls 7;Narr=Narr+1
if(abs(flgrose)>=1) set arrow Narr from 0,0,0  to 0,0,kr ls 8;Narr=Narr+1
if(abs(flgrose)>=1) set label 2 'N' at 0,lr,0 tc rgb rgbnorth
if(abs(flgrose)>=1) set label 3 'E' at lr,0,0 tc rgb rgbeast
if(abs(flgrose)>=1) set label 4 'Z' at 0,0,lr tc rgb rgbupwd
N=36# 5 degrees
if(abs(flgsurf)>=2) set for [i=1:N] arrow i+Narr from -fx(i),-fy(i),0 to fx(i),fy(i),0 ls lspolar2 nohead back
if(abs(flgsurf)>=2) Narr=Narr+N
N=4 # 45 degrees
if(abs(flgsurf)>=1) set for [i=1:N] arrow i+Narr from -fx(i),-fy(i),0 to fx(i),fy(i),0 ls lspolar1 nohead back
if(abs(flgsurf)>=1) Narr=Narr+N
#### Rect grid
Nr1=2*int(r/dr+0.000001)
Nr2=2*int(nmtics*r/dr+0.000001)
Nmajor=Nr1
Nminor=Nr2
rn1=dr*(Nr1/2)
rn2=dr*(Nr2/2)/nmtics
fn1(x)=rn1*(2./Nr1*x-1.)
fn2(x)=rn2*(2./Nr2*x-1.)
fx0(x)=-r*ep1x+fn2(x)*ep2x+zoffset*ep3x;fx1(x)=r*ep1x+fn2(x)*ep2x+zoffset*ep3x;fx2(x)=fn2(x)*ep1x-r*ep2x+zoffset*ep3x;fx3(x)=fn2(x)*ep1x+r*ep2x+zoffset*ep3x
fy0(x)=-r*ep1y+fn2(x)*ep2y+zoffset*ep3y;fy1(x)=r*ep1y+fn2(x)*ep2y+zoffset*ep3y;fy2(x)=fn2(x)*ep1y-r*ep2y+zoffset*ep3y;fy3(x)=fn2(x)*ep1y+r*ep2y+zoffset*ep3y
fz0(x)=-r*ep1z+fn2(x)*ep2z+zoffset*ep3z;fz1(x)=r*ep1z+fn2(x)*ep2z+zoffset*ep3z;fz2(x)=fn2(x)*ep1z-r*ep2z+zoffset*ep3z;fz3(x)=fn2(x)*ep1z+r*ep2z+zoffset*ep3z
gx0(x)=-r*ep1x+fn1(x)*ep2x+zoffset*ep3x;gx1(x)=r*ep1x+fn1(x)*ep2x+zoffset*ep3x;gx2(x)=fn1(x)*ep1x-r*ep2x+zoffset*ep3x;gx3(x)=fn1(x)*ep1x+r*ep2x+zoffset*ep3x
gy0(x)=-r*ep1y+fn1(x)*ep2y+zoffset*ep3y;gy1(x)=r*ep1y+fn1(x)*ep2y+zoffset*ep3y;gy2(x)=fn1(x)*ep1y-r*ep2y+zoffset*ep3y;gy3(x)=fn1(x)*ep1y+r*ep2y+zoffset*ep3y
gz0(x)=-r*ep1z+fn1(x)*ep2z+zoffset*ep3z;gz1(x)=r*ep1z+fn1(x)*ep2z+zoffset*ep3z;gz2(x)=fn1(x)*ep1z-r*ep2z+zoffset*ep3z;gz3(x)=fn1(x)*ep1z+r*ep2z+zoffset*ep3z
fx4(s)=frotx(fx0(s),fy0(s),fz0(s)); fx5(s)=frotx(fx1(s),fy1(s),fz1(s)); fx6(s)=frotx(fx2(s),fy2(s),fz2(s)); fx7(s)=frotx(fx3(s),fy3(s),fz3(s))
fy4(s)=froty(fx0(s),fy0(s),fz0(s)); fy5(s)=froty(fx1(s),fy1(s),fz1(s)); fy6(s)=froty(fx2(s),fy2(s),fz2(s)); fy7(s)=froty(fx3(s),fy3(s),fz3(s))
fz4(s)=frotz(fx0(s),fy0(s),fz0(s)); fz5(s)=frotz(fx1(s),fy1(s),fz1(s)); fz6(s)=frotz(fx2(s),fy2(s),fz2(s)); fz7(s)=frotz(fx3(s),fy3(s),fz3(s))
gx4(s)=frotx(gx0(s),gy0(s),gz0(s)); gx5(s)=frotx(gx1(s),gy1(s),gz1(s)); gx6(s)=frotx(gx2(s),gy2(s),gz2(s)); gx7(s)=frotx(gx3(s),gy3(s),gz3(s))
gy4(s)=froty(gx0(s),gy0(s),gz0(s)); gy5(s)=froty(gx1(s),gy1(s),gz1(s)); gy6(s)=froty(gx2(s),gy2(s),gz2(s)); gy7(s)=froty(gx3(s),gy3(s),gz3(s))
gz4(s)=frotz(gx0(s),gy0(s),gz0(s)); gz5(s)=frotz(gx1(s),gy1(s),gz1(s)); gz6(s)=frotz(gx2(s),gy2(s),gz2(s)); gz7(s)=frotz(gx3(s),gy3(s),gz3(s))
N0=Narr+1; N1=N0+Nminor+1; N2=N1+Nminor+1; N3=N2+Nmajor+1; N4=N3+Nmajor+1
N=Nminor
if(flggrid<=-2) set for [i=0:N] arrow i+N0 from fx4(i),fy4(i),fz4(i) to fx5(i),fy5(i),fz5(i) ls lsgrid2 nohead# back #1 to Nminor+1
if(flggrid<=-2) set for [i=0:N] arrow i+N1 from fx6(i),fy6(i),fz6(i) to fx7(i),fy7(i),fz7(i) ls lsgrid2 nohead# back #1 to Nminor+1
N=Nmajor
if(flggrid<=-1) set for [i=0:N] arrow i+N2 from gx4(i),gy4(i),gz4(i) to gx5(i),gy5(i),gz5(i) ls lsgrid1 nohead# back #1 to Nminor+1
if(flggrid<=-1) set for [i=0:N] arrow i+N3 from gx6(i),gy6(i),gz6(i) to gx7(i),gy7(i),gz7(i) ls lsgrid1 nohead# back #1 to Nminor+1
load 'window4sol3d.gp'
#### The Plot
splot pointfile using (fcx(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))):(fcy(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))):(fcz(column(cx01)-column(cx),column(cy01)-column(cy),column(cz01)-column(cz))) t 'Mercury' 	  w p pt 7 ps psmerc  lc rgb rgbmerc ,\
      pointfile using (fcx(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))):(fcy(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))):(fcz(column(cx02)-column(cx),column(cy02)-column(cy),column(cz02)-column(cz))) t 'Venus'   	  w p pt 7 ps psvenus lc rgb rgbvenus,\
      pointfile using (fcx(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))):(fcy(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))):(fcz(column(cx03)-column(cx),column(cy03)-column(cy),column(cz03)-column(cz))) t 'Earth'   	  w p pt 7 ps psearth lc rgb rgbearth,\
      pointfile using (fcx(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))):(fcy(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))):(fcz(column(cx04)-column(cx),column(cy04)-column(cy),column(cz04)-column(cz))) t 'Moon'    	  w p pt 6 ps psmoon2 lc rgb rgbmoon2,\
      pointfile using (fcx(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))):(fcy(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))):(fcz(column(cx05)-column(cx),column(cy05)-column(cy),column(cz05)-column(cz))) t 'Eros'    	  w p pt 7 ps pseros  lc rgb rgberos ,\
      pointfile using (fcx(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))):(fcy(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))):(fcz(column(cx06)-column(cx),column(cy06)-column(cy),column(cz06)-column(cz))) t 'Mars'    	  w p pt 7 ps psmars  lc rgb rgbmars ,\
      pointfile using (fcx(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))):(fcy(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))):(fcz(column(cx07)-column(cx),column(cy07)-column(cy),column(cz07)-column(cz))) t 'Vesta'   	  w p pt 7 ps psvesta lc rgb rgbvesta,\
      pointfile using (fcx(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))):(fcy(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))):(fcz(column(cx08)-column(cx),column(cy08)-column(cy),column(cz08)-column(cz))) t 'Juno'    	  w p pt 7 ps psjuno  lc rgb rgbjuno ,\
      pointfile using (fcx(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))):(fcy(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))):(fcz(column(cx09)-column(cx),column(cy09)-column(cy),column(cz09)-column(cz))) t 'Ceres'   	  w p pt 7 ps psceres lc rgb rgbceres,\
      pointfile using (fcx(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))):(fcy(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))):(fcz(column(cx10)-column(cx),column(cy10)-column(cy),column(cz10)-column(cz))) t 'Pallas'  	  w p pt 7 ps pspall  lc rgb rgbpall ,\
      pointfile using (fcx(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))):(fcy(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))):(fcz(column(cx11)-column(cx),column(cy11)-column(cy),column(cz11)-column(cz))) t 'Interamnia' w p pt 7 ps psinta  lc rgb rgbinta ,\
      pointfile using (fcx(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))):(fcy(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))):(fcz(column(cx12)-column(cx),column(cy12)-column(cy),column(cz12)-column(cz))) t 'Hygiea'  	  w p pt 7 ps pshyg   lc rgb rgbhyg  ,\
      pointfile using (fcx(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))):(fcy(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))):(fcz(column(cx13)-column(cx),column(cy13)-column(cy),column(cz13)-column(cz))) t 'Jupiter' 	  w p pt 7 ps psjup   lc rgb rgbjup  ,\
      pointfile using (fcx(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))):(fcy(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))):(fcz(column(cx14)-column(cx),column(cy14)-column(cy),column(cz14)-column(cz))) t 'Saturn'  	  w p pt 7 ps pssat   lc rgb rgbsat  ,\
      pointfile using (fcx(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))):(fcy(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))):(fcz(column(cx15)-column(cx),column(cy15)-column(cy),column(cz15)-column(cz))) t 'Chiron'  	  w p pt 7 ps pschir  lc rgb rgbchir ,\
      pointfile using (fcx(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))):(fcy(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))):(fcz(column(cx16)-column(cx),column(cy16)-column(cy),column(cz16)-column(cz))) t 'Uranus'  	  w p pt 7 ps psur    lc rgb rgbur   ,\
      pointfile using (fcx(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))):(fcy(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))):(fcz(column(cx17)-column(cx),column(cy17)-column(cy),column(cz17)-column(cz))) t 'Neptune' 	  w p pt 7 ps psnep   lc rgb rgbnep  ,\
      pointfile using (fcx(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))):(fcy(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))):(fcz(column(cx18)-column(cx),column(cy18)-column(cy),column(cz18)-column(cz))) t 'Orcus'   	  w p pt 7 ps psorcus lc rgb rgborcus,\
      pointfile using (fcx(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))):(fcy(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))):(fcz(column(cx19)-column(cx),column(cy19)-column(cy),column(cz19)-column(cz))) t 'Pluto'   	  w p pt 7 ps pspluto lc rgb rgbpluto,\
      pointfile using (fcx(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))):(fcy(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))):(fcz(column(cx20)-column(cx),column(cy20)-column(cy),column(cz20)-column(cz))) t 'Haumea'  	  w p pt 7 ps pshaume lc rgb rgbhaume,\
      pointfile using (fcx(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))):(fcy(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))):(fcz(column(cx21)-column(cx),column(cy21)-column(cy),column(cz21)-column(cz))) t 'Quaoar'  	  w p pt 7 ps psqua   lc rgb rgbqua,\
      pointfile using (fcx(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))):(fcy(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))):(fcz(column(cx22)-column(cx),column(cy22)-column(cy),column(cz22)-column(cz))) t 'Makemake'	  w p pt 7 ps psmakem lc rgb rgbmakem,\
      pointfile using (fcx(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))):(fcy(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))):(fcz(column(cx23)-column(cx),column(cy23)-column(cy),column(cz23)-column(cz))) t 'Eris'    	  w p pt 7 ps pseris  lc rgb rgberis ,\
      pointfile using (fcx(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))):(fcy(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))):(fcz(column(cx24)-column(cx),column(cy24)-column(cy),column(cz24)-column(cz))) t 'Sedna'   	  w p pt 7 ps pssedna lc rgb rgbsedna,\
      pointfile using (fcx(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))):(fcy(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))):(fcz(column(cx25)-column(cx),column(cy25)-column(cy),column(cz25)-column(cz))) t 'Sun'     	  w p pt 3 ps pssun   lc rgb rgbsun  ,\
      globe2name using (fgx($1,$2,$3)):(fgy($1,$2,$3)):(fgz($1,$2,$3)) notitle w l ls lsglobe2,\
      globe1name using (fgx($1,$2,$3)):(fgy($1,$2,$3)):(fgz($1,$2,$3)) notitle w l ls lsglobe1,\
      'winborders.dat' using 1:2:3 notitle w l ls 15,'wincorners.dat' using 1:2:3 notitle w l ls 16
if(flgstars>=2) replot starfile using (fcx(pc2au*$4,pc2au*$5,pc2au*$6)):(fcy(pc2au*$4,pc2au*$5,pc2au*$6)):(fcz(pc2au*$4,pc2au*$5,pc2au*$6)):(psize($9)):7 notitle w p pt 1 ps variable palette

#### Pause if other plots follow
if(flg2d>=1) pause mouse key "Press any key to proceed to 2D charts (will terminate zooming)\n"
