#### Solar System 3D plotting script for GNUPLOT 4.4 or higher
#### N-Body data are from DE405 ephemerides documentation
#### http://iau-comm4.jpl.nasa.gov/de405iom/
#### and locally integrated with a high-precision Bulirsh-Stoer
#### integration scheme.
reset
strgterm='x11' # Mac, Linux; fast
#strgterm='wxt' # multi-platform; slow
########################
flgstyle  = 1 #0: standard colors (all), 1: for black background (X11; see README)
flgcolmg  = 0 #1: use colormanager (external script), 0: don't use it
flgborder = 1 #0: unset border+tics for space view (not for sky globe and sky chart)
flggrid   = 0 #1 for major, 2 for major+minor; <0 to enable for aligned skyglobe, too
flgrotgrid= 1 #1 rotate grid to ecliptic
flgpobs   = 1 #1 to enable observer's planet (master to flgrose and flgsurf;<0 for free space)
flgsurf   = 2 #1 for major, 2 for major+minor; <0 to enable for free space, too.
flgrose   = 1 #1 enable surface compass rose; <0 to enable for aligned skyglobe, too
flg3d     = 1 #1 enable 3D space plots
flgsky    = 1 #1 enable skyglobe plots
flg2d     = 0 #1 load 2D plots at the end of this file
flgstars  = 0 #1 show nearby stars (>=1 for space view, >=2 for sky globe & chart)
########################
flgglobe  =-2  # ||>=1 enable globe grid, ||>=2 for minor lines (slow!), <0 for az-alt
degglobelat1 = 30.; mglobelat=3 # degrees
degglobelon1 = 45.; mglobelon=3 # degrees
globeddeglat = degglobelat1/mglobelat  # sample stepsize for globe grid
globeddeglon = degglobelon1/mglobelon
flgwin       = 3 #1 enable window field of view, >=2 for heading ray, >=3 for corner rays
#### Grid linestyles
lsgrid1 =2; lsgrid2 =4 # grid linestyles
lspolar1=1; lspolar2=2 # surface linestyles
lsglobe1=3; lsglobe2=4 # globe linestyles
lshead=13; lsfov=14    # Field of view linestyles
########################
#### Params
#latitude=50.71; longitude=7.12 # Bonn, Wasserland
latitude=50.730; longitude=7.069 # Bonn, AIfA
#latitude=54.6; longitude=9.0 # Breklum
#latitude=53.381; longitude=-1.486 #Sheffield
#latitude=28.09; longitude=-16.74 # Iberostar-Hotel, Teneriffa
#latitude=48.87; longitude=8.44 # Marxzell-Burbach, Germany
## Window field of view
## View heading in degrees, window dimensions, observer position 
## and eye dist arbitrary units (aligned skyglobe only)
#heading=0; winh=1.; winv=1.; wtilt=0.; xwin=0.5; ywin=0.5; dwin=1.0
#heading=237.2; winh=0.83; winv=0.70; wtilt=0.; xwin=0.5*winh; ywin=0.2;dwin=0.3         # Observer's window SW, closed
#heading=237.2; winh=0.95; winv=0.81; wtilt=0.; xwin=0.5*winh; ywin=0.2;dwin=0.3         # Observer's window SW, open
#heading=147.2; winh=0.39; winv=0.79; wtilt=62.6; xwin=0.5*winh; ywin=0.50*winv;dwin=0.2 # Observer's window SE
#heading=176.0; winh=3.85; winv=1.53; wtilt=0.; xwin=0.5*winh; ywin=0.30*winv;dwin=0.5   # Another observer's window, S
heading=226.5; winh=3.02; winv=1.61; wtilt=0.; xwin=0.55; ywin=0.25;dwin=0.80            # AIfA South-West office
#heading=226.5; winh=3.02; winv=1.61; wtilt=0.; xwin=1.00; ywin=0.10;dwin=0.60            # AIfA South-West office, screen
#heading=226.5; winh=3.02; winv=1.61; wtilt=0.; xwin=2.30; ywin=0.10;dwin=0.60            # AIfA South-West office, 2nd
#heading=226.5; winh=3.02; winv=1.61; wtilt=0.; xwin=2.20; ywin=-.30;dwin=0.60            # AIfA South-West office, 2nd table
#heading=226.5; winh=3.02; winv=1.61; wtilt=0.; xwin=3.02; ywin=0.00;dwin=0.1            # AIfA South-West office, NW Wall
#heading=226.5; winh=3.02; winv=1.61; wtilt=0.; xwin=0.00; ywin=0.00;dwin=0.10            # AIfA South-West office, SE Wall
## Optional time adjustment: Will overrun sidate settings.
flglocadj=0     # enable for local time adjustment (<=0: use sidate.aux only)
locadj=15.52 ; toffadj=2. ## replacements for loctime and toffset if flglocadj>0
#latitude=23.44;locadj=12.;toffadj=0.#testing
icen0=25;icen1=3
#### Zoom
## For Mm
#s=1000. ; r=5.0*s #; icen0=25
#s=50.   ; r=4.0*s #; icen0=3
#s=0.5   ; r=4.0*s #; icen0=3
## For AU
#s=0.250e6; r=8.0*s #; icen0=25
#s=200.  ; r=5.0*s #; icen0=25
#s=100.  ; r=9.3*s #; icen0=25
s=10.   ; r=10.0*s #; icen0=25
#s=5.    ; r=10.0*s #; icen0=25
#s=2.    ; r=5.0*s #; icen0=25
#s=1.    ; r=10.0*s #; icen0=25
#s=0.5   ; r=12.0*s #; icen0=25
#s=0.001 ; r=2.8*s #; icen1=3
#### Center selection
cx=3*icen0-1;cy=3*icen0;cz=3*icen0+1
load 'columns.gp'
print 'Central Object (long range) # = ',icen0
print 'Central Object (yhort range) # = ',icen1
#print 'cx,cy,cz = ',cx,cy,cz########################
#### Data File selection ####
#pathfile='si_xyz.out'              # 1-day resolution 1900-2200 (slow!)
pathfilex='solxyz100.0day.asc'      # 0.1-day resolution 1000 days from 2010
pathfile0='solxyz1000day.asc'       # 1-day resolution 1000 days from 2010
pathfile1='solxyz2000-2060d010.asc' # 10-day resolution 2000-2060
pathfile2='solxyz2000-2600d100.asc' # 100-day resolution 2000-2600
pathfile3='solxyz13700d1000.asc' #1000-day resolution 13700 yr (for Sedna)
pointfile='sidate.xyz'#sidatepicker.f output
starfile='near50sol3d.asc' # all stars within 20 ly, brightst within 50 ly
#starfile='test.asc' #some selected stars only
########################
xpix1=750;  ypix1=xpix1 #3D plots & sky globe
xpix2=1200; ypix2=600 #Azimuth chart (in '2dplots4sol3d.gp')
xpix3=1000; ypix3=720 #Polar chart (in '2dplots4sol3d.gp')
kzoom=1.25
set term strgterm 1 close; set term strgterm 2 close; set term strgterm 3 close
set term strgterm 1 title "Solar System 3D View" size xpix1,ypix1# position 0,0
set xyplane 0
set view equal xyz
#set view 60,30,kzoom
#set view 0,0,2.e6
set view 0,0,1000.
set view 0,0,kzoom
########################
lwscal=0.5
pscal=2.; ppwr=0.1
load 'psizes.gp'
########################
h2r=0.261799387799149437
d2r=0.0174532925199432958
r2d=57.2957795130823209
pc2au=206264.80624548030955
au2km=1.49597870691e8
rearthkm=6371.
rearth=rearthkm/au2km
########################
## Run date picker program (optional)
!sidate.x
load 'uvecs.aux'
load 'sidate.aux'
load 'sidate.tab'
load 'divfuncs.gp'
Narr=1
#### Calculations
if(flgpobs==0) flgsurf=0;flgrose=0
beta=latitude*d2r
dtlong=longitude/15.
#print 'dtlong/h =',dtlong
if (flglocadj>0) loctime=locadj;toffset=toffadj;utc=loctime-toffset
ltmean=utc+dtlong
lambda=ltmean*h2r+phis+9.9*d2r# local time + calendar phase (Jan 1 = 0) + diff to winter solstice
#print 'phis  =',phis*r2d
#print 'ltmean=',ltmean
#### Local normal vector
xpu0=cos(lambda)*cos(beta); ypu0=sin(lambda)*cos(beta); zpu0=sin(beta)
xpe0=-sin(lambda); ype0=cos(lambda); zpe0=0.
xpn0=-cos(lambda)*sin(beta); ypn0=-sin(lambda)*sin(beta); zpn0=cos(beta)
xpu=xpu0*e1x+ypu0*e2x+zpu0*e3x; ypu=xpu0*e1y+ypu0*e2y+zpu0*e3y; zpu=xpu0*e1z+ypu0*e2z+zpu0*e3z
xpe=xpe0*e1x+ype0*e2x+zpe0*e3x; ype=xpe0*e1y+ype0*e2y+zpe0*e3y; zpe=xpe0*e1z+ype0*e2z+zpe0*e3z
xpn=xpn0*e1x+ypn0*e2x+zpn0*e3x; ypn=xpn0*e1y+ypn0*e2y+zpn0*e3y; zpn=xpn0*e1z+ypn0*e2z+zpn0*e3z
#### Geovector
xgeo=rearth*xpu;ygeo=rearth*ypu;zgeo=rearth*zpu
fxgeo(x)=x-xgeo;fygeo(y)=y-ygeo;fzgeo(z)=z-zgeo
########################
#### Sun altitude
load 'rotfuncs.gp'
load 'anglefuncs_rad.gp'
#xs2e=obj16x-obj03x;ys2e=obj16y-obj03y;zs2e=obj16z-obj03z
xs2e=obj25x-obj03x;ys2e=obj25y-obj03y;zs2e=obj25z-obj03z
rs2e=fr(xs2e,ys2e,zs2e)
#ss2e=(xs2e*xpu+ys2e*ypu+zs2e*zpu)/rs2e
thsol=fcth(xs2e,ys2e,zs2e)
phsol=fcph(xs2e,ys2e,zs2e)
#print 'ss2e =',ss2e
#thsol=acos(ss2e)
#thsol=fcth
print sprintf("Sun altitude = %6.2f deg",thsol*r2d)
print sprintf("Sun azimuth  = %6.2f deg",phsol*r2d)
########################
if(flgrotgrid<=0) ep1x=1.;ep1y=0.;ep1z=0.;ep2x=0.;ep2y=1.;ep2z=0.;ep3x=0.;ep3y=0.;ep3z=1.
#print 'ep1 =',ep1x,ep1y,ep1z
#print 'ep2 =',ep2x,ep2y,ep2z
#print 'ep3 =',ep3x,ep3y,ep3z
#print 'pe =',xpe,ype,zpe
#print 'pn =',xpn,ypn,zpn
#print 'pu =',xpu,ypu,zpu
########################
#palettefile='hrdspectr.rgb' ; cgamma=1.0 # illustrative
## Realistic star colors (whitepoint 6500, 7500 and 10000 K, respectively).
#palettefile='hrdspectr065.rgb' ; cgamma=2.0 #cgamma ignored if colormanager is used
palettefile='hrdspectr075.rgb' ; cgamma=2.0
#palettefile='hrdspectr100.rgb' ; cgamma=2.0
if(flgstyle<=0) load 'styles.gp'
if(flgstyle>=1) load 'nightstyles.gp' # for black background
set size ratio -1.
unset grid
unset zeroaxis
set key at screen 0.96, screen 0.99 spacing 1.5 tc rgb rgbtclb
########################
#### Axis units and labels
#r=2.0
ru=1.; set xlabel "x / AU" tc rgb rgbtclb; set ylabel "y / AU" tc rgb rgbtclb; set zlabel "z / AU" tc rgb rgbtclb
#ru=1.49597870691e2; set xlabel "x / Mm" tc rgb rgbtclb; set ylabel "y / Mm" tc rgb rgbtclb; set zlabel "z / Mm" tc rgb rgbtclb
#r=r*ru
########################
set xrange [-r:r];set yrange [-r:r];set zrange [-r:r]
#set yrange [-5:6]
dr=1.*s
nmtics=5
Nr1=2*int(r/dr+0.01)
Nr2=2*int(nmtics*r/dr+0.01)
rn1=dr*(Nr1/2)
rn2=dr*(Nr2/2)/nmtics
#print 'Nr1 = ',Nr1
#print 'Nr2 = ',Nr2
#print 'rn1 = ',rn1
#print 'rn2 = ',rn2
set xtics dr; set ytics dr; set ztics dr
set mxtics nmtics; set mytics nmtics; set mztics nmtics
########################
#### Planetary Spin Axis
kr=0.6*r;lr=0.65*r
if(flgpobs<=-1) set arrow Narr from -kr*e3x,-kr*e3y,-kr*e3z to kr*e3x,kr*e3y,kr*e3z ls 5;Narr=Narr+1
if(flgpobs<=-1) set label 1 'P' at lr*e3x,lr*e3y,lr*e3z tc rgb rgbpole
#### Surface compass rose
## North = Green, East = Red, Upwards = Blue
kr=0.5*r;lr=0.55*r
if(flgrose<=-1) set arrow Narr from 0,0,0  to kr*xpe,kr*ype,kr*zpe ls 6;Narr=Narr+1
if(flgrose<=-1) set arrow Narr from 0,0,0  to kr*xpn,kr*ypn,kr*zpn ls 7;Narr=Narr+1
if(flgrose<=-1) set arrow Narr from 0,0,0  to kr*xpu,kr*ypu,kr*zpu ls 8;Narr=Narr+1
if(flgrose<=-1) set label 2 'N' at lr*xpn,lr*ypn,lr*zpn tc rgb rgbnorth
if(flgrose<=-1) set label 3 'E' at lr*xpe,lr*ype,lr*zpe tc rgb rgbeast
if(flgrose<=-1) set label 4 'Z' at lr*xpu,lr*ypu,lr*zpu tc rgb rgbupwd
#### Other labels
if (flglocadj>0) loc_hh=int(loctime);loc_mm=int(60.*(loctime-loc_hh));loc_ss=int(60.*(60.*(loctime-loc_hh)-loc_mm))
if (flglocadj>0) utc_hh=int(utc);utc_mm=int(60.*(utc-utc_hh));utc_sec=int(60.*(60.*(utc-utc_hh)-utc_mm))
latdeg=int(latitude);latmin=int(60.*(latitude-latdeg));latsec=int(60.*(60.*(latitude-latdeg)-latmin))
londeg=int(longitude);lonmin=int(60.*(longitude-londeg));lonsec=int(60.*(60.*(longitude-londeg)-lonmin))
loc_mm=abs(loc_mm);loc_ss=abs(loc_ss);utc_mm=abs(utc_mm);utc_ss=abs(utc_ss)
latmin=abs(latmin);latsec=abs(latsec);lonmin=abs(lonmin);lonsec=abs(lonsec)
set label 5 sprintf("Local = %04d-%02d-%02d %02d:%02d:%02d\n  UTC = %04d-%02d-%02d %02d:%02d:%02d\n Lat. =%3d%c %02d%c %02d%c\n Lon. =%3d%c %02d%c %02d%c",\
    loc_yr,loc_mo,loc_dd,loc_hh,loc_mm,loc_ss,utc_yr,utc_mo,utc_dd,utc_hh,utc_mm,utc_ss,latdeg,176,latmin,39,latsec,34,londeg,176,lonmin,39,lonsec,34)\
    at screen 0.02, screen 0.98 tc rgb rgbtclb

#### Polar Grid
N=12#dummy
xref=0.;yref=0.;zref=0.#set to zero if graph is centered on target
fx(x)=r*cos(pi/N*x);fy(x)=r*sin(pi/N*x)
#fx0(x)=xref-fx(x); fx1(x)=xref+fx(x); fy0(x)=yref-fy(x); fy1(x)=yref+fy(x)
fx0(x)=xref-fx(x)*xpe-fy(x)*xpn;fx1(x)=xref+fx(x)*xpe+fy(x)*xpn
fy0(x)=yref-fx(x)*ype-fy(x)*ypn;fy1(x)=yref+fx(x)*ype+fy(x)*ypn
fz0(x)=zref-fx(x)*zpe-fy(x)*zpn;fz1(x)=yref+fx(x)*zpe+fy(x)*zpn
#N=6 #for 30 deg grid
N=36# 5 degrees
if(flgsurf<=-2) set for [i=1:N] arrow i+Narr from fx0(i),fy0(i),fz0(i) to fx1(i),fy1(i),fz1(i) ls lspolar2 nohead back
if(flgsurf<=-2) Narr=Narr+N
N=4 # 45 degrees
if(flgsurf<=-1) set for [i=1:N] arrow i+Narr from fx0(i),fy0(i),fz0(i) to fx1(i),fy1(i),fz1(i) ls lspolar1 nohead back
if(flgsurf<=-1) Narr=Narr+N
#### Rectangular Grid Params
Nmajor=Nr1
Nminor=Nr2
zoffset=0.
#zoffset=-r
fn1(x)=rn1*(2./Nr1*x-1.)
fn2(x)=rn2*(2./Nr2*x-1.)
fx0(x)=-r*ep1x+fn2(x)*ep2x+zoffset*ep3x;fx1(x)=r*ep1x+fn2(x)*ep2x+zoffset*ep3x;fx2(x)=fn2(x)*ep1x-r*ep2x+zoffset*ep3x;fx3(x)=fn2(x)*ep1x+r*ep2x+zoffset*ep3x
fy0(x)=-r*ep1y+fn2(x)*ep2y+zoffset*ep3y;fy1(x)=r*ep1y+fn2(x)*ep2y+zoffset*ep3y;fy2(x)=fn2(x)*ep1y-r*ep2y+zoffset*ep3y;fy3(x)=fn2(x)*ep1y+r*ep2y+zoffset*ep3y
fz0(x)=-r*ep1z+fn2(x)*ep2z+zoffset*ep3z;fz1(x)=r*ep1z+fn2(x)*ep2z+zoffset*ep3z;fz2(x)=fn2(x)*ep1z-r*ep2z+zoffset*ep3z;fz3(x)=fn2(x)*ep1z+r*ep2z+zoffset*ep3z
gx0(x)=-r*ep1x+fn1(x)*ep2x+zoffset*ep3x;gx1(x)=r*ep1x+fn1(x)*ep2x+zoffset*ep3x;gx2(x)=fn1(x)*ep1x-r*ep2x+zoffset*ep3x;gx3(x)=fn1(x)*ep1x+r*ep2x+zoffset*ep3x
gy0(x)=-r*ep1y+fn1(x)*ep2y+zoffset*ep3y;gy1(x)=r*ep1y+fn1(x)*ep2y+zoffset*ep3y;gy2(x)=fn1(x)*ep1y-r*ep2y+zoffset*ep3y;gy3(x)=fn1(x)*ep1y+r*ep2y+zoffset*ep3y
gz0(x)=-r*ep1z+fn1(x)*ep2z+zoffset*ep3z;gz1(x)=r*ep1z+fn1(x)*ep2z+zoffset*ep3z;gz2(x)=fn1(x)*ep1z-r*ep2z+zoffset*ep3z;gz3(x)=fn1(x)*ep1z+r*ep2z+zoffset*ep3z
N0=Narr+1; N1=N0+Nminor+1; N2=N1+Nminor+1; N3=N2+Nmajor+1; N4=N3+Nmajor+1
N=Nminor
if(abs(flggrid)>=2) set for [i=0:N] arrow i+N0 from fx0(i),fy0(i),fz0(i) to fx1(i),fy1(i),fz1(i) ls lsgrid2 nohead# back #1 to Nminor+1
if(abs(flggrid)>=2) set for [i=0:N] arrow i+N1 from fx2(i),fy2(i),fz2(i) to fx3(i),fy3(i),fz3(i) ls lsgrid2 nohead# back #1 to Nminor+1
N=Nmajor
if(abs(flggrid)>=1) set for [i=0:N] arrow i+N2 from gx0(i),gy0(i),gz0(i) to gx1(i),gy1(i),gz1(i) ls lsgrid1 nohead# back #1 to Nminor+1
if(abs(flggrid)>=1) set for [i=0:N] arrow i+N3 from gx2(i),gy2(i),gz2(i) to gx3(i),gy3(i),gz3(i) ls lsgrid1 nohead# back #1 to Nminor+1

#### Definitions for nearby star plots
sclps=0.5
minps=0.1
pwrps=0.25
disc(x)=sclps*10.**(-0.4*pwrps*(x-4.83))
psize(x)=disc(x)<minps ? minps : disc(x)
set cbrange [0:9]; unset colorbox

if(flg3d<=0&&flgsky<=0&&flg2d<=0) print 'No plots active (gonna waste some time?)'
#### 3D Plots
if(flg3d>=1) load '3dcharts4sol3d.gp'
#### Redefine columns for geocentric plots
if(flgsky>=1||flg2d>=1) cx=3*icen1-1;cy=3*icen1;cz=3*icen1+1
#### Skyglobe Plots
if(flgsky>=1) load 'skyglobe4sol3d.gp'
#### 2D Plots (Azimuth vs. Altitude)
if(flg2d>=1) load '2dcharts4sol3d.gp'
