!**** COORDINATE TRANSFORMATION SPHERICAL VS. CARTESIAN ****

      SUBROUTINE sph2ct(r,theta,phi,x,y,z)
!---- Spherical to Cartesian coordinates (theta from pole)
      IMPLICIT NONE
      DOUBLE PRECISION r,phi,theta,x,y,z
      x = r*cos(phi)*sin(theta)
      y = r*sin(phi)*sin(theta)
      z = r*cos(theta)
      RETURN
      END

      SUBROUTINE ct2sph(x,y,z,r,theta,phi)
!---- Cartesian to Spherical coordinates (theta from pole)
      IMPLICIT NONE
      DOUBLE PRECISION r,rho,phi,theta,x,y,z,xn
      r    = sqrt(x*x+y*y+z*z)
      rho  = sqrt(x*x+y*y)
      theta= acos(z/r)
      IF (rho.gt.0.d0) THEN
         xn   = max(min(x/(rho),1.d0),-1.d0)
      ELSE
         xn   = 0.d0
      ENDIF
      phi  = acos(xn)*sign(1.d0,y)
      RETURN
      END
