      SUBROUTINE vxrot(vec0,vec1,phi)
!---- Drehung um x-Achse
      IMPLICIT NONE
      DOUBLE PRECISION vec0(1:3),vec1(1:3),phi,c,s
      c = cos(phi)
      s = sin(phi)
      vec1(1) =   vec0(1)
      vec1(2) =             c*vec0(2) - s*vec0(3)
      vec1(3) =             s*vec0(2) + c*vec0(3)
      RETURN
      END

      SUBROUTINE vyrot(vec0,vec1,phi)
!---- Drehung um y-Achse
      IMPLICIT NONE
      DOUBLE PRECISION vec0(1:3),vec1(1:3),phi,c,s
      c = cos(phi)
      s = sin(phi)
      vec1(1) = c*vec0(1)           + s*vec0(3)
      vec1(2) =             vec0(2)
      vec1(3) =-s*vec0(1)           + c*vec0(3)
      RETURN
      END

      SUBROUTINE vzrot(vec0,vec1,phi)
!---- Drehung um z-Achse
      IMPLICIT NONE
      DOUBLE PRECISION vec0(1:3),vec1(1:3),phi,c,s
      c = cos(phi)
      s = sin(phi)
      vec1(1) = c*vec0(1) - s*vec0(2)
      vec1(2) = s*vec0(1) + c*vec0(2)
      vec1(3) =                         vec0(3)
      RETURN
      END
