      SUBROUTINE finddst(yr,JDdst0,JDdst1,mode)
!==== Detect begin and end of the Central European
!     daylight saving time
      IMPLICIT NONE
      INTEGER mode,i
      INTEGER yr,mar,oct,dd,dow
      INTEGER hh,mm,ss
      DOUBLE PRECISION JD,JDdst0,JDdst1
      CHARACTER*3 cdow
      LOGICAL found0,found1
      DATA mar,oct,hh,mm,ss/3,10,2,0,0/
!     DAT2JD(yr,mo,dd,hh,mm,ss,mode,JD)
!     JD2DOW(JD,dow,cdow,mode,lang)
      found0=.FALSE.
      found1=.FALSE.
      DO i=31,1,-1
         dd=i
!---- DST begin
         CALL DAT2JD(yr,mar,dd,hh,mm,ss,mode,JD)
         CALL JD2DOW(JD,dow,cdow,mode,0)
         IF (dow.EQ.0.AND..NOT.found0) THEN
            JDdst0=JD
            found0=.TRUE.
!            write(*,1000) 'DST 0',yr,mar,dd
         ENDIF
!---- DST end
         CALL DAT2JD(yr,oct,dd,hh,mm,ss,mode,JD)
         CALL JD2DOW(JD,dow,cdow,mode,0)
         IF (dow.EQ.0.AND..NOT.found1) THEN
            JDdst1=JD
            found1=.TRUE.
!            write(*,1000) 'DST 1',yr,oct,dd
         ENDIF
!---- Finish
         IF (found0.AND.found1) EXIT
      ENDDO
 1000 FORMAT(A,': YYYY-MM-DD = ',I4.4,2('-',I2.2))
      RETURN
      END

      SUBROUTINE getdst(JD,flgdst,mode)
      IMPLICIT NONE
      INTEGER yr,mo,dd,hh,mm,ss,mode,flgdst
      DOUBLE PRECISION JD
      DOUBLE PRECISION JDdst0,JDdst1
      SAVE JDdst0,JDdst1
      LOGICAL skipcalc
      COMMON /caldst/ skipcalc
!      DATA skipcalc/.FALSE./
      IF (.NOT.skipcalc) THEN
         CALL JD2DAT(JD,yr,mo,dd,hh,mm,ss,mode)
         CALL finddst(yr,JDdst0,JDdst1,mode)
      ENDIF
      IF (JD.GT.JDdst0.AND.JD.LE.JDdst1) THEN
         flgdst=1
      ELSE
         flgdst=0
      ENDIF
!      write(*,*) 'skipcalc =',skipcalc
!      WRITE(*,*) 'JD,JDdst0,JDdst1 =',JD,JDdst0,JDdst1,flgdst
!      stop
      RETURN
      END
