!    SUNPATH CALCULATOR
!    Copyright (C) 2011-2013 by Ingo Thies
!
!    SunPlot is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 2 of the License, or
!    (at your option) any later version.
!
!    SunPlot is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with SunPlot. If not, see <http://www.gnu.org/licenses/>.
!
!    This license applies to this main source file and to all related
!    source files in this package.
!
PROGRAM plotsunpath
  USE sunpath_core
  USE sunpath_constants, ONLY : d2r,illum_const
  USE sundawn_module,    ONLY : flgref,alt_rim,aazim,alt_culmination,alt_culmrefr,alt_min,alt_probe
  IMPLICIT NONE
  INTEGER :: i,j,n,ifound(0:12),flgdate,poi,idum,flgtable
  INTEGER :: yr,mo,dd,hh,mm,ss,values(8),dyr
  INTEGER :: yr0,mo0,dd0,yr1,mo1,dd1,flgdst,kdst,dow,dtdow,flgdow,idow
  INTEGER :: ddprev=0,moprev=0,maxlinespertable=27,maxlinespertable7=53,lineoftable,lineoftable7
  REAL(KIND=8) :: t,t0,t1,dt,timezone,thoff,JDstart,JDend,JDref,JDnoon,dst,dummy
  REAL(KIND=8) :: diff_mean_zone,poi_lat,poi_lon,poi_ltc,poi_dst,poi_elv
  REAL(KIND=8) :: tsun(0:12),th(0:12),tsec(0:12),alt_use,dtsh(1:2)
  REAL(KIND=8) :: h4xair,xair,eta(0:11),etag(0:11),etad(0:11),diffuse(0:11),illum(0:11),illum_lux(0:11),&
       ilnorm(0:11),ilnorm_lux(0:11),ildirect(0:11),ildirect_lux(0:11),sinalt!,trise,tculm,ttrans,tset,
  REAL(KIND=8) :: dmr1,dmr2,dmr3,cct0=5932.d0,cct1,cct2,cct3,illum_extr_lux,rscale=1.d0
  CHARACTER (LEN=11) :: thms
  CHARACTER (LEN=8) :: hhmmss(0:12)
  CHARACTER (LEN=50) :: name_poi,poifile
  CHARACTER (LEN=3) :: cdow
  LOGICAL :: usedst,newmonth,newtable,newtable7,usealtprobe
  LOGICAL :: founddow,rightdow,usedtdow,last7=.FALSE.
  SAVE ddprev,moprev
  timezone=1.d0
  OPEN(10,FILE='sunpath.par')
  READ(10,*) latitude,longitude,poi
  READ(10,*) 
  READ(10,*) yr,mo,dd
  READ(10,*) dummy,timezone,dst
  READ(10,*) flgref
  READ(10,*) alt_rim,z_surface
  READ(10,*) 
  READ(10,*) yr0,mo0,dd0,flgdate
  READ(10,*) yr1,mo1,dd1
  READ(10,*) dt,flgdow,flgdst
  READ(10,*) dtsh(1),dtsh(2),alt_probe
  READ(10,*)
  READ(10,*) poifile
  CLOSE(10)
  IF (poi>=1) THEN
     print *,'file = "',trim(poifile),'"'
     OPEN(12,FILE=trim(poifile),STATUS='OLD')
     DO i=1,poi+1!skip text header and proceed to poi'th point of interest
        READ(12,*,end=1,err=1)
     ENDDO
     READ(12,*,end=1,err=1) idum,poi_lat,poi_lon,poi_ltc,poi_dst,poi_elv,name_poi
     GOTO 2
1    WRITE(*,*) 'POI not available (end of file?)'
     WRITE(*,*) 'Using manual input instead.'
     GOTO 3
2    latitude=poi_lat
     longitude=poi_lon
     timezone=poi_ltc
     dst=poi_dst
     IF (z_surface<0.d0) THEN
        z_surface=poi_elv
        PRINT *,'Using elevation from POI table:',nint(poi_elv),' m'
     ELSE
        PRINT *,'Using elevation from user input.'
     ENDIF
     WRITE(*,'(2A)') 'Using Point of Interest: ',trim(name_poi)
     WRITE(*,'(A,2(F9.4,A))') 'at lat,lon = ',poi_lat,' deg N, ',poi_lon,' deg E'
!     WRITE(*,*) 'Using Point of Interest at lat,lon =',poi_lat,poi_lon
3    CLOSE(12)
  ELSE
     name_poi='User-defined'
  ENDIF
  usedtdow=flgdow>0.AND.flgdow<=7
  usealtprobe=alt_probe<0.d0
  dtsh(1)=-dtsh(1)/6.d1
  dtsh(2)= dtsh(2)/6.d1
!  CALL inpar(latitude,longitude,poi,flgdate,yr,mo,dd.
  hh=0;mm=0;ss=0
  usedst=flgdst>=1
  IF (flgdate<=1) THEN
     IF (flgdate<=0) THEN
        CALL Date_and_Time(values=values)
        yr=values(1)
        mo=values(2)
        dd=values(3)
        yr0=yr
     ENDIF
     yr1=yr0+1
     mo0=1
     dd0=1
     mo1=mo0
     dd1=dd0
  ENDIF
  WRITE(*,'(A,I4.4,2(''-'',I2.2))') 'YYYY,MM,DD: ',yr0,mo0,dd0
  WRITE(*,'(A,I4.4,2(''-'',I2.2))') 'YYYY,MM,DD: ',yr1,mo1,dd1
  CALL DAT2JD(yr0,mo0,dd0,00,00,00,0,JDstart)
  CALL DAT2JD(yr1,mo1,dd1,00,00,00,0,JDend)
  print *,'JDstart=',JDstart
  print *,'JDend  =',JDend
  IF (usedtdow) THEN
     dt=1!scan all dates but skip all wrong DOW
!....re-adjust to JD2DOW (Monday=0)
     dtdow=mod(flgdow,7)
     write(*,*) 'dtdow =',dtdow
  ENDIF
  n=int((JDend-JDstart)/dt)
  OPEN(18,FILE='sunplot.aux.gp')
  OPEN(20,FILE='suntimes.out')
  OPEN(21,FILE='sunazims.out')
  OPEN(22,FILE='sunalt.out')
  OPEN(23,FILE='suneot.out')
!  OPEN(24,FILE='sunubv.out')
  OPEN(25,FILE='suncct.out')
  OPEN(30,FILE='suntimes.tex')
  IF (.not.usedtdow) OPEN(32,FILE='shabbat.tex')
!  set xrange ["2010-01-01":"2011-01-01"]
  WRITE(18,'(3A)') 'strg_poi="',trim(name_poi),'"'
  WRITE(18,'(A,F9.4,'' N, '',F9.4,'' E'',A)') 'strg_geo="',latitude,longitude,'"'
  WRITE(18,'(A,I4.4,2(''-'',I2.2),A)') 'strg_tmin="',yr0,mo0,dd0,'"'
  WRITE(18,'(A,I4.4,2(''-'',I2.2),A)') 'strg_tmax="',yr1,mo1,dd1,'"'
  WRITE(18,'(A,I4)') 'ndays=',n
  WRITE(18,'(A,2(I4.4,2(''-'',I2.2),A))') 'set xrange ["',yr0,mo0,dd0,'":"',yr1,mo1,dd1,'"]'
  CLOSE(18)
  WRITE(*,1010) 'YYYY-MM-DD','hmin','dawn_a','dawn_n','dawn_c','rise','culm','trans','set','dusk_c','dusk_n','dusk_a'
  WRITE(20,'(A)') '# Times / hours'
  WRITE(20,1010) 'YYYY-MM-DD','hmin','dawn_a','dawn_n','dawn_c','rise','culm','trans','set','dusk_c','dusk_n','dusk_a'
  WRITE(21,'(A)') '# Azimuth positions / degrees'
  WRITE(21,1010) 'YYYY-MM-DD','hmin','dawn_a','dawn_n','dawn_c','rise','culm','trans','set','dusk_c','dusk_n','dusk_a'
  WRITE(22,'(A)') '# Altitude / degrees'
  WRITE(22,1010) 'YYYY-MM-DD','alt_culm','alt_refr','alt_min'
  WRITE(23,'(A)') '# Equation of Time / minutes'
  WRITE(23,1020) 'YYYY-MM-DD','EoT','EoT-loc','Tculm-12h','Ttrans-12h','tmean-zone'
  WRITE(25,'(A)') '# Noon color temperature / kelvins, illumination / lux (global, tilted towards Sun)'
!  WRITE(25,1020) 'YYYY-MM-DD','direct+2.5','glo. tilt','glo. flat','All','U','B','V','R','I','u','g','r','i','z','UV'
  WRITE(25,1020) 'YYYY-MM-DD','direct+2.5','glo. tilt','glo. flat','Illum tilt','illum flat'
  lineoftable=0
  founddow=.false.
  idow=-99
  DO i=0,n
     JDref=JDstart+i*dt
     JDnoon=JDref+0.5d0
     idow=idow+1
     IF (idow>6) idow=idow-7
     rightdow= idow==0
     last7= rightdow.AND.n-i<7
 !    IF (usedtdow) write(*,*) 'i,idow,dtdow,cdow,rightdow,founddow = ',i,idow,dtdow,cdow,rightdow,founddow
     IF (usedtdow.AND.founddow.AND..NOT.rightdow) CYCLE
     CALL find_times(JDref,tsun,ifound)
     IF (usedst) THEN
        CALL getdst(JDref+0.1d0,kdst,0)!DST switches between 2 and 3am
     ELSE
        kdst=0
     ENDIF
     thoff=timezone+kdst*dst
     diff_mean_zone=longitude/15.d0-thoff
!     write(*,*) 'timezone,kdst,dst,thoff =',timezone,kdst,dst,thoff
     DO j=0,12
        IF (ifound(j)<=0) THEN
           th(j)=-1.d0
           aazim(j)=1.d0-12
        ELSE
           th(j)=24.d0*tsun(j)+timezone+kdst*dst
        ENDIF
     ENDDO
     CALL JD2DAT(JDref+(kdst*dst)/24.d0,yr,mo,dd,hh,mm,ss,0)
     CALL JD2DOW(JDref+(kdst*dst)/24.d0,dow,cdow,0,0)
     IF (usealtprobe) THEN
        dtsh(2)=th(12)-th(7)
!        write(*,*) 'mo,dd,th7,th12,dtsh =',mo,dd,th(7),th(12),dtsh(2)*6.d1
     ENDIF
     IF (dow==dtdow) THEN 
        idow=0
        IF (usedtdow) WRITE(*,*) '**** found DOW =',dow,' =',cdow
     ENDIF
     founddow= dow==dtdow .OR. founddow
!.... Peak colour temperature
     h4xair=alt_culmination
     CALL calc_airmass(h4xair,xair,eta,etag,etad)
     CALL calc_colortemp(xair,1,dmr1,cct0,cct1)!direct + 2.5deg
     CALL calc_colortemp(xair,2,dmr2,cct0,cct2)!global tilt
     CALL calc_colortemp(xair,3,dmr2,cct0,cct3)!global horiz
!.... Peak illumination
     CALL sun_distance(JDnoon,rscale)
     illum_extr_lux=illum_const/rscale**2
     sinalt=max(sin(alt_culmrefr*d2r),0.d0)
     DO j=0,11
!    Ground illumination: oblique incidence of direct light
!    plus indirect (scattered) light. (etag-eta = indirect)
        diffuse(j)=max(etag(j)-eta(j),0.d0)
!        illum(j)=eta(j)*sinalt+diffuse(j)*(1.d0+sinalt)/2.d0!old formula
        illum(j)=eta(j)*sinalt+diffuse(j)
        illum_lux(j)=illum_extr_lux*illum(j)
!    Normal illumination: normal indicende on tilted surface
        ilnorm(j)=etag(j)
        ilnorm_lux(j)=illum_extr_lux*ilnorm(j)
!    Normal illumination: normal indicende on tilted surface, direct 2.5 deg
        ildirect(j)=eta(j)
        ildirect_lux(j)=illum_extr_lux*ildirect(j)
     ENDDO
     WRITE(*,1000) yr,mo,dd,(th(j),j=0,10)
     WRITE(20,1000) yr,mo,dd,(th(j),j=0,10)
     WRITE(21,1005) yr,mo,dd,(aazim(j),j=0,10)
     WRITE(22,1025) yr,mo,dd,alt_culmination,alt_culmrefr,alt_min
     WRITE(23,1035) yr,mo,dd,eot_min,eot_min+6.d1*diff_mean_zone,6.d1*(th(5)-12.d0),6.d1*(th(6)-12.d0),&
          diff_mean_zone*6.d1
!     WRITE(25,1045) yr,mo,dd,cct1,cct2,cct3
!     WRITE(25,1046) yr,mo,dd,nint(cct1),nint(cct2),nint(cct3),(illum_lux(j),j=0,11)
     WRITE(25,1046) yr,mo,dd,nint(cct1),nint(cct2),nint(cct3),ildirect_lux(3),ilnorm_lux(3),illum_lux(3)!V-Band as visual approximation
     newmonth=mo/=moprev
     ddprev=dd
     moprev=mo
     newtable = (dd<=dt.AND.lineoftable>maxlinespertable).AND.i<n
     newtable7= (dd<=7.*dt.AND.lineoftable7>=maxlinespertable7).AND.i<n
     IF (i==0) THEN!begin of loop: openfirst table
        IF (usedtdow.AND..NOT.founddow) THEN
           flgtable=11
        ELSE
           flgtable=1
        ENDIF
        lineoftable =1!reset lines of table
        lineoftable7=1!reset lines of table weekly
     ELSE IF (newtable.AND.newtable7) THEN!new month: close previous table, open next
!     ELSE IF (dd==1.AND.mo/=2*(mo/2).AND.i<n) THEN!new 2-month: close previous table, open next
        flgtable=14
        lineoftable=1!reset lines of table
        lineoftable7=1!reset lines of table
     ELSE IF (newtable) THEN!new month: close previous table, open next
!     ELSE IF (dd==1.AND.mo/=2*(mo/2).AND.i<n) THEN!new 2-month: close previous table, open next
        flgtable=2
        lineoftable=1!reset lines of table
     ELSE IF (newtable7) THEN!new month: close previous table, open next
!     ELSE IF (dd==1.AND.mo/=2*(mo/2).AND.i<n) THEN!new 2-month: close previous table, open next
        flgtable=12
        lineoftable7=1!reset lines of table
     ELSE
        flgtable=0
        lineoftable=lineoftable+1!advance lines of table
        IF (dow==5) lineoftable7=lineoftable7+1
     ENDIF
     IF (i>0.AND.usedtdow.AND..not.founddow) CYCLE
     CALL write_table(30,32,name_poi,yr,mo,dd,th,dtsh,thoff,ifound,flgtable,&
          newmonth,usedtdow,dow,cdow,alt_probe,usealtprobe,last7)
  ENDDO
! flgtable=3 for finale
  CALL write_table(30,32,name_poi,yr,mo,dd,th,dtsh,thoff,ifound,3,&
       newmonth,usedtdow,dow,cdow,alt_probe,usealtprobe,last7)!end of loop: close last table
  CLOSE(20)
  CLOSE(21)
  CLOSE(22)
  CLOSE(23)
!  CLOSE(24)
  CLOSE(25)
  CLOSE(30)
  IF (.not.usedtdow) CLOSE(32)
1000 FORMAT(1X,I4.4,2('-',I2.2),2X,11(2X,F8.4))
1005 FORMAT(1X,I4.4,2('-',I2.2),2X,11(2X,F8.3))
1010 FORMAT('#',A10,2X,11(2X,A8))
1020 FORMAT('#',A10,2X,6(2X,A10),2X,12(2X,A10))
1025 FORMAT(1X,I4.4,2('-',I2.2),2X,4(2X,F8.3))
1035 FORMAT(1X,I4.4,2('-',I2.2),2X,6(2X,F10.2))
1045 FORMAT(1X,I4.4,2('-',I2.2),2X,3(6X,F6.0),2X,12(1X,1PE11.4))
1046 FORMAT(1X,I4.4,2('-',I2.2),2X,3(6X,I6),2X,12(1X,1PE11.4))
END PROGRAM plotsunpath

SUBROUTINE write_table(iu,ju,name_poi,yr,mo,dd,th,dtsh,thoff,ifound,flgtable, &
     newmonth,usedtdow,dow,cdow,alt_probe,usealtprobe,last7)
  IMPLICIT NONE
  INTEGER :: iu,ju,yr,mo,dd,flgtable,ifound(0:12),dow,i
  INTEGER :: dd_prev,mo_prev,yr_prev
  REAL(KIND=8) :: th(0:12),ts,thsh(1:2),dtsh(1:2),alt_probe,thoff
  LOGICAL :: newmonth,newmonth7,begintable,endtable,begintable7,endtable7,usedtdow,set_pre=.FALSE.
  LOGICAL :: usealtprobe,last7!,notutc
  CHARACTER(LEN=1) :: sg2utc
  CHARACTER(LEN=50) :: name_poi,closeheader
  CHARACTER(LEN=11) :: thms
  CHARACTER(LEN=8) :: hhmmss(0:12),hhmmss_prev(0:12)
  CHARACTER(LEN=5) :: hhmm(0:12),hhmm_prev(0:12)
  CHARACTER(LEN=3) :: month_short,cdow,monsh_prev
  CHARACTER(LEN=9) :: month_full
  CHARACTER(LEN=9),DIMENSION(1:12) :: month_names=&
  (/'January  ','February ','March    ','April    ','May      ','June     ',&
    'July     ','August   ','September','October  ','November ','December '/)
  SAVE newmonth7
  SAVE hhmmss_prev,hhmm_prev,monsh_prev,dd_prev,mo_prev,yr_prev
!  notutc=abs(thoff)>1.d-6
  IF (thoff<0.d0) THEN
     sg2utc='-'
  ELSE
     sg2utc='+'
  ENDIF
  begintable=flgtable==1.OR.flgtable==2.OR.flgtable==11.OR.flgtable==14
  begintable7=flgtable==1.OR.flgtable==12.OR.flgtable==14
  endtable=flgtable==2.OR.flgtable==14.OR.flgtable==3
  endtable7=flgtable==12.OR.flgtable==14.OR.flgtable==3
  month_full=trim(month_names(mo))
  month_short=month_full(1:3)
!  WRITE(*,*) 'yr,mo,dd,flgtable,b,b7,e,e7 =',yr,mo,dd,flgtable,begintable,begintable7,endtable,endtable7
  IF (endtable) THEN
     WRITE(iu,'(A)') '\hline\end{tabular}\end{center}\end{table}'
  ENDIF
  IF (endtable7.AND..not.usedtdow) THEN
     WRITE(ju,'(A)') '\hline\end{tabular}\end{center}\end{table}'
  ENDIF
  IF (begintable) THEN
     WRITE(iu,'(5A,I5,2A,I2.2,2A)') '\begin{table}',&
          '\centering{\Large Solar Times for ',trim(name_poi),&
!          ', ',trim(month_full),yr,'}',&
          ', ',trim(month_full),yr,' (UTC',sg2utc,nint(thoff),')}',&
          '\begin{center}'
     WRITE(iu,'(A)') '\begin{tabular}{|cl|ccc|ccc|ccc|}'
  ELSE IF (dow==0.and..not. endtable.and..not.usedtdow) THEN
     WRITE(iu,'(A)') '\hline'
  ENDIF
  IF (begintable7) THEN
     IF (.not.usedtdow) THEN
        WRITE(ju,'(4A,I5,2A)') '\begin{table}',&
          '\centering{\Large Shabbat Times for ',trim(name_poi),&
          ', ',yr,'}',&
          '\begin{center}\begin{tabular}{lr}'
        WRITE(ju,'(A,I3,A)') 'Candle lighting:&Friday evening, ',nint(-6.d1*dtsh(1)),&
             ' minutes before Sunset.\\'
        IF (usealtprobe) THEN
           WRITE(ju,'(A,F4.1,A)') 'End of Shabbat:&Saturday evening, Sun',-alt_probe,' deg. below horizon.'
        ELSE
           WRITE(ju,'(A,I3,A)') 'End of Shabbat:&Saturday evening, ',nint(6.d1*dtsh(2)),' minutes after Sunset.'
        ENDIF
        WRITE(ju,'(A)') '\end{tabular}\\[1.5ex]'
        WRITE(ju,'(A)') '\begin{tabular}{|c|cc||c|cc|}'
     ENDIF
!  ELSE IF (dow==6.and..not. endtable7.and..not.usedtdow) THEN
!     WRITE(ju,'(A)') '\hline'
  ENDIF
  IF (flgtable==3) RETURN!finish
  thsh(1)=th(7)+dtsh(1)!e.g. 18 minutes before sunset
  thsh(2)=th(7)+dtsh(2)!e.g. 48 minutes after sunset
! round to minutes
!  thsh(1)=aint(thsh(1)*6.d1)/6.d1
!  thsh(2)=aint(thsh(2)*6.d1+1.d0)/6.d1
  DO i=0,12
     IF (i<=10) THEN
        ts=3.6d3*th(i)
        IF (ifound(i)>0) THEN
           CALL t2hms(ts,thms)
        ELSE
           thms='    -----   '
        ENDIF
     ELSE
        ts=3.6d3*thsh(i-10)
        CALL t2hms(ts,thms)
     ENDIF
     hhmmss(i)=thms(4:11)
     hhmm(i)=thms(4:8)
  ENDDO
  IF (newmonth.OR.begintable) THEN
     WRITE(iu,'(A)') '\hline'
     IF (begintable) THEN
        WRITE(iu,5000) month_full,'Astr. Dawn','Naut. Dawn','Civil Dawn','Sunrise',&
       'Culmination','Sunset','Civil Dusk','Naut. Dusk','Astr. Dusk'
     ELSE
        WRITE(iu,5005) month_short,yr
     ENDIF
  ENDIF
  IF (newmonth7.OR.begintable7) THEN
!     write(*,*) 'last7 =',last7
     IF (.not.usedtdow.AND..not.last7) WRITE(ju,'(A)') '\hline'
     IF (begintable7.and..not.usedtdow) THEN
!       WRITE(ju,6000) month_full//', Friday','Candle lighting','Sunset',&
       WRITE(ju,6000) 'Friday','Candle lighting','Sunset',&
       'Saturday','Sunset','End of Shabbat'
!     ELSE IF (.not.usedtdow.AND..not.last7) THEN
!        WRITE(ju,6005) month_short,yr
     ENDIF
  ENDIF
  newmonth7=newmonth.AND..not.newmonth7!always 1 day delayed
  IF (flgtable==11) RETURN!skip line of dow is wrong
  WRITE(iu,5010) cdow,dd,hhmmss(1),hhmmss(2),hhmmss(3),hhmmss(4),hhmmss(5),hhmmss(7),hhmmss(8),hhmmss(9),hhmmss(10)
  IF (usedtdow) RETURN
  IF (dow==5) THEN
     set_pre=.TRUE.
     hhmmss_prev=hhmmss
     hhmm_prev=hhmm
     dd_prev=dd
     mo_prev=mo
     yr_prev=yr
     monsh_prev=month_short
  ELSE IF (dow==6.and.set_pre) THEN
!     WRITE(ju,6010) mo_prev,dd_prev,hhmm_prev(11),hhmmss_prev(7),mo,dd,hhmmss(7),hhmm(12)
     WRITE(ju,6010) monsh_prev,dd_prev,hhmm_prev(11),hhmmss_prev(7),month_short,dd,hhmmss(7),hhmm(12)
  ENDIF
  RETURN
5000 FORMAT('\multicolumn{2}{|c|}{',A9,'}',9('&',A11),'\\\hline')
5005 FORMAT(A3,'&',I4,9('&'),'\\')
5010 FORMAT(2X,A3,',&',I2.2,9('&',A11),'\\')
!6000 FORMAT(A10,5('&',A15),'\\\hline')
6000 FORMAT(A10,5('&',A15),'\\')
6005 FORMAT(A3,1X,I4,5('&'),'\\')
!6010 FORMAT(2X,I2.2,'-',I2.2, 2('&',A11),'&',2X,I2.2,'-',I2.2, 2('&',A11),'\\')
6010 FORMAT(2X,A3,1X,I2.2, 2('&',A11),'&',2X,A3,1X,I2.2, 2('&',A11),'\\')
END SUBROUTINE write_table
