      DOUBLE PRECISION FUNCTION simps1(func,x1,x2,dxi)
!---- Simpson's rule integration of function 'func' from x1 tio x2
!----        x1 = lower limit
!----        x2 = upper limit
!----   L x2-x1 = interval length
!----       dxi = input stepwidth
!---- dx <= dxi = used stepwidth (L/dx should be an integer)
      IMPLICIT NONE
      EXTERNAL func
      DOUBLE PRECISION func,x,x1,x2,Lx,h,dx,dxi,f1,f2,f3,Fpart
      DOUBLE PRECISION inf,htiny
      htiny = 1.d-10
      Lx = x2-x1
      inf = max(aint(Lx/dxi),1.d0)
!      write(6,'(F24.16)') Lx/dxi
      IF (inf .GE. Lx/dxi-htiny .OR. dxi .GE. Lx) THEN
         dx = Lx/inf
      ELSE
         dx = Lx/(inf+1.D0)
      ENDIF
      x = x1
      Fpart = 0.D0
!**** Integration loop
 100  CONTINUE
         h = min(dx,x2-x)
         f1 = func(x)
         f2 = func(x+h/2.D0)
         f3 = func(x+h)
         Fpart = Fpart + h*(f1/6.D0 + f2*2.D0/3.D0 + f3/6.D0)
         x = x + dx
      IF (x .LT. x2-h/2.D0) GOTO 100
!**** End of integration loop
!      write (6,*) Fpart
!      write (6,*) x1,x2,x-x2
!      write (6,*) dx
!      write (6,*) x
      simps1 = Fpart
      RETURN
      END

      DOUBLE PRECISION FUNCTION simps2(func,x1,x2,dxi)
!---- Simpson's rule integration of function 'func' from x1 tio x2
!----        x1 = lower limit
!----        x2 = upper limit
!----   L x2-x1 = interval length
!----       dxi = input stepwidth
!---- dx <= dxi = used stepwidth (L/dx should be an integer)
      IMPLICIT NONE
      EXTERNAL func
      DOUBLE PRECISION func,x,x1,x2,Lx,h,dx,dxi,f1,f2,f3,Fpart
      DOUBLE PRECISION inf,htiny
      htiny = 1.d-10
      Lx = x2-x1
      inf = max(aint(Lx/dxi),1.d0)
!      write(6,'(F24.16)') Lx/dxi
      IF (inf .GE. Lx/dxi-htiny .OR. dxi .GE. Lx) THEN
         dx = Lx/inf
      ELSE
         dx = Lx/(inf+1.D0)
      ENDIF
      x = x1
      Fpart = 0.D0
!**** Integration loop
 100  CONTINUE
         h = min(dx,x2-x)
         f1 = func(x)
         f2 = func(x+h/2.D0)
         f3 = func(x+h)
         Fpart = Fpart + h*(f1/6.D0 + f2*2.D0/3.D0 + f3/6.D0)
         x = x + dx
      IF (x .LT. x2-h/2.D0) GOTO 100
!**** End of integration loop
!      write (6,*) Fpart
!      write (6,*) x1,x2,x-x2
!      write (6,*) dx
!      write (6,*) x
      simps2 = Fpart
      RETURN
      END
