MODULE sundawn_module
  INTEGER :: flgref
  INTEGER,DIMENSION(0:12) :: iter
  REAL(KIND=8),DIMENSION(0:12) :: aazim,aaltitude,aaltrefract
  REAL(KIND=8) :: JD0h,alt_rim,alt_horiz,alt_culmination,alt_culmrefr,alt_min
  REAL(KIND=8),DIMENSION(0:3) :: alt_dawn=(/0.d0,-6.d0,-12.d0,-18.d0/)
  REAL(KIND=8) :: eps_culm,alt_probe=0.d0
  LOGICAL :: at_horizon
  CHARACTER(LEN=14),DIMENSION(0:12) :: time_label=(/ 'Min. Altitude ', &
  'astr. Dawn    ','Naut. Dawn    ','Civil Dawn    ','Sunrise       ', &
  'Culmination   ','Transit       ','Sunset        ',                  &
  'Civil Dusk    ','Naut. Dusk    ','Astr. Dusk    ',                  &
  'Probe a.m.    ','Probe p.m.    '/)
END MODULE sundawn_module

SUBROUTINE find_times(JD00,tsun,ifound)
  USE sunpath_core
  USE sundawn_module
  IMPLICIT NONE
  EXTERNAL f_alt,f_culm,f_trans
  REAL(KIND=8) :: f_alt,f_culm,f_trans
  REAL(KIND=8) :: JD00,tsun(0:12),t,t1,t2
  INTEGER :: j,ifound(0:12)
  REAL(KIND=8) :: epst,h0,dh
  epst=1.d0/dble(2**20)
  eps_culm=epst/4.d0
  JD0h=JD00
!  WRITE(*,*) 'JD00 =',JD00
!  WRITE(*,*) 'longitude,latitude =',longitude,latitude
! find lowest point
  at_horizon=.false.
  t1=-0.25d0-longitude/360.d0
  t2=0.25d0-longitude/360.d0
  CALL bisection(f_culm,t1,t2,epst,tsun(0),iter(0),ifound(0))
  aazim(0)=azimuth
  alt_min=altitude
  aaltitude(0)=altitude
  aaltrefract(0)=alt_refract
! find dawn, sunrise
  t1=0.d0-longitude/360.d0
  t2=0.5d0-longitude/360.d0
  DO j=1,4
     alt_horiz=alt_dawn(4-j)
     at_horizon=abs(alt_horiz)<1.d0
!     WRITE(*,*) 'alt_horiz,at_horizon =',alt_horiz,at_horizon
     CALL bisection(f_alt,t1,t2,epst,tsun(j),iter(j),ifound(j))
     aazim(j)=azimuth!get it from sunpath_core
     aaltitude(j)=altitude
     aaltrefract(j)=alt_refract
  ENDDO
! find culmination (max. altitude)
  at_horizon=.false.
  t1=0.25d0-longitude/360.d0
  t2=0.75d0-longitude/360.d0
  CALL bisection(f_culm,t1,t2,epst,tsun(5),iter(5),ifound(5))
  aazim(5)=azimuth
  alt_culmination=altitude
  alt_culmrefr=alt_refract
  aaltitude(5)=altitude
  aaltrefract(5)=alt_refract
! find meridian transit
  t1=0.25d0-longitude/360.d0
  t2=0.75d0-longitude/360.d0
  CALL bisection(f_trans,t1,t2,epst,tsun(6),iter(6),ifound(6))
  aazim(6)=azimuth
  aaltitude(6)=altitude
  aaltrefract(6)=alt_refract
! find sunset
  t1=0.5d0-longitude/360.d0
  t2=1.d0-longitude/360.d0
  DO j=7,10
     alt_horiz=alt_dawn(j-7)
     at_horizon=abs(alt_horiz)<1.d0
!     WRITE(*,*) 'alt_horiz,at_horizon =',alt_horiz,at_horizon
     CALL bisection(f_alt,t1,t2,epst,tsun(j),iter(j),ifound(j))
     aazim(j)=azimuth
     aaltitude(j)=altitude
     aaltrefract(j)=alt_refract
  ENDDO
!---- Fine probe alt times
  DO j=11,12
     IF (j==11) THEN
        t1=0.d0-longitude/360.d0
        t2=0.5d0-longitude/360.d0
     ELSE
        t1=0.5d0-longitude/360.d0
        t2=1.d0-longitude/360.d0
     ENDIF
     alt_horiz=alt_probe
     at_horizon=abs(alt_horiz)<1.d0
!     WRITE(*,*) 'alt_horiz,at_horizon =',alt_horiz,at_horizon
     CALL bisection(f_alt,t1,t2,epst,tsun(j),iter(j),ifound(j))
     aazim(j)=azimuth
     aaltitude(j)=altitude
     aaltrefract(j)=alt_refract
  ENDDO
!  WRITE(*,*) 'iter0--9 =',iter
END SUBROUTINE find_times

SUBROUTINE bisection(func,t1,t2,epst,tfound,iter,ifound)
  IMPLICIT NONE
  EXTERNAL func
  INTEGER :: i,ifound,iter,maxit=100000
  REAL(KIND=8) :: t1,t2,epst,tfound,func
  REAL(KIND=8) :: ta,tb,tc,dt,fa,fb,fc
  LOGICAL :: goodrt
  ta=t1
  tb=t2
  tc=0.5d0*(ta+tb)
  fa=func(ta)
  fb=func(tb)
  fc=func(tc)
!--   Check if root is bracketed
  IF (fa*fb>0.d0) THEN
!     WRITE(*,*) 'BISECTION: Root not bracketed'
     ifound=0
     RETURN
  ENDIF
  DO i=1,maxit
     IF (fa*fc.LE.0.d0) THEN
        tb=tc
        fb=fc
     ELSE
        ta=tc
        fa=fc
     ENDIF
     tc=0.5d0*(ta+tb)
     fc=func(tc)
     goodrt=abs(tc-ta)<=epst
     tfound=tc
     iter=i
     IF (goodrt) THEN
        ifound=1
        RETURN
     ENDIF
  ENDDO
  WRITE(*,*) 'BISECTION: Maximum iteration number exceeded.'
  ifound=2
  RETURN
END SUBROUTINE bisection

!SUBROUTINE findmax(t1,t2,epst,tfound,iter)
!  IMPLICIT NONE
!  INTEGER :: i,iter,maxit=100000
!  REAL(KIND=8) :: t1,t2,epst,tfound,f_alt
!  REAL(KIND=8) :: ta,tb,tc,dt,fa,fb,fc
!  LOGICAL :: goodrt
!END SUBROUTINE findmax

FUNCTION f_alt(t)
  USE sunpath_core
  USE sundawn_module
  IMPLICIT NONE
  REAL(KIND=8) :: f_alt,t,alt_offset,hx,hxr,dh
  JDnow=JD0h+t
!  WRITE(*,*) 'JD0h,JDnow =',JD0h,JDnow
!  WRITE(*,*) 'longitude,latitude =',longitude,latitude
  CALL calc_sunpath
!  WRITE(*,*) 'flgref,at_horizon =',flgref,at_horizon
  IF (flgref>=1.AND.at_horizon) THEN
!     write(*,*) 'case: refraction, t,corr =',t,corr_refract
!     alt_offset=r_deg+corr_refract   ! use refraction
!---- Apply refraction correction to upper rim, not center of the Sun!
     hx=altitude+r_deg
     CALL refract_correction(hx,hxr,dh)
     alt_offset=hxr-altitude
  ELSE IF (flgref==0.AND.at_horizon) THEN
     alt_offset=-alt_rim             ! no refraction, user-defined
!     write(*,*) 'case: user-defined'
  ELSE IF (at_horizon) THEN
!     write(*,*) 'case: norefract'
     alt_offset=r_deg                ! no refraction, sun rim
  ELSE
     alt_offset=0.d0                 ! no refraction, sun center (for twilight)
  ENDIF
     f_alt=altitude+alt_offset-alt_horiz
END FUNCTION f_alt

FUNCTION f_culm(t)
  USE sundawn_module
  IMPLICIT NONE
  REAL(KIND=8) :: f_culm,t,t1,t2,f1,f2,f_alt
  t1=t-eps_culm
  t2=t+eps_culm
  f1=f_alt(t1)
  f2=f_alt(t2)
  f_culm=f2-f1
END FUNCTION f_culm

FUNCTION f_trans(t)
  USE sunpath_core
  USE sundawn_module
  IMPLICIT NONE
  REAL(KIND=8) :: f_trans,t
  JDnow=JD0h+t
  CALL calc_sunpath
  f_trans=azimuth-180.d0
END FUNCTION f_trans
