!    SUNPATH CALCULATOR
!    Copyright (C) 2011-2013 by Ingo Thies
!
!    Sunpath is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 2 of the License, or
!    (at your option) any later version.
!
!    Sunpath is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with Sunpath. If not, see <http://www.gnu.org/licenses/>.
!
!    This license applies to this main source file and to all related
!    source files in this package.
!
PROGRAM sunpath
  USE sunpath_core
  USE sunpath_constants, ONLY : d2r,illum_const
  USE sundawn_module!,    ONLY : flgref,alt_rim,alt_culmination,alt_culmrefr,alt_min,aazim
  IMPLICIT NONE
  INTEGER :: i,j,n,nfinal,ifound(0:12),flgdate,flgdst,flgoffsys,poi,idum,hh2utc
  INTEGER :: yr,mo,dd,hh,mm,ss,values(8),yro=0,moo=0,ddo=0,illux,klglux
!  INTEGER :: yrsys,mosys,ddsys,hhsys,mmsys,sssys,mssys,mm2utc
  INTEGER :: yr0,mo0,dd0,hh0,mm0,ss0,dow0,yrtoday,motoday,ddtoday,flgmlux
  INTEGER :: yri,moi,ddi,hhi,mmi,ssi,yrf,mof,ddf,hhf,mmf,ssf,dcct1=100,dcct2=100,dcct3=100,dcct4=100
  REAL(KIND=8) :: hhmm0
  REAL(KIND=8) :: ftwilight,ddum,ddum1,ddum2,kdigs=30.d0
  REAL(KIND=8) :: poi_lat,poi_lon,poi_ltc,poi_dst,poi_elv
  REAL(KIND=8) :: t,t0,t1,dt,dtsec,offutc,offsys,offsys_display,delta_offsys,thoff,dst,JDref,JDdst0,JDdst1,hr,hrmin,hrmax
  REAL(KIND=8) :: daylength,dayhour,daytime,eot_local,diff_mean_zone
  REAL(KIND=8) :: xair,eta(0:11),etag(0:11),etad(0:11),diffuse(0:11),illum(0:11),sinalt!,trise,tculm,ttrans,tset,
  REAL(KIND=8) :: dmr1,dmr2,dmr3,cct1,cct2,cct3,cct4
  REAL(KIND=8) :: cct0=5932.d0,mired_overcast=-30.d0,rscale=1.d0
  REAL(KIND=8) :: tsun(0:12),tsec(0:12),illum_lux,illum_extr_lux,azim_prev=0.d0
  REAL(KIND=8) :: tssys,tssys_display,secs2sunrise,secs2sunset,mins2candles,dtsmins(1:2)
  REAL(KIND=8) :: max_transmission,max_illumination
  REAL(KIND=8) :: max_altr,gp_max_trans,gp_max_illu,gp_stretch=1.1d0
!  REAL(KIND=8) :: uvindex,uvexpose(2),uvscal=67.892d0!UV transmission to UV index conversion
!  REAL(KIND=8) :: uvi2min(2)=(/120.d0,370.d0/)!scale for exposure time in minutes
! (based on UVI = int_286nm^400nm I(lam)*w(lam) dlam -> solubv.f90
  CHARACTER (LEN=11) :: thms,dayhms
  CHARACTER (LEN=8) :: dhrms
  CHARACTER (LEN=8) :: hhmmss(0:12),hms2sunrise,hms2sunset
  CHARACTER (LEN=50) :: name_poi,poifile
  CHARACTER (LEN=3) :: cdow0
  LOGICAL usedst,issouth,nextday,flag_shabbat,flag_daylight
  LOGICAL skipcalc
  COMMON /caldst/ skipcalc
  skipcalc=.FALSE.
  OPEN(11,FILE='sunpath.par')
  READ(11,*) latitude,longitude,poi
  READ(11,*) flgdate,flgoffsys
  READ(11,*) yr0,mo0,dd0,hhmm0
  READ(11,*) dtsec,offutc,dst
  READ(11,*) flgref,mired_overcast,pscal_surface
  READ(11,*) alt_rim,z_surface
  READ(11,*) 
  READ(11,*)
  READ(11,*)
  READ(11,*)
  READ(11,*) dtsmins(1),dtsmins(2),alt_probe
  READ(11,*)
  READ(11,*) poifile
  CLOSE(11)
  WRITE(*,*)
  IF (poi>=1) THEN
     OPEN(12,FILE=trim(poifile),STATUS='OLD')
     DO i=1,poi+1
        READ(12,*,end=1,err=1)
     ENDDO
     READ(12,*,end=1,err=1) idum,poi_lat,poi_lon,poi_ltc,poi_dst,poi_elv,name_poi
     GOTO 2
1    WRITE(*,*) 'POI not available (end of file?)'
     WRITE(*,*) 'Using manual input instead.'
     WRITE(*,*) 'i =',i
     GOTO 3
2    latitude=poi_lat
     longitude=poi_lon
     offutc=poi_ltc
     dst=poi_dst
     IF (z_surface<0.d0) THEN
        z_surface=poi_elv
        PRINT *,'Using elevation from POI table:',nint(poi_elv),' m'
     ELSE
        PRINT *,'Using elevation from user input.'
     ENDIF
     WRITE(*,'(2A)') 'Using Point of Interest: ',trim(name_poi)
     WRITE(*,'(A,2(F9.4,A))') 'at lat,lon = ',poi_lat,' deg N, ',poi_lon,' deg E'
3    CLOSE(12)
  ELSE
     name_poi='User-defined location'
     WRITE(*,'(A,2(F9.4,A))') 'Using manual coordinates = ',latitude,' deg N, ',longitude,' deg E'
  ENDIF
  WRITE(*,*)
  CALL Date_and_Time(values=values)
  usedst=abs(dst)>1.d-2
  issouth=latitude<0.d0!OK, just a dirty hack...
  flag_shabbat=dtsmins(1)>0.d0!indicate begin of Shabbat if candle lighting time makes sense
  hh=0;mm=0;ss=0
  IF (flgdate<=0) THEN
     yr0=values(1)
     mo0=values(2)
     dd0=values(3)
     hh0=values(5)
     mm0=values(6)
     ss0=values(7)
  ENDIF
  IF (flgdate<=1) THEN
     hh0=values(5)
     mm0=values(6)
     ss0=values(7)
  ELSE
     hh0=int(hhmm0)/100
     mm0=int(hhmm0-100*hh0)
     ss0=int(60*(hhmm0-int(hhmm0)))
!     WRITE(*,'(A,I4.4,2('':'',I2.2))') 'hh0,mm0,ss0 = ',hh0,mm0,ss0
  ENDIF
  yr=yr0;mo=mo0;dd=dd0
!  WRITE(*,'(A,I4.4,2('':'',I2.2))') 'YYYY,MM,DD',yr,mo,dd
  CALL DAT2JD(yr,mo,dd,hh,mm,ss,0,JDref)
  CALL JD2DOW(JDref,dow0,cdow0,0,0)
  IF (issouth) THEN
     CALL getdst(JDref+183.d0,flgdst,0)!today's 12-month inverted DST flag
  ELSE
     CALL getdst(JDref+0.5d0,flgdst,0)!today's DST flag
  ENDIF
  IF (flgoffsys>=1) THEN
     offsys=0.d0!assume system time = POI local time (i.e. NOT real time!)
  ELSE
     offsys=(offutc+flgdst*dst)-values(4)/6.d1!system time and POI local time may differ (req. for real time)
!     write(*,*) 'off_POI,off_sys =',offutc+flgdst*dst,values(4)/6.d1
     yr=yr0;mo=mo0;dd=dd0
     write(*,*) 'offsys          =',offsys
  ENDIF
!  IF (flgoffsys<1) THEN
!     offsys_display=offsys
!  ELSE
!     offsys_display=0.d0
!  ENDIF
  IF (flgoffsys>=0) THEN
     offsys_display=offsys
  ELSE
     offsys_display=0.d0
  ENDIF
  delta_offsys=offsys_display-offsys
  CALL offset_time(yr0,mo0,dd0,hh0,mm0,ss0,offsys_display)
!  t0=JDref-2451544.5d0! = days wrt. 2000-01-01 00 UT
  t0=JDref-2451544.5d0-offutc/24.d0! = days wrt. 2000-01-01 00 LT
!  t0=t0-(offutc+flgdst*dst)/24.d0!correction for timezone+dst
  t1=t0+1.d0       ! = 24h later
!  dt=dtmin/1.44d3
  dt=dtsec/8.64d4
  n=int((t1-t0)/dt)
  IF (flgdate<=0.OR.flgdate==2) THEN
     nfinal=n+1
  ELSE
     nfinal=n
  ENDIF
  OPEN(20,FILE='sunpath.out')
  OPEN(21,FILE='sunapp.out')!direct light
  OPEN(22,FILE='sunglobal.out')!global light (direct+scattered)
  OPEN(23,FILE='sundiffuse.out')!indirect illumination
  OPEN(24,FILE='sunillum.out')!ground illumination
  OPEN(32,FILE='sunpath.aux.gp')
!  WRITE(*,1010) 'YYYY-MM-DD hh:mm:ss','hour.dec','A/deg','h/deg','h_r/deg','RA/deg','DE/deg','EOT/min'
  WRITE(20,1010) 'YYYY-MM-DD hh:mm:ss','hour.dec','A/deg','h/deg','h_r/deg','RA/deg','DE/deg','EOT/min', &
       'CCT1/K','CCT2/K','CCT3/K','CCT4/K'
  WRITE(21,1210) 'YYYY-MM-DD hh:mm:ss','hour.dec','h/deg','h_r/deg','xair','All','U','B','V','R','I','u','g','r','i','z','UV'
  WRITE(22,1210) 'YYYY-MM-DD hh:mm:ss','hour.dec','h/deg','h_r/deg','xair','All','U','B','V','R','I','u','g','r','i','z','UV'
  WRITE(23,1210) 'YYYY-MM-DD hh:mm:ss','hour.dec','h/deg','h_r/deg','xair','All','U','B','V','R','I','u','g','r','i','z','UV'
  WRITE(24,1210) 'YYYY-MM-DD hh:mm:ss','hour.dec','h/deg','h_r/deg','xair','All','U','B','V','R','I','u','g','r','i','z','UV'
  WRITE(32,'(3A)') 'strg_poi="',trim(name_poi),'"'
  WRITE(32,'(A,F9.4,'' N, '',F9.4,'' E'',A)') 'strg_geo="',latitude,longitude,'"'
  nextday=.FALSE.
  max_transmission=0.d0
  max_altr=0.d0
  max_illumination=0.d0
  DO i=0,nfinal
     IF (i<=n) THEN
        t=t0+i*dt
        JDnow=t+2451544.5d0
     ELSE IF (flgdate<=1) THEN
        CALL get_time_now(JDnow,offsys,t,tssys,values)
        JDnow=JDnow-(offutc+flgdst*dst)/24.d0
        t=t-(offutc+flgdst*dst)
     ELSE
        t=t0+dble(hh0)/24.d0+dble(mm0)/1440.d0+dble(ss0)/86.4d3
        JDnow=t+2451544.5d0
        tssys=3.6d3*dble(hh0)+6.d1*dble(mm0)+dble(ss0)
     ENDIF
     CALL calc_sunpath
     CALL calc_airmass(altitude,xair,eta,etag,etad)
     CALL calc_colortemp(xair,1,dmr1,cct0,cct1)!direct + 2.5deg
     CALL calc_colortemp(xair,2,dmr2,cct0,cct2)!global tilt
     CALL calc_colortemp(xair,3,dmr2,cct0,cct3)!global horiz
     cct4=1.d6/(1.d6/cct3+mired_overcast)!overcast (horiz-25 mired)
!     uvindex=eta(11)*uvscal
!     uvexpose(1)=uvi2min(1)/max(uvindex,0.5d0)
!     uvexpose(2)=uvi2min(2)/max(uvindex,0.5d0)
     CALL JD2DAT(JDnow+offutc/24.d0,yr,mo,dd,hh,mm,ss,0)
     CALL getdst(JDnow,flgdst,0)
     skipcalc=.TRUE.
     thoff=offutc+flgdst*dst
     CALL JD2DAT(JDnow+thoff/24.d0,yr,mo,dd,hh,mm,ss,0)
!     hr=24.d0*i*dt
     diff_mean_zone=thoff-longitude/15.d0
     eot_local=eot_min-6.d1*diff_mean_zone
     nextday=(dd>ddo.OR.mo>moo.OR.yr>yro) .AND. i>0 .OR. nextday
     hr=dble(hh)+dble(mm)/6.d1+dble(ss)/3.6d3
     sinalt=max(sin(alt_refract*d2r),0.d0)
     IF (nextday) hr=hr+24.d0
     CALL sun_distance(JDnow,rscale)
     illum_extr_lux=illum_const/rscale**2
     DO j=0,11
!    Ground illumination: oblique incidence of direct light
!    plus indirect (scattered) light. (etag-eta = indirect)
        diffuse(j)=max(etag(j)-eta(j),0.d0)
!        illum(j)=eta(j)*sinalt+diffuse(j)*(1.d0+sinalt)/2.d0!old formula
        illum(j)=eta(j)*sinalt+diffuse(j)
     ENDDO
!     WRITE(*,*) 'flgdst =',flgdst
!      stop
     IF (i>n) THEN
!        WRITE(*,'(A)') '**** Current Solar Data ****'
        IF (illum(0)<3.d-7) THEN
           flgmlux=2
           illum_lux=1.d3*illum_extr_lux*illum(3)!using V-Band as visual approximation
        ELSE IF (illum(0)<3.d-4) THEN
           flgmlux=1
           illum_lux=1.d3*illum_extr_lux*illum(3)!(but should change to CIE V(lambda) in future!)
        ELSE
           flgmlux=0
           illum_lux=illum_extr_lux*illum(3)
        ENDIF
        klglux=nint(max(1.d1**int(log10(illum_lux/kdigs)),1.d0))
        illux=klglux*anint(illum_lux/klglux)
        WRITE(*,*)
        WRITE(*,4000)
!        WRITE(*,*) yr0,mo0,dd0,hh0,mm0,ss0
        IF (alt_refract>=-0.25d0) THEN
!           WRITE(*,4004) values(1),values(2),values(3),values(5),values(6),values(7), &
           WRITE(*,4004) yr0,mo0,dd0,hh0,mm0,ss0, &
                azimuth,altitude,alt_refract,RA_deg,DC_deg, &
                6.d1*diff_mean_zone,eot_min,eot_local,xair, &
                dcct1*nint(cct1/dcct1),dcct2*nint(cct2/dcct2),dcct3*nint(cct3/dcct3),&
                nint(mired_overcast),dcct4*nint(cct4/dcct4)
        ELSE
!           WRITE(*,4005) values(1),values(2),values(3),values(5),values(6),values(7), &
           WRITE(*,4005) yr0,mo0,dd0,hh0,mm0,ss0, &
                azimuth,altitude,RA_deg,DC_deg,6.d1*diff_mean_zone,eot_min,eot_local
        ENDIF
        IF (flgmlux==2) THEN
           WRITE(*,4012) illum_lux
        ELSE IF (flgmlux==1) THEN
           WRITE(*,4011) illux
        ELSE
           WRITE(*,4010) illux
        ENDIF
        WRITE(*,4099)
        EXIT
     ENDIF
     IF (i>0.and.abs(azimuth-azim_prev)>9.d3) THEN
!        WRITE(*,*) 'hr,dazim,dt =',hr,abs(azimuth-azim_prev),3.6d2*dt!debugging
!....write empty lines to make gnuplot disconnect the points
        WRITE(20,*)
        WRITE(21,*)
        WRITE(22,*)
        WRITE(23,*)
        WRITE(24,*)
     ENDIF
!     WRITE(*,1000) yr,mo,dd,hh,mm,ss,hr,azimuth,altitude,alt_refract,RA_deg,DC_deg,eot_min
     WRITE(20,1000) yr,mo,dd,hh,mm,ss,hr,azimuth,altitude,alt_refract,RA_deg,DC_deg,eot_min, &
          nint(cct1),nint(cct2),nint(cct3),nint(cct4)
     WRITE(21,1200) yr,mo,dd,hh,mm,ss,hr,altitude,alt_refract,xair,(eta(j),j=0,11)
     WRITE(22,1200) yr,mo,dd,hh,mm,ss,hr,altitude,alt_refract,xair,(etag(j),j=0,11)
     WRITE(23,1200) yr,mo,dd,hh,mm,ss,hr,altitude,alt_refract,xair,(diffuse(j),j=0,11)
     WRITE(24,1200) yr,mo,dd,hh,mm,ss,hr,altitude,alt_refract,xair,(illum(j),j=0,11)
     max_transmission=max(max_transmission,maxval(eta))
     max_altr=max(max_altr,alt_refract)
     max_illumination=max(max_illumination,maxval(illum))
     IF (i==0) THEN
        yri=yr; moi=mo; ddi=dd
        hhi=hh; mmi=mm; ssi=ss
        hrmin=hr
        WRITE(32,3000) 'strg_tmin',yri,moi,ddi,hhi,mmi,ssi
     ELSE IF (i==n/2) THEN!make sure that "today" is far away from midnight
        yrtoday=yr
        motoday=mo
        ddtoday=dd
     ELSE IF (i==n) THEN
        yrf=yr; mof=mo; ddf=dd
        hhf=hh; mmf=mm; ssf=ss
        hrmax=hr
        WRITE(32,3000) 'strg_tmax',yrf,mof,ddf,hhf,mmf,ssf
     ENDIF
     yro=yr
     moo=mo
     ddo=dd
     azim_prev=azimuth
  ENDDO
  tssys_display=tssys+3.6d3*delta_offsys
!  WRITE(*,*) 'thoff,offsys,tssys                 =',thoff,offsys,tssys
!  WRITE(*,*) 'thoff,offsys_display,tssys_display =',thoff,offsys_display,tssys_display
!  max_illumination=sqrt(sin(max_altr*d2r))*max_transmission
  gp_max_trans=min(1.d0,aint(10*gp_stretch*max_transmission+1)/10.)
  gp_max_illu =min(1.d0,aint(20*gp_stretch*max_illumination+1)/20.)
!  write(*,*) 'maxt,gpmaxt =',max_transmission,gp_max_trans
!  write(*,*) 'maxi,gpmaxi =',max_sinalt*max_transmission,gp_max_illu
  WRITE(32,3005) 'max_altr', max_altr
  WRITE(32,3005) 'max_trans',gp_max_trans
  WRITE(32,3005) 'max_illu',gp_max_illu
  WRITE(32,3001) yrtoday,motoday,ddtoday
  WRITE(32,3010) yri,moi,ddi,hhi,mmi,ssi,yrf,mof,ddf,hhf,mmf,ssf
  IF (alt_refract<0.d0) THEN
     ddum1=max_altr
  ELSE
     ddum1=alt_refract
  ENDIF
  CLOSE(20)
  CLOSE(21)
  CLOSE(22)
  CLOSE(23)
  CLOSE(24)
!  WRITE(*,*) 'JDref =',JDref
!  WRITE(*,*) 'longitude,latitude =',longitude,latitude
  CALL find_times(JDref,tsun,ifound)
  daylength=24.d0*(tsun(7)-tsun(4))
  dayhour=daylength/12.d0!temporal/halachic hour
  CALL t2hms(daylength*3.6d3,dayhms)
  CALL t2ms(dayhour*3.6d3,dhrms)
  DO i=0,12
     IF (ifound(i)>=1) THEN
!        tsec(i)=8.64d4*tsun(i)+3.6d3*thoff
        tsec(i)=8.64d4*tsun(i)+3.6d3*(thoff+delta_offsys)
        CALL t2hms(tsec(i),thms)
        hhmmss(i)=thms(4:11)
!        write(*,*) 'thms =',thms(1:2)
!        IF (i==4) write(*,*) 'tsec    =',tsec(i)
!        IF (i==4) write(*,*) 'tsec-ts =',tsec(i)-tssys
!        IF (i==4) write(*,*) 'tsec-tsd=',tsec(i)-tssys_display
        IF (i==4) secs2sunrise=tsec(i)-tssys_display
        IF (i==7) secs2sunset =tsec(i)-tssys_display
        tsec(i)=tsec(i)-8.64d4*floor(tsec(i)/8.64d4)
     ELSE
        hhmmss(i)='  ----  '
        IF (i==4) secs2sunrise=8.64d4-tssys_display
        IF (i==7) secs2sunset =8.64d4-tssys_display
     ENDIF
  ENDDO
  daytime=-secs2sunrise/3.6d3
  flag_daylight=daytime>0.d0.AND.daytime<daylength
!debug
!  secs2sunset=900.d0
!  dow0=5
!/debug
  CALL t2hms(secs2sunrise,thms)
  hms2sunrise=thms(4:11)
!  write(*,*) 'secs2sunrise =',secs2sunrise,'; thms = "',thms,'"'
  CALL t2hms(secs2sunset,thms)
  hms2sunset=thms(4:11)
!  write(*,*) 'secs2sunset =',secs2sunset,'; thms = "',thms,'"'
  WRITE(32,3005) 'hr_min',hrmin
  WRITE(32,3005) 'hr_max',hrmax
  WRITE(32,3005) 'hr_dawn0',aint(tsec(4)/3.6d3)
  WRITE(32,3005) 'hr_dusk0',aint(tsec(7)/3.6d3+1.d0)
  WRITE(32,3005) 'hr_dawn1',aint(tsec(3)/3.6d3)
  WRITE(32,3005) 'hr_dusk1',aint(tsec(8)/3.6d3+1.d0)
  WRITE(32,3005) 'hr_dawn2',aint(tsec(2)/3.6d3)
  WRITE(32,3005) 'hr_dusk2',aint(tsec(9)/3.6d3+1.d0)
  WRITE(32,3005) 'hr_dawn3',aint(tsec(1)/3.6d3)
  WRITE(32,3005) 'hr_dusk3',aint(tsec(10)/3.6d3+1.d0)
  DO i=0,10
     IF (ifound(i)>=1) THEN
        WRITE(32,3006) 'th',i,tsec(i)/3.6d3
     ELSE IF (i<=5) THEN
        WRITE(32,3006) 'th',i,hrmin
     ELSE
        WRITE(32,3006) 'th',i,hrmax
     ENDIF
  ENDDO
  WRITE(32,3020) ddum1,z_surface,pscal_surface
  CLOSE(32)
!  WRITE(*,*) 'sunrise = ',trise
!  WRITE(*,*) 'sunset  = ',tset
  
  IF (flgdate>0) THEN
     WRITE(*,*)
     WRITE(*,1100) cdow0,yr0,mo0,dd0
  ENDIF
  IF (secs2sunrise>0) THEN
     WRITE(*,2201) hms2sunrise
  ELSE IF (secs2sunset>0) THEN
     WRITE(*,2202) hms2sunset
  ENDIF
!     WRITE(*,'(/A)') '----DEBUGGING----'
!     WRITE(*,*) 'secs,h2sunrise =',secs2sunrise,secs2sunrise/3.6d3
!     WRITE(*,*) 'secs,h2sunset  =',secs2sunset,secs2sunset/3.6d3
!     WRITE(*,2201) hms2sunrise
!     WRITE(*,2202) hms2sunset
!     WRITE(*,'(A)') '----/DEBUGGING----'

  IF (dow0==5.and.flag_shabbat) THEN
     mins2candles=secs2sunset/6.d1-dtsmins(1)
!     write(*,*) 'mins2candles =',mins2candles
     IF (secs2sunset>0.d0) THEN
        IF (mins2candles<-1.d0) THEN
           WRITE(*,'(A)') ' Shabbat begins with sunset - candles should be lit now'
        ELSE IF (mins2candles<1.d0) THEN
           WRITE(*,'(A)') ' Shabbat begins with sunset - light candles now'
!        ELSE IF (mins2candles<100.d0) THEN
!           WRITE(*,'(A,I3,A)') ' Shabbat begins with sunset - light candles in', &
!               int(mins2candles),' minutes'
        ELSE
           WRITE(*,'(A)') ' Shabbat begins with sunset'
        ENDIF
     ENDIF
  ENDIF
  WRITE(*,*)
  IF (flgdst>0) THEN
     WRITE(*,'(1X,''DST offset ='',F5.1,'' h'')') dst
  ENDIF
  WRITE(*,'(1X,''LT-UTC     ='',F5.1,'' h'')') thoff
  WRITE(*,'(1X,''LT-system  ='',F5.1,'' h'')') offsys
  WRITE(*,'(1X,''Day length (hh:mm:ss) ='',1X,A8)') dayhms(4:11)
  WRITE(*,'(1X,''Daylight hour (mm:ss) ='',1X,A8)') dhrms(4:8)
  IF (flag_daylight) THEN
     WRITE(*,'(1X,''Daytime  ='',F6.2,'' h  ='',F6.2,'' dayh'')') daytime,daytime/dayhour
!     WRITE(*,*) 'daytime/dh =',daytime/dayhour
  ENDIF
  WRITE(*,*)
  WRITE(*,2001) 'Event \ Time','hh:mm:ss','Azimuth/d','Altitude/d','App. Alt./d'
  DO i=0,12
     IF (ifound(i)>=1) THEN
!        IF (i<4.OR.i>7) THEN
!           WRITE(*,2005) time_label(i),hhmmss(i),aazim(i),aaltitude(i)
!        ELSE
!           WRITE(*,2000) time_label(i),hhmmss(i),aazim(i),aaltitude(i),aaltrefract(i)
!        ENDIF
        IF (aaltitude(i)>-1.d0) THEN
           WRITE(*,2000) time_label(i),hhmmss(i),aazim(i),aaltitude(i),aaltrefract(i)
        ELSE
           WRITE(*,2005) time_label(i),hhmmss(i),aazim(i),aaltitude(i)
        ENDIF
     ELSE
        WRITE(*,2009) time_label(i)
     ENDIF
  ENDDO
  
!  WRITE(*,'(3A,2(F7.2,A))') 'min. alt       = ',hhmmss(0), '; geo.alt/d =',alt_min,'; azimuth/d =',aazim(0)
!  WRITE(*,'(3A,F7.2,A)')    'Dawn astr.     = ',hhmmss(1), '; azimuth/d =',aazim(1)
!  WRITE(*,'(3A,F7.2,A)')    'Dawn naut.     = ',hhmmss(2), '; azimuth/d =',aazim(2)
!  WRITE(*,'(3A,F7.2,A)')    'Dawn civil     = ',hhmmss(3), '; azimuth/d =',aazim(3)
!  WRITE(*,'(3A,F7.2,A)')    'sunrise        = ',hhmmss(4), '; azimuth/d =',aazim(4)
!  WRITE(*,'(3A,2(F7.2,A))') 'culmination    = ',hhmmss(5), '; geo.alt/d =',alt_culmination,'; app. alt/d=',alt_culmrefr
!  WRITE(*,'(3A,2(F7.2,A))') 'transit        = ',hhmmss(6), '; azimuth/d =',aazim(6),'; app. alt/d=',alt_culmrefr
!  WRITE(*,'(3A,F7.2,A)')    'sunset         = ',hhmmss(7), '; azimuth/d =',aazim(7)
!  WRITE(*,'(3A,F7.2,A)')    'Twilight civil = ',hhmmss(8), '; azimuth/d =',aazim(8)
!  WRITE(*,'(3A,F7.2,A)')    'Twilight naut. = ',hhmmss(9), '; azimuth/d =',aazim(9)
!  WRITE(*,'(3A,F7.2,A)')    'Twilight astr. = ',hhmmss(10),'; azimuth/d =',aazim(10)
  WRITE(*,*) 
1000 FORMAT(1X,I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,2X,F9.4, 2X,6(2X,F9.3),4(2X,I6))
1200 FORMAT(1X,I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,2X,F9.4, 2X,2(2X,F9.3),2X,F9.4,2X,15(2X,F12.10))
!1205 FORMAT(1X,I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,2X,F9.4, 4X,F9.3,2X,F9.6,2(2X,F9.1))
1210 FORMAT('#',A19,2X,4(2X,A9),2X,12(2X,A12))
!1010 FORMAT('#',A19,12(2X,A9))
1010 FORMAT('#',A19,2X, A9, 2X, 6(2X,A9), 4(2X,A6))
1100 FORMAT('Date: ',A3,', ',I4.4,2('-',I2.2))
2000 FORMAT(A14,' = ',A8,3(2X,F12.3))
2001 FORMAT(A14,' = ',A8,3(2X,A12))
2005 FORMAT(A14,' = ',A8,2(2X,F12.3),8X,'------')
!2009 FORMAT(A14,' = ','--:--:--',2(8X,'------'),8X,'------')
2009 FORMAT(A14,' = ','n/a')
2201 FORMAT(/' Time to sunrise = ',A8)
2202 FORMAT(/' Time to sunset  = ',A8)
3000 FORMAT(A,'="',I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,'"')
3001 FORMAT('strg_today="',I4.4,2('-',I2.2),'"')
3005 FORMAT(A,'=',F9.6)
3006 FORMAT(A,I2.2,'=',F9.6)
3010 FORMAT(('set xrange ["',I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,&
                       '":"',I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,'"]'))
3020 FORMAT('alt_sun=',F5.2/'elevation=',F6.0/'scal_pressure=',F12.8)
4000 FORMAT('************* Current Solar Data *************')
4004 FORMAT('*  Date & Time:',1X,I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,8X,'  *'/ &
            '*  Azimuth position / deg        : ',F8.3,'  *'/ &
            '*  True altitude / deg           : ',F8.3,'  *'/ &
            '*  App. altitude / deg           : ',F8.3,'  *'/ &
            '*  Right ascension / deg         : ',F8.3,'  *'/ &
            '*  Declination / deg             : ',F8.3,'  *'/ &
            '*  LT vs. mean sol. / min        : ',F8.3,'  *'/ &
            '*  Equation of Time / min        : ',F8.3,'  *'/ &
            '*  Local EOT / min               : ',F8.3,'  *'/ &
            '*  Air mass                      : ',F8.3,'  *'/ &
            '*  Direct colour temperature / K : ',I8,  '  *'/ &
            '*  Global (towards Sun) CT / K   : ',I8,  '  *'/ &
            '*  Global (horizontal) CT / K    : ',I8,  '  *'/ &
            '*  Overcast (',I3,' mireds) CT / K',2X,': ',I8,  '  *')
4005 FORMAT('*  Date & Time:',1X,I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2,8X,'  *'/ &
            '*  Azimuth position / deg        : ',F8.3,'  *'/ &
            '*  True altitude / deg           : ',F8.3,'  *'/ &
!            '*  App. altitude / deg           :  -------','  *'/ &
            '*  Right ascension / deg         : ',F8.3,'  *'/ &
            '*  Declination / deg             : ',F8.3,'  *'/ &
            '*  LT vs. mean sol. / min        : ',F8.3,'  *'/ &
            '*  Equation of Time / min        : ',F8.3,'  *'/ &
            '*  Local EOT / min               : ',F8.3,'  *')
4010 FORMAT('*  Ground illum. / lux           : ',I8,'  *')
4011 FORMAT('*  Ground illum. / mlux          : ',I8,'  *')
4012 FORMAT('*  Ground illum. / mlux          : ',F8.1,'  *')
4099 FORMAT('**********************************************')
END PROGRAM sunpath

SUBROUTINE get_time_now(JD,offsys,ty2k,tssys,values)
  IMPLICIT NONE
  INTEGER :: yrsys,mosys,ddsys,hhsys,mmsys,sssys,mssys,mm2utc,ssuse,values(8)
  REAL(KIND=8) :: JD,offsys,ty2k,tssys,offutc,epssec=0.5d0
  CALL Date_and_Time(values=values)
  yrsys=values(1)
  mosys=values(2)
  ddsys=values(3)
  mm2utc=values(4)
  hhsys=values(5)
  mmsys=values(6)
  sssys=values(7)
  mssys=values(8)
  offutc=dble(mm2utc)/6.d1
  ssuse=nint(dble(sssys)+1.d-3*dble(mssys)+epssec)
  CALL DAT2JD(yrsys,mosys,ddsys,hhsys,mmsys,ssuse,0,JD)
!  WRITE(*,'(A,I2.2,2('':'',I2.2))') 'hh,mm,ss =',hhsys,mmsys,ssuse
  IF (offsys.ne.0.d0) THEN
     JD=JD+offsys/24.d0
     CALL JD2DAT(JD,yrsys,mosys,ddsys,hhsys,mmsys,ssuse,0)
!     WRITE(*,'(A,I2.2,2('':'',I2.2))') 'hh,mm,ss =',hhsys,mmsys,ssuse
     values(1)=yrsys
     values(2)=mosys
     values(3)=ddsys
     values(4)=mm2utc+offsys
     values(5)=hhsys
     values(6)=mmsys
  ENDIF
  values(7)=ssuse!re-adjust for center-rounded and advanced milliseconds
  tssys=3.6d3*dble(hhsys)+6.d1*dble(mmsys)+dble(ssuse)
  ty2k=JD-2451544.5d0
  RETURN
END SUBROUTINE get_time_now

SUBROUTINE offset_time(yr,mo,dd,hh,mm,ss,offhr)
  IMPLICIT NONE
  INTEGER :: yr,mo,dd,hh,mm,ss
  REAL(KIND=8) :: JD,JDnew,offhr
  IF (offhr/=0.d0) THEN
     CALL DAT2JD(yr,mo,dd,hh,mm,ss,0,JD)
     JDnew=JD+offhr/24.d0
     CALL JD2DAT(JDnew,yr,mo,dd,hh,mm,ss,0)
  ENDIF
  RETURN
END SUBROUTINE offset_time
