reset
!sunpath.x > sunpath.txt
set term push
#set term postscript landscape color enhanced dashed dl 2.0 "Helvetica" 16
set term postscript eps color enhanced dashed dl 2.0 size 15.cm,10.5cm "Helvetica" 16
#set size 1.2,1.1
#set origin -0.5,0.1
set lmargin screen 0.06;set rmargin screen 0.98
set bmargin screen 0.08;set tmargin screen 0.92
lw1=3.0;lw2=2.0;lw3=1.5;lw4=1.0;lw5=0.5
ps1=0.1
set clip
## plot lines ##
set style line 1 lt 1 lw lw1 lc rgb '#000000'
set style line 2 lt 2 lw lw2 lc rgb '#ff0000'
set style line 3 lt 3 lw lw2 lc rgb '#00aa00'
set style line 4 lt 4 lw lw3 lc rgb '#0000ff'
set style line 5 lt 1 lw lw1 lc rgb '#ff0000'
set style line 6 lt 2 lw lw2 lc rgb '#aa0000'
set style line 7 lt 3 lw lw2 lc rgb '#550000'
set style line 8 lt 4 lw lw2 lc rgb '#000000'
set style line 9 lt 4 lw lw3 lc rgb '#0000ff'
## grid lines ##
set style line 10 lt 1 lw lw1 lc rgb '#000000'
set style line 11 lt 1 lw lw4 lc rgb '#7f7f7f'
set style line 12 lt 1 lw lw5 lc rgb '#bfbfbf'
## UBRV plot styles
set style line 20 lt 1 lw lw1 lc rgb '#000000'#full spectrum
set style line 21 lt 4 lw lw1 lc rgb '#5500aa'#U
set style line 22 lt 3 lw lw1 lc rgb '#0000ff'#B
set style line 23 lt 2 lw lw1 lc rgb '#00aa00'#V
set style line 24 lt 5 lw lw1 lc rgb '#ff0000'#R
set style line 25 lt 6 lw lw1 lc rgb '#880000'#I
## format
## for time format use column 1 as x
#set xdata time;set timefmt "%Y-%m-%d %H:%M:%S"
#set format x "%02H"
#set xtics 7200.
## for decimal format use column 3 as x
set xtics 1.
##
set mxtics 6
set grid xtics ytics mxtics mytics ls 11, ls 12
set xlabel 'Time of the day / h'
load 'sunpath.aux.gp'
#hr_min=8.;hr_max=18.#manual xrange
#### Define twilight borders
set arrow 1 from first th04,graph 0. to first th04, graph 1. nohead ls 5#sunrise
set arrow 2 from first th07,graph 0. to first th07, graph 1. nohead ls 5#sunset
set arrow 3 from first th03,graph 0. to first th03, graph 1. nohead ls 6#civil dawn
set arrow 4 from first th08,graph 0. to first th08, graph 1. nohead ls 6#civil dusk
set arrow 5 from first th02,graph 0. to first th02, graph 1. nohead ls 7#nautical dawn
set arrow 6 from first th09,graph 0. to first th09, graph 1. nohead ls 7#nautical dusk
set arrow 7 from first th01,graph 0. to first th01, graph 1. nohead ls 8#astronomical dawn
set arrow 8 from first th10,graph 0. to first th10, graph 1. nohead ls 8#astronomical dusk
set arrow 9 from first th05,graph 0. to first th05, graph 1. nohead ls 9#noon
strg4title=' for '.strg_poi.', '.strg_today
#### Altitude
set output "sunpath_alt.eps"
set title 'Sun Altitude / deg'.strg4title
#set xrange [hr_min:hr_max] # use this for decimal hours
#set xrange [hr_dawn0:hr_dusk0] # use this for decimal hours, daylight
#set xrange [hr_dawn1:hr_dusk1] # use this for decimal hours, civil
#set xrange [hr_dawn2:hr_dusk2] # use this for decimal hours, nautical
set xrange [hr_dawn3:hr_dusk3] # use this for decimal hours, astron.
set arrow 10 from graph 0.,first 0. to graph 1., first 0. nohead ls 10
set ytics 5; set mytics 5
set format y '%g'
set key at graph 0.6,graph 0.387
plot 'sunpath.out' using 3:5 t 'Geometric Alt.' w l ls 1,\
     'sunpath.out' using 3:6 t 'Apparent Alt.' w l ls 2
#### Azimuth
set output "sunpath_azm.eps"
set title 'Sun Azimuth / deg'.strg4title
set xrange [hr_min:hr_max] # use this for decimal hours
set arrow 10 from graph 0.,first 180. to graph 1., first 180. nohead ls 10
set ytics 30; set mytics 6
unset key
plot 'sunpath.out' using 3:4 notitle w l ls 1
#### Air mass
## remove sunrise/set and civil twilight borders
## since gnuplot does not yet support automatic object clipping
unset arrow 1;unset arrow 2;unset arrow 3;unset arrow 4
set output "sunpath_air.eps"
set title 'Airmass'.strg4title
#unset for [i=1:8] arrow i
unset arrow 10
set logscale y
set xrange [th04:th07] # use this for decimal hours, astron.
set yrange [0.9:100.]; set ytics 10; set mytics 10
unset key
plot 'sunapp.out' using 3:6 notitle w l ls 1
unset logscale y
#### Transmission (direct sunlight, without scatter)
set output "sunpath_trans.eps"
set title 'Transmission'.strg4title
set xrange [th04:th07] # use this for decimal hours, astron.
set yrange [0.:max_trans]; set ytics 0.1; set mytics 5
set key at graph 0.12, 0.98
plot 'sunapp.out' using 3:7  t 'full' w l ls 20,\
     'sunapp.out' using 3:8  t 'U'    w l ls 21,\
     'sunapp.out' using 3:9  t 'B'    w l ls 22,\
     'sunapp.out' using 3:10 t 'V'    w l ls 23,\
     'sunapp.out' using 3:11 t 'R'    w l ls 24,\
     'sunapp.out' using 3:12 t 'I'    w l ls 25
#### Global illumination (horizontal surface+scatter, no clouds)
## reinsert sunrise/set and civil twilight borders
set arrow 1 from first th04,graph 0. to first th04, graph 1. nohead ls 5#sunrise
set arrow 2 from first th07,graph 0. to first th07, graph 1. nohead ls 5#sunset
set arrow 3 from first th03,graph 0. to first th03, graph 1. nohead ls 6#civil dawn
set arrow 4 from first th08,graph 0. to first th08, graph 1. nohead ls 6#civil dusk
## Scatter light functions (based on ASTMG173); x=airmass
kluma=1.0
klumu=1.e-30
klumb=0.3## from eye sensitivity curve (estimate)
klumv=0.8
klumr=0.1
klumi=1.e-30
scallux=100.
set output "sunpath_illu.eps"
set title 'Ground illumination / klux'.strg4title
set xrange [hr_dawn3:hr_dusk3] # full twilight
#set xrange [th04:th07] # use this for decimal hours, astron.
set yrange [0:max_illu*scallux]; set ytics 0.05*scallux; set mytics 5
#ftwilight(x)=0.
set key at graph 0.12, 0.98
plot 'sunillum.out' using 3:(scallux*kluma*$7)  t 'full' w l ls 20#,\
     'sunillum.out' using 3:(scallux*klumu*$8)  t 'U'    w l ls 21,\
     'sunillum.out' using 3:(scallux*klumb*$9)  t 'B'    w l ls 22,\
     'sunillum.out' using 3:(scallux*klumv*$10) t 'V'    w l ls 23,\
     'sunillum.out' using 3:(scallux*klumr*$11) t 'R'    w l ls 24,\
     'sunillum.out' using 3:(scallux*klumi*$12) t 'I'    w l ls 25
#### Log glob. illumination (horizontal surface+scatter, no clouds)
set output 'sunpath_ilog.eps'
set title 'Log. ground illum. / lux'.strg4title
scallux=100000.
set yrange [1.e-10*scallux:1.0*scallux]
set logscale y; set ytics 10; set mytics 10
set format y '10^{%T}'
plot 'sunillum.out' using 3:(scallux*kluma*$7)  t 'full' w l ls 20#,\
     'sunillum.out' using 3:(scallux*klumu*$8)  t 'U'    w l ls 21,\
     'sunillum.out' using 3:(scallux*klumb*$9)  t 'B'    w l ls 22,\
     'sunillum.out' using 3:(scallux*klumv*$10) t 'V'    w l ls 23,\
     'sunillum.out' using 3:(scallux*klumr*$11) t 'R'    w l ls 24,\
     'sunillum.out' using 3:(scallux*klumi*$12) t 'I'    w l ls 25
####
unset logscale y
#set output 'x.eps'
#set xrange [1:40];set xtics 5; set mxtics 5
#plot fscv(x) w l
####
unset output
set term pop
!latex sun_path.tex
!dvips sun_path.dvi
!ps2pdf sun_path.ps
!gzip -f sun_path.ps
print ''
print 'Sunpath screen output:'
print '======================'
print ''
!cat sunpath.txt
