reset
!sunplot.x
set term push
#set term postscript landscape color enhanced dashed dl 2.0 size 29.7cm,21cm "Helvetica" 16;set output "sunplot.ps"
set term postscript eps color enhanced dashed dl 2.0 size 15cm,10.5cm "Helvetica" 16
set output "suntimes.eps"
#set size 1.2,1.1
#set origin -0.5,0.1
#set lmargin screen 0;set rmargin screen 1
#set bmargin screen 0;set tmargin screen 1
lw1=2.0;lw2=1.0;lw3=1.5;lw4=1.0;lw5=0.5
ps1=0.1
## plot lines ##
set style line 1 lt 1 lw lw1 lc rgb '#ff0000'
set style line 2 lt 2 lw lw2 lc rgb '#aa0000'
set style line 3 lt 3 lw lw2 lc rgb '#550000'
set style line 4 lt 4 lw lw2 lc rgb '#000000'
set style line 5 lt 5 lw lw3 lc rgb '#0000ff'
set style line 6 lt 6 lw lw3 lc rgb '#00aa00'
set style line 7 lt 1 lw lw1 pt 1 ps ps1 lc rgb '#00aa00'
set style line 8 lt 1 lw lw1 lc rgb '#0000ff'
set style line 9 lt 2 lw lw1 lc rgb '#ff0000'
## grid lines ##
set style line 10 lt 1 lw lw1 lc rgb '#000000'
set style line 11 lt 1 lw lw4 lc rgb '#7f7f7f'
set style line 12 lt 1 lw lw5 lc rgb '#bfbfbf'
## CCT styles ##
set style line 21 lt 1 lw lw1 lc rgb '#ff0000'
set style line 22 lt 2 lw lw1 lc rgb '#00a000'
set style line 23 lt 3 lw lw1 lc rgb '#0000ff'
## format
set xdata time
set timefmt "%Y-%m-%d"
#set xrange ["2010-01-01":"2011-01-01"]
load 'sunplot.aux.gp'
nsecs=ndays*86400
nsec12=nsecs/12
print 'ndays = ',ndays
strg4title=' (for '.strg_poi.', from '.strg_tmin.' to '.strg_tmax.')'
if (ndays<6) \
   set format x "%m/%d:%Hh"; set mxtics 4 ;\
else if(ndays<24) \
   set format x "%b %d"; set mxtics 4;\
else if(ndays<140) \
   set format x "%b %d"; set mxtics 7;\
else \
   set format x "%b"; set xtics nsec12; set mxtics 6
fy(y)=y<0 ? NaN : y
set grid xtics ytics mxtics mytics ls 11, ls 12
set key at graph 0.57,0.78 samplen 2
#unset key
## Times
set title 'Times / h'.strg4title
set yrange [0:24]; set ytics 1;set mytics 6
plot 'suntimes.out' using 1:(fy($6)) t 'rise/set' w l ls 1,'suntimes.out' using 1:(fy($9))  notitle w l ls 1,\
     'suntimes.out' using 1:(fy($5)) t 'civil'    w l ls 2,'suntimes.out' using 1:(fy($10)) notitle w l ls 2,\
     'suntimes.out' using 1:(fy($4)) t 'naut.'    w l ls 3,'suntimes.out' using 1:(fy($11)) notitle w l ls 3,\
     'suntimes.out' using 1:(fy($3)) t 'astr.'    w l ls 4,'suntimes.out' using 1:(fy($12)) notitle w l ls 4,\
     'suntimes.out' using 1:(fy($7)) t 'culm.'    w l ls 5,'suntimes.out' using 1:(fy($2)) t 'min.' w l ls 6
## Azimuth positions
set output "sunazims.eps"
set title 'Azimuth positions / deg'.strg4title
set yrange [0:360]; set ytics 30;set mytics 6
plot 'sunazims.out' using 1:(fy($6)) t 'rise/set' w l ls 1,'sunazims.out' using 1:(fy($9))  notitle w l ls 1,\
     'sunazims.out' using 1:(fy($5)) t 'civil' 	  w l ls 2,'sunazims.out' using 1:(fy($10)) notitle w l ls 2,\
     'sunazims.out' using 1:(fy($4)) t 'naut.' 	  w l ls 3,'sunazims.out' using 1:(fy($11)) notitle w l ls 3,\
     'sunazims.out' using 1:(fy($3)) t 'astr.' 	  w l ls 4,'sunazims.out' using 1:(fy($12)) notitle w l ls 4,\
     'sunazims.out' using 1:(fy($7)) t 'culm.' 	  w l ls 5#,'sunazims.out' using 1:(fy($2)) t 'min.' w l ls 6
## Altitudes
set title 'Altitudes / deg'.strg4title
set output "sunalt.eps"
set yrange [-90:90]; set ytics 15;set mytics 3
#set arrow 1 from graph 0.,0. to graph 1.,0. lt 1 lw lw2 lc rgb '#000000'
set arrow 1 from graph 0,first 0 to graph 1, first 0 nohead front ls 10
plot 'sunalt.out' using 1:2 t 'culm. true' w l ls 1,\
     'sunalt.out' using 1:3 t 'culm. app.' w p ls 7,\
     'sunalt.out' using 1:4 t 'min. geom.' w l ls 8
## Equation of Time
set title 'Equation of Time (abs., local; min)'.strg4title
set output "suneot.eps"
set yrange [-100:20]; set ytics -150,10,150;set mytics 5
set arrow 1 from graph 0,first 0 to graph 1, first 0 nohead front ls 10
plot 'suneot.out' using 1:2 t 'TST-MST' w l ls 8,\
     'suneot.out' using 1:3 t 'TST-LT ' w l ls 1
set yrange [-15:17]; set ytics -20,2,20;set mytics 4
#plot 'suneot.out' using 1:2 t 'TST-MST' w l ls 8
## Noon illumination (tilted towards sun)
set title 'Noon illumination normal to sunshine / klux'
set output 'sunlux.eps'
set yrange [0:120]; set ytics 10; set mytics 5
unset arrow
#set key at graph 0.99,0.98 samplen 2
set key at graph 0.57,0.30 samplen 2
plot 'suncct.out' using 1:($5/1000.) t 'direct (normal)' w l ls 21,\
     'suncct.out' using 1:($6/1000.) t 'global (normal)' w l ls 22,\
     'suncct.out' using 1:($7/1000.) t 'global (ground)' w l ls 23
## Noon colour temperature
set title 'Noon colour temperature / kelvins'
set output 'suncct.eps'
set yrange [3000:7000]; set ytics 500; set mytics 5
plot 'suncct.out' using 1:2 t 'direct (normal)' w l ls 21,\
     'suncct.out' using 1:3 t 'global (normal)' w l ls 22,\
     'suncct.out' using 1:4 t 'global (ground)' w l ls 23
unset output
set term pop
pdfname='Sun_Data_'.strg_poi.'.pdf'
set print 'sunplot.aux.cmd'
print '#!/bin/bash'
print 'mv sun_data.pdf "',pdfname,'"'
set print
!latex sun_data.tex
!dvips -G0 -Ppdf -t A4Size sun_data.dvi
!ps2pdf -sPAPERSIZE=a4 sun_data.ps
!gzip -f sun_data.ps
# In some terminals the following line might not work:
#!source sunplot.aux.cmd
# but this might work instead
!. sunplot.aux.cmd
