      SUBROUTINE t2hms(ti,thms)
!--   Seconds to hhhh:mm:ss
      IMPLICIT NONE
      DOUBLE PRECISION ti,tt,t,eps,tmaxsec
      PARAMETER (tmaxsec=3.6d7)
      INTEGER h0,h1,h2,h3,m0,m1,s0,s1,sum,nloops
      PARAMETER(eps=1.d-6)
      CHARACTER x*1,thms*11,hhhh*4,mm*2,ss*2,sg*1
!-9999:59:59
!12345678901
      tt = anint(abs(ti))+eps
      nloops = int(tt/tmaxsec)
      t = tt-nloops*tmaxsec
!      WRITE(*,*) 't2hms:  nloops,tt,t,d =',nloops,tt,t,tt-t
      IF (ti.lt.0.d0) THEN
         sg = '-'
      ELSE
         sg = ' '
      ENDIF
        x = ':'
!--   hours
      h3  = int(t/3.6d6)
      sum = 3600000*h3
      h2  = int((t-sum)/3.6d5)
      sum = sum+360000*h2
      h1  = int((t-sum)/3.6d4)
      sum = sum+36000*h1
      h0  = int((t-sum)/3.6d3)
      sum = sum+3600*h0
      hhhh= char(h3+48)//char(h2+48)//char(h1+48)//char(h0+48)
!--   minutes
      m1  = int((t-sum)/6.d2)
      sum = sum+600*m1
      m0  = int((t-sum)/6.d1)
      sum = sum+60*m0
      mm  = char(m1+48)//char(m0+48)
!--   seconds
      s1  = int((t-sum)/1.d1)
      sum = sum+10*s1
      s0  = int((t-sum))
      sum = sum+s0
      ss  = char(s1+48)//char(s0+48)
!--   total
      thms= sg//hhhh//x//mm//x//ss
!      write(*,*) 'h3,h2,h1,h0 =',h3,h2,h1,h0
!      write(*,'(A,1X,A17)') 'hhhh =',hhhh
      RETURN
      END

      SUBROUTINE t2ms(ti,tms)
!--   Seconds to mmmm:ss
      IMPLICIT NONE
      DOUBLE PRECISION ti,tt,t,eps,tmaxsec
      PARAMETER (tmaxsec=6.d5)
      INTEGER m0,m1,m2,m3,s0,s1,sum,nloops
      PARAMETER(eps=1.d-6)
      CHARACTER x*1,tms*8,mmmm*4,ss*2,sg*1
!-9999:59
!12345678
      tt = anint(abs(ti))+eps
      nloops = int(tt/tmaxsec)
      t = tt-nloops*tmaxsec
!      WRITE(*,*) 't2ms:   nloops,tt,t,d =',nloops,tt,t,tt-t
      IF (ti.lt.0.d0) THEN
         sg = '-'
      ELSE
         sg = ' '
      ENDIF
        x = ':'
!--   minutes
      m3  = int(t/6.d4)
      sum = 60000*m3
      m2  = int((t-sum)/6.d3)
      sum = sum+6000*m2
      m1  = int((t-sum)/6.d2)
      sum = sum+600*m1
      m0  = int((t-sum)/6.d1)
      sum = sum+60*m0
      mmmm  = char(m3+48)//char(m2+48)//char(m1+48)//char(m0+48)
!--   seconds
      s1  = int((t-sum)/1.d1)
      sum = sum+10*s1
      s0  = int((t-sum))
      sum = sum+s0
      ss  = char(s1+48)//char(s0+48)
!--   total
      tms= sg//mmmm//x//ss
!      write(*,*) 'm3,m2,m1,m0 =',m3,m2,m1,m0
!      write(*,'(A,1X,A17)') 'mmmm =',mmmm
      RETURN
      END

      SUBROUTINE t2dhms(ti,tdhms)
!--   Seconds to dddd:hh:mm:ss
      IMPLICIT NONE
      DOUBLE PRECISION ti,tt,t,eps,tmaxsec
      PARAMETER (tmaxsec=8.64d8)
      INTEGER d0,d1,d2,d3,h0,h1,m0,m1,s0,s1,sum,nloops
      PARAMETER(eps=1.d-6)
      CHARACTER x*1,d*1,tdhms*14,dddd*4,hh*2,mm*2,ss*2,sg*1
      tt = anint(abs(ti))+eps
      nloops = int(tt/tmaxsec)
      t = tt-nloops*tmaxsec
!      WRITE(*,*) 't2dhms: nloops,tt,t,d =',nloops,tt,t,tt-t
      IF (ti.lt.0.d0) THEN
         sg = '-'
      ELSE
         sg = ' '
      ENDIF
        d = '*'
        x = ':'
!--   days
      d3  = int(t/8.64d7)
      sum = 86400000*d3
      d2  = int((t-sum)/8.64d6)
      sum = sum+8640000*d2
      d1  = int((t-sum)/8.64d5)
      sum = sum+864000*d1
      d0  = int((t-sum)/8.64d4)
      sum = sum+86400*d0
      dddd = char(d3+48)//char(d2+48)//char(d1+48)//char(d0+48)
!--   hours
      h1  = int((t-sum)/3.6d4)
      sum = sum+36000*h1
      h0  = int((t-sum)/3.6d3)
      sum = sum+3600*h0
      hh  = char(h1+48)//char(h0+48)
!--   minutes
      m1  = int((t-sum)/6.d2)
      sum = sum+600*m1
      m0  = int((t-sum)/6.d1)
      sum = sum+60*m0
      mm  = char(m1+48)//char(m0+48)
!--   seconds
      s1  = int((t-sum)/1.d1)
      sum = sum+10*s1
      s0  = int((t-sum))
      sum = sum+s0
      ss  = char(s1+48)//char(s0+48)
!--   total
      tdhms= sg//dddd//d//hh//x//mm//x//ss
      RETURN
      END

      SUBROUTINE t2cent(ti,pcc)
!--   Seconds to dd:hh:mm:ss.cc
      IMPLICIT NONE
      DOUBLE PRECISION ti,t100,t,ct,eps,tmaxct
      PARAMETER (tmaxct=1.d2)
      INTEGER s,c0,c1,sum,nloops
      PARAMETER(eps=1.d-6)
      CHARACTER pcc*3
      t100 = anint(1.d2*abs(ti))+eps
      nloops = int(t100/tmaxct)
      WRITE(*,*) 't2dhmc: nloops,tt,t,d =',nloops,t100,t,t100-t
!--   seconds
!--   centiseconds
      ct = t100-nloops*tmaxct
      sum = 0
      c1  = int(ct/10)
      sum = sum+10*c1
      c0  = int(ct-sum)
      sum = sum+c0
      pcc  = '.'//char(c1+48)//char(c0+48)
      WRITE(*,*) 'c1,c0,ct =',c1,c0,ct
      RETURN
      END

      SUBROUTINE t2msc(ti,tmsc)
!--   Seconds to mmmm:ss.cc
      IMPLICIT NONE
      DOUBLE PRECISION ti
      CHARACTER tms*8,tmsc*11,pcc*3
      CALL t2ms(ti,tms)
      CALL t2cent(ti,pcc)
      tmsc= tms//pcc
      RETURN
      END

      SUBROUTINE t2hmsc(ti,thmsc)
!--   Seconds to hhhh:mm:ss.cc
      IMPLICIT NONE
      DOUBLE PRECISION ti
      CHARACTER thms*11,thmsc*14,pcc*3
      CALL t2hms(ti,thms)
      CALL t2cent(ti,pcc)
      thmsc= thms//pcc
      RETURN
      END

      SUBROUTINE t2dhmsc(ti,tdhmsc)
!--   Seconds to dddd:hh:mm:ss.cc
      IMPLICIT NONE
      DOUBLE PRECISION ti
      CHARACTER tdhms*14,tdhmsc*17,pcc*3
      CALL t2dhms(ti,tdhms)
      CALL t2cent(ti,pcc)
      tdhmsc= tdhms//pcc
      RETURN
      END
