      SUBROUTINE uvair1(mode,lambda,fspectr)
!==== INPUT
!     mode   : 1 - extraterrestric solar spectrum (0.0 airmass)
!              2 - global tilt 37 deg towards Sun (1.0 airmass)
!              3 - direct + circumsolar 2.5 deg   (1.0 airmass)
!              4 - scattered                      (1.0 airmass)
!     lambda : wavelength in nanometres
!==== OUTPUT
!     fspectr: spectral intensity at lambda in W m^-2 nm^-1
!     Uses data file 'a173.cfs' derived from ASTMG173
      IMPLICIT NONE
      INTEGER mode,k,k0,k1,jf,js
      DOUBLE PRECISION lambda,fspectr, dfdx,x0,x1,f0,f1
!Coeffs COMMON block for storage and optional export
      INTEGER ncfs
      PARAMETER (ncfs=240)
      DOUBLE PRECISION cfs(7,0:ncfs)
      COMMON /uvair1cfs/ cfs
!/Coeffs
      LOGICAL first
      SAVE first
      DATA first/.true./
!====== Setup at first call
      IF (first) THEN
         CALL a1set(ncfs,cfs)
         first=.false.
      ENDIF
      IF (mode.lt.1.OR.mode.gt.4) THEN
         WRITE(*,*) 'A173 Error: mode must be within 1--4'
         WRITE(*,*) 'mode =',mode
         STOP
      ENDIF
      jf=1+mode
      IF (lambda.lt.2.8d2) THEN
         fspectr=0.d0
         RETURN
      ELSE IF (lambda.gt.4.d3) THEN
         fspectr=0.d0
         RETURN
      ENDIF
!====== Bracketing Loop
      k0 = 0
      k1 = ncfs
    1 IF (k1-k0 .gt. 1) THEN
         k = (k1+k0)/2
         IF (lambda.lt.cfs(1,k))THEN
            k1 = k
         ELSE
            k0 = k
         ENDIF
         GOTO 1
      ENDIF
!====== Evaluation
      x0=cfs(1,k0)
      x1=cfs(1,k1)
      f0=cfs(jf,k0)
      f1=cfs(jf,k1)
      dfdx=(f1-f0)/(x1-x0)
      fspectr=f0+(lambda-x0)*dfdx
!      write(*,'(A,1P,9(E12.4))') 'x,mode,f,s =',
!     &     lambda,dble(mode),fspectr,sspectr
!      write(*,'(A,1P,9(E12.4))') 'x,f0,f =',lambda,f0,fspectr
!      write(*,'(2(A,I4),A,2(1X,F7.1),4X,A,F7.1)')'xa at ',k0,',',k1,' ='
!     &,cfs(1,k0),cfs(1,k1),' lambda =',lambda
      RETURN
      END

      SUBROUTINE a1set(ncfs,cfs)
      IMPLICIT NONE
      INTEGER ncfs,i,j
      DOUBLE PRECISION cfs(7,0:ncfs),dum1,dum2
      WRITE(*,*) 'Setting up spectral (AM=1.0) data...'
      OPEN(42,FILE='uvair1.asc',STATUS='old')
      READ(42,*)
      READ(42,*)
      READ(42,*)
      READ(42,*)
      DO i=0,ncfs
         READ(42,*) (cfs(j,i),j=1,5)
!         write(*,*) 'i,xi=',i,cfs(1,i)
! test of source (apply some factor and compare the results)
!         cfs(2,i)=1.2d0*cfs(2,i)
!         cfs(3,i)=1.2d0*cfs(3,i)
!         cfs(4,i)=1.2d0*cfs(4,i)
!     Quick & dirty correction for direct sunlight being stronger
!     than global in mid-IR
         dum1=cfs(3,i)
         dum2=cfs(4,i)
         IF (dum2>dum1) THEN
            cfs(3,i)=cfs(4,i)
         ENDIF
      ENDDO
      CLOSE(42)
      WRITE(*,*) 'Setup finished.'
      RETURN
      END
