!    UV IRRADIATION CALCULATOR
!    Copyright (C) 2011-2013 by Ingo Thies
!
!    Uvcalc is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 2 of the License, or
!    (at your option) any later version.
!
!    Uvcalc is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with Uvcalc. If not, see <http://www.gnu.org/licenses/>.
!
!    This license applies to this main source file and to all related
!    source files in this package.
!
MODULE uvcalc_module
  IMPLICIT NONE
  INTEGER :: nepisodes=0,nepimax=100
  REAL(KIND=8) :: tepisode(0:1,1:100),dtepisode(1:100),scalepisode(1:100)
  REAL(KIND=8) :: tstart,tfinish,texpose,texpeff,time_offset,time0_local,utc_offset,dst_offset
  REAL(KIND=8) :: kboost
!  REAL(KIND=8),DIMENSION(6) :: tburn8_mm=(/5.d0,15.d0,25.d0,45.d0,75.d0,100.d0/)!est. from Wikipedia(de)
  REAL(KIND=8),DIMENSION(0:7) :: tburn8_mm=(/1.d0,5.d0,10.d0,20.d0,30.d0,60.d0,90.d0,120.d0/)!decimal interpolation
!                                               (0.0) 1.0  2.0   3.0   4.0   5.0   6.0  (7.0)
END MODULE uvcalc_module

MODULE math_constants
  REAL(KIND=8) :: pi=3.141592653589793238d0
  REAL(KIND=8) :: sig2hwhm=1.177410022515474691d0
  REAL(KIND=8) :: sig2fwhm=2.354820045030949382d0
END MODULE math_constants

MODULE func_params
  INTEGER,DIMENSION(10) :: iparams=(/0,0,0,0,0,0,0,0,0,0/)
  REAL(KIND=8),DIMENSION(10) :: dparams=(/0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0/)
END MODULE func_params

PROGRAM uvcalc
  USE uvcalc_module
  USE sunpath_core
  USE sunpath_constants, ONLY : d2r
  USE func_params
  IMPLICIT NONE
  EXTERNAL fuvi,fsol
!  INTEGER :: itype
  INTEGER :: i,j,n,ifound(0:12),flgdate,flgdst,poi,spf(3),idum
  INTEGER :: yr,mo,dd,hh,mm,ss,values(8)
  INTEGER :: yr0,mo0,dd0,dow0, nx, hdecmode
  REAL(KIND=8) :: dtype,poi_lat,poi_lon,poi_ltc,poi_dst,poi_elv,fsol,fuvi,dxi,dxt,simps1,simps2
  REAL(KIND=8) :: t,t0,t1,t2,dt,dtsec,offutc,thoff,dst,dref,JDref,JDdst0,JDdst1
  REAL(KIND=8) :: xair,eta(0:11),etag(0:11)!,trise,tculm,ttrans,tset,
  REAL(KIND=8) :: tsun(0:12),tsec(0:12)
  REAL(KIND=8) :: enhance_air,enhance_UV,x,y,y1,y2,y3
  REAL(KIND=8) :: t1max,t2max,t3max,y1max,y2max,y3max,tmax(3),ymax(3),dum,tdum
  REAL(KIND=8) :: ozone_du,ozone_00,ozone_90,o3_pwr,o3_ref=330.d0,o3_off=20.d0
  REAL(KIND=8) :: uvi_fluence(3),tburn,tscale,boostpct,kburn(3)
! (based on UVI = int_286nm^400nm I(lam)*w(lam) dlam -> solubv.f90
!  CHARACTER (LEN=12) :: thms_rise,thms_culm,thms_trans,thms_set
  CHARACTER (LEN=24) :: kind_of_light(3)=(/'Normal incidence (T1): ', &
                                           'Random incidence (T2): ', &
                                           'Scattered UV only (T3):'/)
  CHARACTER (LEN=11) :: thms,thmsi(3)
  CHARACTER (LEN=8) :: hhmmss(0:12)
  CHARACTER (LEN=50) :: name_poi,poifile
  CHARACTER (LEN=3) :: cdow0
  CHARACTER (LEN=1) :: cdum
  LOGICAL usedst,find_tmax,issouth
  LOGICAL skipcalc
  COMMON /caldst/ skipcalc
  skipcalc=.FALSE.
  OPEN(10,FILE='uvcalc.par')
  READ(10,*) ozone_du
  READ(10,*) ozone_00,ozone_90,o3_pwr
  READ(10,*) dtype,boostpct
!  READ(10,*) tstart,tfinish
  READ(10,*) dtsec,hdecmode
  READ(10,*) 
  DO i=1,nepimax
     READ(10,*,end=6,err=5) cdum
     idum=ichar(cdum)
!     WRITE(*,*) 'i,cdum,ichar =',i,cdum,idum
     IF (idum>=48.AND.idum<=57) THEN
        BACKSPACE(10)
        READ(10,*,end=6,err=5) tstart,tfinish,dum
        CALL episode2hours(hdecmode,tstart,tdum); tstart=tdum
        CALL episode2hours(hdecmode,tfinish,tdum); tfinish=tdum
     ELSE
        EXIT
     ENDIF
     IF (tepisode(0,i)<0.OR.tepisode(1,i)<0.) EXIT
     IF (dum==0.d0) CYCLE
     nepisodes=nepisodes+1
     tepisode(0,nepisodes)=tstart
     tepisode(1,nepisodes)=tfinish
     scalepisode(nepisodes)=dum
     IF (tepisode(0,nepisodes)>tepisode(1,nepisodes)) THEN
        WRITE(*,*) 'Rank mismatch at episode',i,' -- swapping'
        dum=tepisode(0,nepisodes)
        tepisode(0,nepisodes)=tepisode(1,nepisodes)
        tepisode(1,nepisodes)=dum
     ENDIF
!     WRITE(*,*) 'Episode',i,' =',tepisode(0,i),' --',tepisode(1,i),scalepisode(i)
  ENDDO
  GOTO 7
5 WRITE(*,*) 'List error after i =',nepisodes
  IF (nepisodes<1) THEN
     WRITE(*,*) 'No episodes found -> abort'
     STOP
  ELSE
     WRITE(*,*) 'Using',nepisodes,' episodes'
  ENDIF
  GOTO 7
6 WRITE(*,*) 'End of list'
7 CLOSE(10)
  WRITE(*,*) 'nepisodes =',nepisodes
  OPEN(11,FILE='sunpath.par')
  READ(11,*) latitude,longitude,poi
  READ(11,*) flgdate
  READ(11,*) yr0,mo0,dd0
  READ(11,*) dum,offutc,dst
  READ(11,*) dum,dum,pscal_surface
  READ(11,*) dum,z_surface
  READ(11,*)
  READ(11,*)
  READ(11,*)
  READ(11,*)
  READ(11,*)
  READ(11,*)
  READ(11,*) poifile
  CLOSE(11)
  IF (poi>=1) THEN
     OPEN(12,FILE=trim(poifile),STATUS='OLD')
     DO i=1,poi+1
        READ(12,*,end=11,err=11)
     ENDDO
     READ(12,*,end=11,err=11) idum,poi_lat,poi_lon,poi_ltc,poi_dst,poi_elv,name_poi
     GOTO 12
11    WRITE(*,*) 'POI not available (end of file?)'
     WRITE(*,*) 'Using manual input instead.'
     WRITE(*,*) 'i =',i
     GOTO 13
12   latitude=poi_lat
     longitude=poi_lon
     offutc=poi_ltc
     dst=poi_dst
     IF (z_surface<0.d0) THEN
        z_surface=poi_elv
        PRINT *,'Using elevation from POI table:',nint(poi_elv),' m'
     ELSE
        PRINT *,'Using elevation from user input.'
     ENDIF
     WRITE(*,'(2A)') 'Using Point of Interest: ',trim(name_poi)
     WRITE(*,'(A,2(F9.4,A))') 'at lat,lon = ',poi_lat,' deg N, ',poi_lon,' deg E'
13   CLOSE(12)
  ELSE
     WRITE(*,'(A,2(F9.4,A))') 'Using manual coordinates = ',latitude,' deg N, ',longitude,' deg E'
  ENDIF
  issouth=latitude<0.d0!OK, just a dirty hack...
  IF (ozone_du<0.d0) THEN
     x=latitude*d2r
     ozone_du=ozone_90+(ozone_00-ozone_90)*cos(x)**o3_pwr!empirical interpolation
!     write(*,*) 'ozone_00,ozone_90 =',ozone_00,ozone_90
!     write(*,*) 'ozone_00-ozone_90 =',ozone_00-ozone_90
!     write(*,*) 'latitude,ozone_du =',latitude,ozone_du
  ENDIF
  WRITE(*,'(A,F4.0,A)') 'Ozone  = ',ozone_du,' DU'
  kboost=1.d0+1.d-2*boostpct
  enhance_air=(ozone_du+o3_off)/(o3_ref+o3_off)
  dparams(2)=enhance_air
  dparams(3)=enhance_UV
  CALL skin_types(dtype,tburn)
! Time scaling factors: days->minutes
  tscale=tburn/180.d0!note that tburn refers to UVI=8, so divide by 180, not 1440.
  texpose=0.d0
  texpeff=0.d0
  DO i=1,nepisodes
     tepisode(0,i)=tepisode(0,i)/24.d0
     tepisode(1,i)=tepisode(1,i)/24.d0
     dtepisode(i)=(tepisode(1,i)-tepisode(0,i))
     texpose=texpose+dtepisode(i)
     texpeff=texpeff+scalepisode(i)*dtepisode(i)
     WRITE(*,'(A,I3,2(A,F6.2),A,F5.0,A,F5.2)') 'Episode',i,' =', &
          2.4d1*tepisode(0,i),' --',2.4d1*tepisode(1,i),    &
          ';  texpose =',1.44d3*dtepisode(i),' min; scal =',scalepisode(i)
  ENDDO
!  tstart=tstart/24.d0
!  tfinish=tfinish/24.d0
!  texpose=(tfinish-tstart)
  usedst=abs(dst)>1.d-2
  hh=0;mm=0;ss=0
  IF (flgdate<=0) THEN
     CALL Date_and_Time(values=values)
     yr0=values(1)
     mo0=values(2)
     dd0=values(3)
  ENDIF
  yr=yr0;mo=mo0;dd=dd0
!  WRITE(*,'(A,I4.4,2('':'',I2.2))') 'YYYY,MM,DD',yr,mo,dd
  CALL DAT2JD(yr,mo,dd,hh,mm,ss,0,JDref)
  CALL JD2DOW(JDref,dow0,cdow0,0,0)
  IF (issouth) THEN
     CALL getdst(JDref+183.d0,flgdst,0)!today's 12-month inverted DST flag
  ELSE
     CALL getdst(JDref+0.5d0,flgdst,0)!today's DST flag
  ENDIF
!  CALL getdst(JDref+0.5d0,flgdst,0)!get DST for this day (try for 12 UT)
  WRITE(*,'(A,I4.4,''-'',I2.2,''-''I2.2)') 'Date: ',yr,mo,dd
  time_offset=offutc+flgdst*dst
  utc_offset=offutc
  dst_offset=flgdst*dst
  dref=JDref-2451544.5d0! = days wrt. 2000-01-01 00 UT
  t0=dref-time_offset/24.d0
  time0_local=t0
  write(*,*) 't0       =',t0
!  t1=t0+tstart
!  t2=t0+tfinish
!  write(*,*) 'tscale   =',tscale
!  write(*,*) 'ts,tf,te =',tstart,tfinish,texpose
!  write(*,*) 't0,t1,t2 =',t0,t1,t2
!  write(*,*) 'u_offset =',utc_offset
!  write(*,*) 'd_offset =',dst_offset
!  write(*,*) 't_offset =',time_offset
  iparams(1)=0
  iparams(2)=1
  dparams(1)=1.5d0
  dxi=0.5d0
!  OPEN(20,FILE='uvcalc.out')
  y=fsol(500.d0)
  y=simps1(fsol,280.d0,4000.d0,dxi)
  iparams(2)=1
  iparams(10)=0!diagnostics output
  ymax=0.d0
  dt=dtsec/8.64d4
  nx=nint(1.d0/dt)
  OPEN(20,FILE='uvcalc.dat')
  WRITE(20,1411) 'T/h','UVI','T1/min','T2/min','T3/min'
  DO i=0,nx
     t=t0+dt*i
     CALL t2hms(8.64d4*(t-t0),thms)
     iparams(2)=1
     y1=fuvi(t)
     iparams(2)=2
     y2=fuvi(t)
     iparams(2)=3
     y3=fuvi(t)
     IF (y1>ymax(1)) THEN
        ymax(1)=y1
        tmax(1)=t
        thmsi(1)=trim(thms(4:8))
     ENDIF
     IF (y2>ymax(2)) THEN
        ymax(2)=y2
        tmax(2)=t
        thmsi(2)=trim(thms(4:8))
     ENDIF
     IF (y3>ymax(3)) THEN
        ymax(3)=y3
        tmax(3)=t
        thmsi(3)=trim(thms(4:8))
     ENDIF
     IF (alt_refract>0.5d0) THEN
!        WRITE(20,1400) 24.d0*(t-t0),y1,120.d0/y1,120.d0/y2,120.d0/y3
        WRITE(20,1410) thms(4:11),y1,120.d0/y1,120.d0/y2,120.d0/y3
     ENDIF
  ENDDO
  CLOSE(20)
!  dxi=texpose/16.d0
  iparams(10)=0!diagnostics output
  DO i=1,3
     iparams(2)=i
     uvi_fluence(i)=0.d0
     DO j=1,nepisodes
        t1=t0+tepisode(0,j)
        t2=t0+tepisode(1,j)
        dxi=dtepisode(j)/16.d0
        uvi_fluence(i)=uvi_fluence(i)+scalepisode(j)*simps2(fuvi,t1,t2,dxi)
!        IF (i==1) WRITE(*,*) 't10,t20,dt,fluence =',24*(t1-t0),24*(t2-t0),24*(t2-t1),uvi_fluence(i)
     ENDDO
     kburn(i)=uvi_fluence(i)/tscale
     spf(i)=int(kburn(i))+1
  ENDDO
  WRITE(*,*) 
  WRITE(*,2002) nint(1.44d3*texpose),nint(1.44d3*texpeff)
  WRITE(*,*) 
  DO i=1,3
     WRITE(*,'(A)') kind_of_light(i)
     IF (kburn(i)>1.d0) THEN
        WRITE(*,2000) ymax(i),thmsi(i),uvi_fluence(i)/texpose,kburn(i),spf(i)
     ELSE
        WRITE(*,2005) ymax(i),thmsi(i),uvi_fluence(i)/texpose,kburn(i)
     ENDIF
  ENDDO
!  WRITE(*,'(A)') 'Normal incidence (T1):'
!  WRITE(*,2000) y1max,thms1,uvi_fluence(1)/texpose,kburn(1),spf(1)
!  WRITE(*,'(A)') 'Random incidence (T2):'
!  WRITE(*,2000) y2max,thms2,uvi_fluence(2)/texpose,kburn(2),spf(2)
!  WRITE(*,'(A)') 'Scattered UV only (T3):'
!  WRITE(*,2000) y3max,thms3,uvi_fluence(3)/texpose,kburn(3),spf(3)
1205 FORMAT(1X,I4.4,2('-',I2.2),1X,2(I2.2,':'),I2.2, 2X,F9.3,2X,F9.6,2(2X,F9.1))
1400 FORMAT(F6.2,2X,4(2X,F6.1))
1401 FORMAT(A6,  2X,4(2X,A6))
1410 FORMAT(A12,2X,4(2X,F6.1))
1411 FORMAT(A12,2X,4(2X,A6))
1500 FORMAT(A,F5.2)
!1600 FORMAT(A,'*',I2,'*')
1600 FORMAT(A,I2)
2002 FORMAT('Total exposure time:',I4,' minutes'/ &
            'Effective exposure :',I4,' minutes')
2000 FORMAT('Max. UVI           =',F7.2,' at ',A12/     &
            'Mean UVI           =',F7.2/     &
            'UVI fluence / tol. =',F7.2,4X,  &
            '*** Required SPF   =',I4,' ***'/)
2005 FORMAT('Max. UVI           =',F7.2,' at ',A12/     &
            'Mean UVI           =',F7.2/     &
            'UVI fluence / tol. =',F7.2,4X,  &
            '(no protection required)'/)
END PROGRAM uvcalc

FUNCTION fuvi(t)
  USE uvcalc_module
  USE sunpath_core
  USE sunpath_constants, ONLY : d2r
  USE func_params
  USE math_constants
  IMPLICIT NONE
  EXTERNAL fsol
  INTEGER flgdst
  INTEGER :: yr,mo,dd,hh,mm,ss
  REAL(KIND=8) :: fuvi,simps1,fsol,dx1,uvi
  REAL(KIND=8) :: uv1=0.025d0!UV index 1 equivalent
  REAL(KIND=8) :: t,xair,eta(0:11),etag(0:11),etad(0:11),ydir,ysct,ysum
  JDnow=t+2451544.5d0
  CALL calc_sunpath
  CALL calc_airmass(altitude,xair,eta,etag,etad)
  IF (alt_refract<0.5d0) THEN!skip dawn and twilight
     fuvi=0.d0
     RETURN
  ENDIF
  dparams(1)=xair
  iparams(1)=1
  dx1=0.5d0
  ydir=simps1(fsol,280.d0,400.d0,dx1)
  iparams(1)=2
  ysct=simps1(fsol,280.d0,400.d0,dx1)
  IF (iparams(2)==1) THEN
!     write(*,*) 'case 1'
     ysum=ysct+ydir
  ELSE IF (iparams(2)==2) THEN
!     write(*,*) 'case 2'
     ysum=ysct+ydir/(2.d0*pi)
  ELSE IF (iparams(2)==3) THEN
!     write(*,*) 'case 3'
     ysum=ysct
  ENDIF
  fuvi=ysum/uv1*kboost
!  fuvi=uvi(altitude,300.d0)
!  fuvi=ysum
  IF (iparams(10)==1) WRITE(*,*) 'p,fuvi =',iparams(2),fuvi
  RETURN
END FUNCTION fuvi

FUNCTION fsol(x)
  USE math_constants
!  USE UBV_filters
  USE func_params
  IMPLICIT NONE
  INTEGER mode
  REAL(KIND=8) :: fsol,enhance_air,enhance_UV,scale_air=1.d0,scale_UV=1.d0!,airref=1.5d0
  REAL(KIND=8) :: x,yext,yglo,ydir,ynsc,ysol,wy,fuvcie,ssdum
  REAL(KIND=8) :: kd,fkd,fd,kn,fkn,fn,xair
  mode=iparams(1)
  xair=dparams(1)
  enhance_air=dparams(2)*scale_air!scale to observed UVI (near-equator, sea-level: ~12)
  enhance_UV=1.d0*scale_UV
  CALL uvair1(1,x,yext)
  CALL uvair1(3,x,ydir)
  fkd=ydir/max(yext,1.d-30)
  kd=-enhance_air*log(max(fkd,1.d-30))!/airref
  fd=exp(-xair*kd)
!  IF (xair*kd<230.d0) WRITE (*,*) 'xair*kd =',xair*kd
  wy=fuvcie(x)
  IF (mode==0) THEN
     ysol=yext
!     RETURN
  ELSE IF (mode==1) THEN!direct
     ysol=yext*fd
  ELSE IF(mode==2) THEN!scattered
     CALL uvair1(2,x,yglo)
     fkn=ydir/max(yglo,1.d-30)
     kn=-enhance_air*log(max(fkn,1.d-30))!/airref
!     fn=exp(-xair*kn)!ratio of direct vs. global (i.e. non-scattered) light
     fn=exp(-min(xair*kn,230.d0))!ratio of direct vs. global (i.e. non-scattered) light
     ysol=yext*fd*(1.d0-fn)/fn!scattered intensity from direct and non-scattered fraction
  ENDIF
  fsol=ysol*fuvcie(x) * enhance_UV
  RETURN
END FUNCTION fsol

FUNCTION uvi(altdeg,odobson)
  IMPLICIT NONE
  REAL(KIND=8) :: uvi,d2r=1.74532925199432957692d-2
  REAL(KIND=8) :: altdeg,odobson,mu0,omega
  mu0=sin(altdeg*d2r)
  omega=odobson/300.d0
  uvi=12.5d0 * mu0**2.42d0 / omega**1.23d0
END FUNCTION uvi

SUBROUTINE skin_types(dtype,tburn)
  USE uvcalc_module, ONLY : tburn8_mm
  IMPLICIT NONE
  INTEGER :: itype0,itype1
  REAL(KIND=8) :: dtype,tburn,u
  IF (dtype<0.d0.OR.dtype>7.d0) THEN
     WRITE(*,*) '*** SKIN TYPE OUT OF RANGE ***'
     WRITE(*,*) '*** using min/max instead  ***'
     dtype=max(min(dtype,6.d0),1.d0)
  ENDIF
  itype0=int(dtype)
  itype1=itype0+1
  u=dtype-dble(itype0)
  tburn=u*tburn8_mm(itype1)+(1.d0-u)*tburn8_mm(itype0)
  write(*,'(A,I4,A)') 't_burn at UVI=8: ',nint(tburn),' minutes'
  RETURN
END SUBROUTINE skin_types

SUBROUTINE episode2hours(mode,tinp,tuse)
  IMPLICIT NONE
  INTEGER :: mode
  REAL(KIND=8) :: tinp,tuse,hours,hdec
  IF (mode>=1) THEN
     hours=int(tinp)
     hdec=(tinp-hours)/0.6d0
     tuse=hours+hdec
     print '(a,2(1x,f12.6))','tinp,tuse =',tinp,tuse
  ELSE
     tuse=tinp
  ENDIF
  RETURN
END SUBROUTINE episode2hours
